<?php $__env->startSection('content'); ?>
    <?php if($page == 'invoice'): ?>
        <?php
        $header = __('xinvoice::invoice.headings.invoice_list');
        $createLink = 'invoice/create';
        $createText = __('xinvoice::invoice.buttons.new_invoice');
        ?>
    <?php elseif($page == 'estimate'): ?>
        <?php
        $header = __('estimate.headings.estimate_list');
        $createLink = 'estimate/create';
        $createText = __('estimate.buttons.new_estimate');
        ?>
    <?php endif; ?>
    <input type="hidden" name="page" id="page" value="<?php echo e($page ?? ''); ?>">
    <input type="hidden" name="invoice_type" id="invoice_type" value="<?php echo e($invoice_type ?? ''); ?>">


    <!-- Dashboard wrapper starts -->
    <div class="dashboard-wrapper">

        <!-- Top bar starts -->
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <?php if(isset($invoice_type) && $invoice_type == 'all'): ?>
                            <h4>Orders List</h4>
                        <?php elseif(isset($invoice_type) && $invoice_type == 'QUICK'): ?>
                            <h4>Quick Orders List</h4>
                        <?php elseif(isset($invoice_type) && $invoice_type == 'ORDERS'): ?>
                            <h4>Orders List</h4>
                        <?php elseif(isset($invoice_type) && $invoice_type == 'DISPATCH'): ?>
                            <h4>Ready to Dispatch List</h4>
                        <?php elseif(isset($invoice_type) && $invoice_type == 'INVOICE'): ?>
                            <h4>Invoice List</h4>
                        <?php endif; ?>
                    </div>
                </div>
                <?php
                    $create_invoice_flag = false;
                    if (
                        auth()
                            ->user()
                            ->can('ADD_INVOICE') ||
                        auth()
                            ->user()
                            ->can('ORDER_CREATE')
                    ) {
                        $create_invoice_flag = true;
                    }
                ?>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <?php if($create_invoice_flag): ?>
                        <ul class="right-stats" id="mini-nav-right">
                            <a href="<?php echo e(url('invoice/create')); ?>" class="btn btn-primary"><i class="fa fa-plus"
                                    aria-hidden="true"></i>
                                <?php echo e(__('xinvoice::invoice.buttons.new_invoice')); ?></a>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- Top bar ends -->
        <!-- Main container starts -->
        <div class="main-container">
            <!-- Row starts -->
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="<?php echo e(route('invoice.index')); ?>">
                                <div class="form-inline data_list_filters">

                                    <div class="form-group">
                                        <label for="">Invoice Number</label> <br>
                                        <input type="text" name="invoice_code" value="<?php echo e(request('invoice_code')); ?>"
                                            class="form-control" id="searchinvoicecode" placeholder="Invoice #">
                                    </div>
                                    <div class="form-group">

                                        <div class="col-sm-12">
                                            <br>
                                            <label for="">INVOICE Date</label><br>
                                            <input name="invoice_date" value="<?php echo e(request('invoice_date')); ?>"
                                                style="margin-bottom: 20px;" class="form-control dates">
                                        </div>
                                    </div>
                                    <div class="form-group">

                                        <label for="">Select Rep</label> <br>
                                        <select name="rep_id" id="rep" class="form-control select2 select3">
                                            <option value="">Select Rep</option>
                                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                
                                                <option value="<?php echo e($role->id); ?>"
                                                    <?php if(request('rep') == $role->id): ?> selected <?php endif; ?>><?php echo e($role->username); ?>

                                                    - <?php echo e($role->fname); ?> </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                    </div>
                                    <div class="form-group">
                                        <label for="">Customer</label> <br>
                                        <input type="text" name="customer_name" class="form-control"
                                            id="searchcustomername"
                                            placeholder="<?php echo e(__('xinvoice::invoice.labels.customer')); ?>"
                                            value="<?php echo e(request('customer_name')); ?>">
                                    </div>
                                    <div class="form-group">
                                        <br>
                                        &nbsp; <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                            <label class="btn btn-success active">
                                                <input type="radio" name="payment_status" value=""
                                                    <?php if(request('payment_status') == ''): ?> checked <?php endif; ?>> All
                                            </label>

                                            <label class="btn btn-success">
                                                <input type="radio" name="payment_status" value="Pending"
                                                    <?php if(request('payment_status') == 'Pending'): ?> checked <?php endif; ?>> Pending
                                            </label>
                                            <label class="btn btn-success" data-toggle="tooltip" data-placement="top"
                                                title="Payment Status" id="all_payment_status">
                                                <input type="radio" name="payment_status" value="Partial"
                                                    <?php if(request('payment_status') == 'Partial'): ?> checked <?php endif; ?>> Partial
                                            </label>
                                            <label class="btn btn-success">
                                                <input type="radio" name="payment_status" value="Completed"
                                                    <?php if(request('payment_status') == 'Completed'): ?> checked <?php endif; ?>> Completed
                                            </label>
                                            <input type="hidden" name="invoice_type" value="<?php echo e($invoice_type); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <br>&nbsp;&nbsp;<button type="submit" style="margin-top: 10px;"
                                            class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Submit</button>
                                    </div>
                                    <div class="form-group">
                                        <br>&nbsp;&nbsp;

                                        <a href="<?php echo e(url('invoice?invoice_type=' . $invoice_type)); ?>"
                                            style="margin-top: 10px;"
                                            class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Reset</a>
                                    </div>
                                </div>
                            </form>

                        </div>

                    </div>
                    <div class="table-responsive">
                        <table id="invoiceListTable" class="table table-striped table-bordered no-margin" cellspacing="0"
                            width="100%">
                            <thead>
                                <tr>
                                    <th hidden></th>
                                    <th><?php echo e(__('xinvoice::invoice.labels.invoice_no')); ?></th>
                                    <th><?php echo e(__('xinvoice::invoice.labels.invoice_date')); ?></th>
                                    <th><?php echo e(__('xinvoice::invoice.labels.customer')); ?></th>
                                    <th><?php echo e(__('xinvoice::invoice.labels.total')); ?></th>
                                    <th>Rep</th>
                                    <th>Remarks</th>
                                    <th>Payment Status</th>
                                    <th><?php echo e(__('xinvoice::invoice.labels.status')); ?></th>
                                    <th><?php echo e(__('xinvoice::invoice.labels.created_by')); ?></th>
                                    <th>Action</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td hidden><?php echo e($invoice->id); ?></td>
                                        <td><?php echo e($invoice->invoice_code); ?></td>
                                        <td><?php echo e($invoice->invoice_date); ?></td>
                                        <td>
                                            <?php if(isset($invoice->customer->company_name)): ?>
                                                <strong><?php echo e($invoice->customer->company_name); ?></strong><br>
                                            <?php endif; ?>

                                            <?php if(isset($invoice->customer->fullname)): ?>
                                                <?php echo e($invoice->customer->fullname); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(App\Http\Helper::formatPrice($invoice->total)); ?></td>
                                        <td><?php echo e($invoice->rep->username ?? 'N/A'); ?></td>
                                        <td><?php echo e($invoice->remarks); ?></td>
                                        <td>
                                            <?php
                                                $outstanding_amount = App\Utils\CommonUtil::calculateInvoiceOutstanding($invoice->id);
                                            ?>

                                            <?php if($outstanding_amount <= 0): ?>
                                                <span class="text-success"><strong>Completed</strong></span>
                                            <?php else: ?>
                                                <span class="text-danger"><strong>Pending</strong>
                                                    <?php echo e(Carbon\Carbon::parse($invoice->invoice_date)->diffInDays(Carbon\Carbon::now(), false)); ?>

                                                    Days</span>
                                                <p><?php echo e(App\Http\Helper::formatPrice($outstanding_amount)); ?></p>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($invoice->customer == null): ?>
                                                <strong>Quick Sell</strong>
                                            <?php elseif($invoice->status == 'O'): ?>
                                                <span class="text-danger"><strong>Order</strong></span>
                                            <?php elseif($invoice->status == 'D'): ?>
                                                <span class="text-success"><strong>Ready to Dispatch</strong></span>
                                            <?php elseif($invoice->status == 'I'): ?>
                                                <span class="text-primary">Invoice</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($invoice->user->username); ?></td>
                                        <?php
                                            $delete_invoice_permission = Auth::user()->can(['DELETE_INVOICE']);
                                            $edit_invoice_permission = false;
                                            if (Auth::user()->can('EDIT_INVOICE')) {
                                                $edit_invoice_permission = true;
                                            }

                                        ?>
                                        <td>
                                            <?php if($edit_invoice_permission): ?>
                                                <a class="btn btn-info btn-xs"
                                                    href="<?php echo e(url('/invoice/' . $invoice->id . '/edit')); ?>"
                                                    id="edit_invoice" data-original-title="" title=""><i
                                                        class="fa fa-pencil"></i></a>
                                            <?php endif; ?>

                                            <?php if($delete_invoice_permission): ?>
                                                &nbsp;<button class="delete_invoice btn btn-danger btn-xs"
                                                    data-toggle="tooltip" data-placement="right" title=""
                                                    data-original-title="Delete " aria-describedby="tooltip934027"><i
                                                        class="fa fa-trash-o" aria-hidden="true"></i></button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <div class="d-flex justify-content-end">
                            <?php echo e($invoices->appends($_GET)->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
            <!-- Row ends -->
        </div>
        <!-- Main container ends -->
    </div>
    <!-- Dashboard wrapper ends -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('include_js'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function() {

            $('#all_payment_status').tooltip('show');
            $('#all_status').tooltip('show');

            if ($('#page').val() == 'invoice') {
                // var invoiceListTable = $('#invoiceListTable').DataTable({
                //     'iDisplayLength': 15,
                //     ajax: BASE + 'invoices_list?invoice_type=' + $('#invoice_type').val(),
                //     order: [
                //         [0, "desc"]
                //     ],
                //     processing: true,
                //     serverSide: true,
                //     columns: [{
                //             data: 'id',
                //             name: 'id',
                //             'bVisible': false
                //         },
                //         {
                //             data: 'invoice_code',
                //             name: 'invoice_code'
                //         },
                //         {
                //             data: 'invoice_date',
                //             name: 'invoice_date'
                //         },
                //         {
                //             data: 'customer',
                //             name: 'customer'
                //         },
                //         {
                //             data: 'total',
                //             name: 'total',
                //             className: 'dt-body-right'
                //         },

                //         {
                //             data: 'rep_id',
                //             name: 'rep_id',

                //         },
                //         {
                //             data: 'remarks',
                //             name: 'remarks',

                //         },
                //         {
                //             data: 'payment_status',
                //             name: 'payment_status'
                //         },
                //         {
                //             data: 'status',
                //             name: 'status',
                //             'bVisible': false
                //         },
                //         {
                //             data: 'created_by',
                //             name: 'created_by'
                //         },
                //         {
                //             data: 'action',
                //             name: 'action'
                //         },
                //     ]
                // });
            }


            $(document).on('click', '.delete_invoice', function(e) {
                var data = {};
                var firstTDValue = $(this).closest('tr').find('td:first').text().trim();
                data['id'] = firstTDValue;
                var parent = $(this).parents('tr');

                var delete_confirm = $.confirm({
                    title: "Delete Invoice",
                    type: 'red',
                    buttons: {
                        delete: {
                            text: 'Delete',
                            btnClass: 'btn-red',
                            action: function() {

                                e.preventDefault();
                                var params = {

                                };

                                $.ajax({
                                    url: BASE + 'invoice/' + data['id'],
                                    type: 'DELETE',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function(response) {
                                        if (response.status == 'error') {
                                            delete_confirm.close();
                                            notification(response);
                                        } else {

                                            delete_confirm.close();

                                            notification(response);
                                            location.reload();

                                        }
                                    },
                                    error: function(errors) {

                                    }
                                });
                                e.preventDefault();
                                return false;
                            }
                        },
                        close: function() {}
                    }
                });
            });

            $('#invoice_date_created').on('change', function() {
                invoiceListTable.column(2)
                    .search(this.value)
                    .draw();
            })

            $('#searchinvoicecode').on('keyup', function() {
                invoiceListTable.column(1)
                    .search(this.value)
                    .draw();
            });

            $('#searchcustomername').on('keyup', function() {
                invoiceListTable.column(3)
                    .search(this.value)
                    .draw();
            });

            $('#searchrep').on('keyup', function() {
                invoiceListTable.column(3)
                    .search(this.value)
                    .draw();
            });

            $('input[type=radio][name=payment_status]').change(function() {
                invoiceListTable.column(8)
                    .search(this.value)
                    .draw();
            });
            $('input[type=radio][name=invoice_status]').change(function() {
                invoiceListTable.column(9)
                    .search(this.value)
                    .draw();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/packages/pramix/xinvoice/src/views/invoices_list.blade.php ENDPATH**/ ?>