<!DOCTYPE html>
<html lang="en">

<head>

    
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        .double_hr {
            overflow: visible;
            /* For IE */
            padding: 0;
            border: none;
            border-top: medium double #333;
            color: #333;
            text-align: center;
            margin-bottom: 10px;
        }

        hr {
            margin: 3px;
        }

        p.date {
            position: absolute;
            top: 0;
            right: 0;
        }
    </style>

</head>

<body>

    <div class="main-container">
        <?php
            $currentDate = \Carbon\Carbon::now()->format('Y-m-d');
        ?>
        <p class="date"><?php echo e($currentDate); ?></p>

        <div class="row">
            <div class="col-xs-6">
                <p><?php echo e(getConfigArrayValueByKey('COMPANY_DETAILS', 'company_name')); ?></p>
                <p>OUTSTANDING REPORT</p>
            </div>
        </div>
        <table style="width: 100%">
            <tr>
                <th style="width: 12%">Invoice #</th>
                <th style="width: 12%">Date</th>
                <th style="width: 10%">Description</th>
                <th style="width: 14%; text-align: right;">Debit</th>
                <th style="width: 14%; text-align: right;">Credit</th>
                <th style="width: 14%; text-align: right;">Return</th>
                <th style="width: 14%; text-align: right;">Discount</th>
                <th style="width: 14%; text-align: right;">Balance</th>
                <th style="width: 14%; text-align: right;">No of Days</th>
            </tr>
        </table>
        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <strong>Debator :</strong> <?php echo e($customer['customer']->company_name ?? ''); ?>

            <?php echo e($customer['customer']->business_name ?? ''); ?> | <strong>Rep
                :</strong> <?php echo e($repName); ?> <br>
            <hr>
            <?php
                $total_invoice_amount = 0;
                $total__paid_amount = 0;
                $total__return_amount = 0;
                $total_balance_total = 0;
                $total_discount_amount = 0;

            ?>
            <table style="width: 100%">
                <?php $__currentLoopData = $customer['invoices']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="width: 12%"><?php echo e($invoice['invoiceCode']); ?></td>
                        <td style="width: 12%"><?php echo e($invoice['date']); ?></td>
                        <td style="width: 20%; text-align: center;"><?php echo e($invoice['remarks']); ?></td>
                        <td style="width: 14%; text-align: right;"><?php echo e($invoice['total']); ?></td>
                        <td style="width: 14%; text-align: right;"><?php echo e($invoice['totalPaid']); ?></td>
                        <td style="width: 14%; text-align: right;"><?php echo e($invoice['totalReturns']); ?></td>
                        <td style="width: 14%; text-align: right;"><?php echo e($invoice['totalDiscounts']); ?></td>
                        <td style="width: 14%; text-align: right;"><?php echo e($invoice['outstanding']); ?></td>
                        <td style="width: 12%; text-align: center;"><?php echo e($invoice['daysCount']); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr>
                <th style="width: 12%">Total</th>
                <th style="width: 12%"></th>
                <th style="width: 20%"></th>
                <th style="width: 14%; text-align: right;"><?php echo e($customer['totals']['invoiceTotal']); ?></th>
                <th style="width: 14%; text-align: right;"><?php echo e($customer['totals']['paidTotal']); ?></th>
                <th style="width: 14%; text-align: right;"><?php echo e($customer['totals']['returnTotal']); ?></th>
                <th style="width: 14%; text-align: right;"><?php echo e($customer['totals']['discountTotal']); ?></th>
                <th style="width: 14%; text-align: right;"><?php echo e($customer['totals']['outstandingTotal']); ?></th>
                <th style="width: 14%; text-align: right;">&nbsp;</th>
                </tr>
            </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <hr class="double_hr">
    </div>

</body>

</html>
<?php /**PATH /var/www/html/cmk-portal/packages/pramix/xreports/src/views/sales/customer_outstanding/customer_outstanding_report.blade.php ENDPATH**/ ?>