<?php $__env->startSection('content'); ?>
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>Discount & Credit</h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('CREATE_DISCOUNT_AND_CREDIT')): ?>
                        <ul class="right-stats" id="mini-nav-right">
                            <a href="<?php echo e(route('bulk_discounts.create')); ?>" class="btn btn-primary"><i class="fa fa-plus"
                                    aria-hidden="true"></i>
                                Create Discount & Credit</a>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="main-container">
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">

                        <div class="card-body">
                            <form action="<?php echo e(route('bulk_discounts.index')); ?>">

                                <div class="form-inline data_list_filters">

                                    <div class="form-group">
                                        <label for="">Invoice Number</label> <br>
                                        <input type="text" name="invoice_code" value="<?php echo e(request('invoice_code')); ?>" class="form-control" id="searchinvoicecode"
                                            placeholder="Invoice #">
                                    </div>
                                    <div class="form-group">

                                        <div class="col-sm-12">
                                            <br>
                                            <label for="">INVOICE Date</label><br>
                                            <input name="invoice_date" value="<?php echo e(request('invoice_date')); ?>" style="margin-bottom: 20px;" class="form-control dates">
                                        </div>
                                    </div>
                                    <div class="form-group">

                                        <label for="">Select Rep</label> <br>

                                        <select name="rep_id" id="rep" class="form-control select2 select3">
                                            <option value="">Select Rep</option>
                                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            
                                            <option value="<?php echo e($role->id); ?>" <?php if(request('rep') == $role->id): ?> selected <?php endif; ?>><?php echo e($role->username); ?> - <?php echo e($role ->fname); ?>  </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                    </div>
                                    <div class="form-group">
                                        <label for="">Customer</label> <br>
                                        <input type="text" name="customer_name" class="form-control" id="searchcustomername"
                                            placeholder="<?php echo e(__('xinvoice::invoice.labels.customer')); ?>" value="<?php echo e(request('customer_name')); ?>">
                                    </div>

                                    <div class="form-group">
                                        <br>&nbsp;&nbsp;<button type="submit" style="margin-top: 10px;" class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Submit</button>
                                    </div>
                                    <div class="form-group">
                                        <br>&nbsp;&nbsp; <a href="<?php echo e(route('bulk_discounts.index')); ?>" style="margin-top: 10px;" class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Reset</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                    <div class="table-responsive">
                        <table id="bulk_discount_list" class="table table-striped table-bordered no-margin" cellspacing="0"
                            width="100%">
                            <thead>
                                <tr>
                                    <th hidden></th>
                                    <th>Code</th>
                                    <th>Customer</th>
                                    <th>Rep</th>
                                    <th>Date</th>
                                    <th>Remarks</th>
                                    <th>Total Discount</th>
                                    <th><?php echo e(__('common.labels.action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $bulkDiscounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bulkDiscount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td hidden><?php echo e($bulkDiscount->id); ?></td>
                                    <td><?php echo e($bulkDiscount->invoice_code); ?></td>
                                    <td><?php echo e($bulkDiscount->customer->company_name ?? 'N/A'); ?></td>
                                    <td><?php echo e($bulkDiscount->customer->rep->username ?? 'N/A'); ?></td>
                                    <td><?php echo e(Carbon\Carbon::parse($bulkDiscount->date)->format('Y-m-d')); ?></td>
                                    <td><?php echo e($bulkDiscount->remarks); ?></td>
                                    <td><?php echo e(App\Http\Helper::formatPrice($bulkDiscount->total_discount)); ?></td>
                                    <td>
                                        <?php
                                                $edit_invoicer_permission = false;
                                                $delete_credit_note_permission = false;
                                                if (Auth::user()->can('EDIT_CREDIT_NOTE')) {
                                                    $edit_invoicer_permission = true;
                                                }
                                                if (auth()->user()->can('DELETE_DISCOUNT_AND_CREDIT')) {
                                                    $delete_credit_note_permission = true;
                                                }
                                        ?>
                                        <?php if($edit_invoicer_permission): ?>
                                            <a class="btn btn-info btn-xs" href="<?php echo e(route('bulk_discounts.edit', $bulkDiscount->id)); ?>" id="delete_bulk_invoice" data-original-title="" title=""><i class="fa fa-eye"></i></a>
                                        <?php endif; ?>
                                        <?php if($delete_credit_note_permission): ?>
                                            &nbsp;<button class="delete_credit_note btn btn-danger btn-xs" data-toggle="tooltip" data-placement="right" title="Delete Credit Note" data-original-title="Delete" aria-describedby="tooltip934027"><i class="fa fa-trash-o" aria-hidden="true"></i></button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <div class="d-flex justify-content-end">
                            <?php echo e($bulkDiscounts->appends($_GET)->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function() {

            $('#all_status').tooltip('show');

            // var bulk_discount_list = $('#bulk_discount_list').DataTable({
            //     'iDisplayLength': 15,
            //     ajax: '<?php echo route('bulk_discounts.index'); ?>',
            //     order: [
            //         [0, "desc"]
            //     ],
            //     columns: [{
            //             data: 'id',
            //             name: 'id',
            //             'bVisible': false
            //         },
            //         {
            //             data: 'invoice_code',
            //             name: 'invoice_code'
            //         },

            //         {
            //             data: 'company_name',
            //             name: 'company_name'
            //         },
            //         {
            //             data: 'rep',
            //             name: 'rep'
            //         },
            //         {
            //             data: 'date',
            //             name: 'date'
            //         },
            //         {
            //             data: 'remarks',
            //             name: 'remarks'
            //         },
            //         {
            //             data: 'total_discount',
            //             name: 'total_discount',
            //             className: 'dt-body-right'
            //         },
            //         {
            //             data: 'action',
            //             name: 'action'
            //         },
            //     ]
            // });

            $('#invoice_date_created').on('change', function(){
                bulk_discount_list.column(4)
                    .search(this.value)
                    .draw();
            })

            $('#searchinvoicecode').on('keyup', function() {
                bulk_discount_list.column(1)
                    .search(this.value)
                    .draw();
            });
            $('#searchinvoiceycode').on('keyup', function() {
                bulk_discount_list.column(1)
                    .search(this.value)
                    .draw();
            });
            $('#searchcustomername').on('keyup', function() {
                bulk_discount_list.column(2)
                    .search(this.value)
                    .draw();
            });
            $('#searchrep').on('keyup', function() {
                bulk_discount_list.column(3)
                    .search(this.value)
                    .draw();
            });
            $('input[type=radio][name=invoice_status]').change(function() {
                bulk_discount_list.column(5)
                    .search(this.value)
                    .draw();
            });

            $(document).on('click', '.delete_credit_note', function(e) {
                var data = {};
                var firstTDValue = $(this).closest('tr').find('td:first').text().trim();
                data['id'] = firstTDValue;
                var id = data['id'];
                let url = "<?php echo e(route('bulk_discounts.delete', ':id')); ?>";
                url = url.replace(':id', id);
                var parent = $(this).parents('tr');
                var delete_confirm = $.confirm({
                    title: "DELETE DISCOUNT & CREDIT",
                    type: 'red',
                    buttons: {
                        delete: {
                            text: 'Delete',
                            btnClass: 'btn-red',
                            action: function() {

                                e.preventDefault();
                                var params = {

                                };

                                $.ajax({
                                    url: url,
                                    type: 'POST',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function(response) {
                                        if (response.status == 'error') {
                                            delete_confirm.close();
                                            notification(response);
                                        } else {
                                            delete_confirm.close();
                                            notification(response);
                                            location.reload();
                                        }
                                    },
                                    error: function(errors) {}
                                });
                                e.preventDefault();
                                return false;
                            }
                        },
                        close: function() {}
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/packages/pramix/xinvoice/src/views/bulk-discounts-list.blade.php ENDPATH**/ ?>