<?php $__env->startSection('content'); ?>
    <input type="hidden" name="page" id="page" value="<?php echo e($page ?? ''); ?>">
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4><?php echo e(__('xinvoice::invoice.headings.credit_note')); ?></h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ADD_CREDIT_NOTE')): ?>
                        <ul class="right-stats" id="mini-nav-right">

                            <button class="btn btn-success" id="select_invoice_product_btn">Quick Search Product</button>

                            <a href="<?php echo e(url('invoice-return/create')); ?>" class="btn btn-primary"><i class="fa fa-plus"
                                    aria-hidden="true"></i>
                                <?php echo e(__('xinvoice::invoice.buttons.create_credit_note')); ?></a>

                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="main-container">
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="<?php echo e(route('invoice_return.index')); ?>">
                                <div class="row gutter">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="">Number </label>
                                            <input type="text" name="invoice_return_code"
                                                value="<?php echo e(request('invoice_return_code')); ?>" class="form-control"
                                                id="searchinvoiceycode" placeholder="Return #">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="">Invoice Number</label>
                                            <input type="text" name="rtn_invoice_code"
                                                value="<?php echo e(request('rtn_invoice_code')); ?>" class="form-control"
                                                id="searchinvoicecode" placeholder="Invoice #">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="">Customer</label>
                                            <input type="text" name="customer_name" class="form-control"
                                                id="searchcustomername"
                                                placeholder="<?php echo e(__('xinvoice::invoice.labels.customer')); ?>"
                                                value="<?php echo e(request('customer_name')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="">Select Rep</label>
                                            <select name="rep_id" id="rep" class="form-control w-100 select2">
                                                <option value="">Select Rep</option>
                                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    
                                                    <option value="<?php echo e($role->id); ?>"
                                                        <?php if(request('rep') == $role->id): ?> selected <?php endif; ?>>
                                                        <?php echo e($role->username); ?>

                                                        - <?php echo e($role->fname); ?> </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="">Date</label>
                                            <input name="invoice_return_date" value="<?php echo e(request('invoice_return_date')); ?>"
                                                class="form-control dates">
                                            
                                        </div>
                                    </div>
                                </div>
                                <div class="row gutter mt-3">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                <label class="btn btn-primary active">
                                                    <input type="radio" name="invoice_rtn_status" value=""
                                                        <?php if(request('invoice_rtn_status') == ''): ?> checked <?php endif; ?>> All
                                                </label>
                                                <label class="btn btn-primary" id="all_status" data-toggle="tooltip"
                                                    data-placement="top" title="">
                                                    <input type="radio" name="invoice_rtn_status" value="D"
                                                        <?php if(request('invoice_rtn_status') == 'D'): ?> checked <?php endif; ?>> Draft
                                                </label>
                                                <label class="btn btn-primary ">
                                                    <input type="radio" name="invoice_rtn_status" value="A"
                                                        <?php if(request('invoice_rtn_status') == 'A'): ?> checked <?php endif; ?>> Completed
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        &nbsp;&nbsp;<button type="submit"
                                            class="btn btn-gradient-primary waves-effect waves-light float-right">Submit</button>
                                    </div>
                                    <div class="form-group">
                                        &nbsp;&nbsp; <a href="<?php echo e(route('invoice_return.index')); ?>"
                                            class="btn btn-gradient-primary waves-effect waves-light float-right">Reset</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table id="invoice_return_list_table" class="table table-striped table-bordered no-margin"
                            cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th hidden></th>
                                    <th><?php echo e(__('xinvoice::invoice.labels.invoice_return_code')); ?></th>
                                    <th>Return Date</th>
                                    <th><?php echo e(__('xinvoice::invoice.labels.customer')); ?></th>
                                    <th>Rep</th>
                                    <th><?php echo e(__('xinvoice::invoice.labels.total')); ?></th>
                                    <th><?php echo e(__('xinvoice::invoice.labels.status')); ?></th>
                                    <th><?php echo e(__('xinvoice::invoice.labels.remarks')); ?></th>
                                    <th><?php echo e(__('common.labels.action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $invoice_returns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice_return): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td hidden><?php echo e($invoice_return->id); ?></td>
                                        <td><?php echo e($invoice_return->invoice_return_code); ?></td>
                                        <td><?php echo e($invoice_return->invoice_return_date); ?></td>
                                        <td>
                                            <?php if(isset($invoice_return->customer)): ?>
                                                <?php echo e($invoice_return->customer->company_name); ?>

                                            <?php else: ?>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if(isset($invoice_return->customer->rep) && isset($invoice_return->customer->rep->username)): ?>
                                                <?php echo e($invoice_return->customer->rep->username); ?>

                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(App\Http\Helper::formatPrice($invoice_return->total)); ?></td>
                                        <td>
                                            <?php if($invoice_return->status == 'D'): ?>
                                                <span class="text-danger"><strong>Draft</strong></span>
                                            <?php elseif($invoice_return->status == 'A'): ?>
                                                <span class="text-success"><strong>Completed</strong></span>
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($invoice_return->remarks); ?></td>
                                        <td>
                                            <?php
                                                $edit_invoicer_permission = false;
                                                $delete_credit_note_permission = false;
                                                if (Auth::user()->can('EDIT_CREDIT_NOTE')) {
                                                    $edit_invoicer_permission = true;
                                                }
                                                if (auth()->user()->can('DELETE_CREDIT_NOTE')) {
                                                    $delete_credit_note_permission = true;
                                                }
                                            ?>
                                            <?php if($edit_invoicer_permission): ?>
                                                <a class="btn btn-info btn-xs"
                                                    href="<?php echo e(url('/invoice_return/' . $invoice_return->id . '/show')); ?>"
                                                    id="edit_customer" data-toggle="tooltip" data-placement="right"
                                                    title="View Invoice Return">
                                                    <i class="fa fa-eye"></i>
                                                </a>
                                            <?php endif; ?>
                                            <?php if($delete_credit_note_permission): ?>
                                                &nbsp;<button class="delete_credit_note btn btn-danger btn-xs"
                                                    data-toggle="tooltip" data-placement="right"
                                                    title="Delete Credit Note" data-original-title="Delete"
                                                    aria-describedby="tooltip934027"><i class="fa fa-trash-o"
                                                        aria-hidden="true"></i></button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <div class="d-flex justify-content-end">
                            <?php echo e($invoice_returns->appends($_GET)->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function() {

            $('#all_status').tooltip('show');

            // var invoice_return_list_table = $('#invoice_return_list_table').DataTable({
            //     'iDisplayLength': 15,
            //     ajax: '<?php echo route('get.invoice_return'); ?>',
            //     order: [
            //         [0, "desc"]
            //     ],

            //     columns: [{
            //             data: 'id',
            //             name: 'id',
            //             'bVisible': false
            //         },
            //         {
            //             data: 'invoice_return_code',
            //             name: 'invoice_return_code'
            //         },
            //         {
            //             data: 'invoice_code',
            //             name: 'invoice_code'
            //         },
            //         {
            //             data: 'invoice_return_date',
            //             name: 'invoice_return_date'
            //         },
            //         {
            //             data: 'customer',
            //             name: 'customer'
            //         },
            //         {
            //             data: 'rep',
            //             name: 'rep'
            //         },
            //         {
            //             data: 'total',
            //             name: 'total',
            //             className: 'dt-body-right'
            //         },
            //         {
            //             data: 'status',
            //             name: 'status'
            //         },
            //         {
            //             data: 'remarks',
            //             name: 'remarks'
            //         },

            //         {
            //             data: 'action',
            //             name: 'action'
            //         },
            //     ]
            // });


            $('#searchinvoiceycode').on('keyup', function() {
                invoice_return_list_table.column(1)
                    .search(this.value)
                    .draw();
            });
            $('#searchinvoicecode').on('keyup', function() {
                invoice_return_list_table.column(2)
                    .search(this.value)
                    .draw();
            })
            $('#invoice_date_created').on('change', function() {
                invoice_return_list_table.column(3)
                    .search(this.value)
                    .draw();
            })
            $('#searchcustomername').on('keyup', function() {
                invoice_return_list_table.column(4)
                    .search(this.value)
                    .draw();
            });
            $('#searchrep').on('keyup', function() {
                invoice_return_list_table.column(5)
                    .search(this.value)
                    .draw();
            });

            $('input[type=radio][name=invoice_status]').change(function() {
                invoice_return_list_table.column(5)
                    .search(this.value)
                    .draw();
            });

            $(document).on('click', '.delete_credit_note', function(e) {
                var data = {};
                var firstTDValue = $(this).closest('tr').find('td:first').text().trim();
                data['id'] = firstTDValue;
                var parent = $(this).parents('tr');
                var delete_confirm = $.confirm({
                    title: "Delete Return Note",
                    type: 'red',
                    buttons: {
                        delete: {
                            text: 'Delete',
                            btnClass: 'btn-red',
                            action: function() {

                                e.preventDefault();
                                var params = {

                                };

                                $.ajax({
                                    url: BASE + 'invoice_return/' + data['id'],
                                    type: 'DELETE',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function(response) {
                                        if (response.status == 'error') {
                                            delete_confirm.close();
                                            notification(response);
                                        } else {
                                            delete_confirm.close();
                                            notification(response);
                                            location.reload();
                                        }
                                    },
                                    error: function(errors) {}
                                });
                                e.preventDefault();
                                return false;
                            }
                        },
                        close: function() {}
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/packages/pramix/xinvoice/src/views/invoice_return/return_list.blade.php ENDPATH**/ ?>