<?php $__env->startSection('include_css'); ?>
    <link href="<?php echo e(asset('/plugins/fineuploader/fine-uploader-gallery.min.css')); ?>" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/dragula/3.7.2/dragula.min.css" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <?php if(isset($product->id)): ?>
                            <h4><?php echo e(__('xproduct::product.headings.update_product')); ?></h4>
                        <?php else: ?>
                            <h4><?php echo e(__('xproduct::product.headings.new_product')); ?></h4>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <ul class="right-stats" id="save_button_group">
                        <button class="btn btn-primary"
                            id="product-save-btn"><?php echo e(__('xproduct::product.buttons.save')); ?></button>
                        <button class="btn btn-primary"
                            id="product-save-and-new"><?php echo e(__('xproduct::product.buttons.save_and_new')); ?></button>
                        <button class="btn btn-primary"
                            id="product-update-btn"><?php echo e(__('xproduct::product.buttons.update')); ?></button>

                    </ul>
                </div>
            </div>
        </div>

        <div class="main-container">
            <form action="<?php echo e(url('/') . '/product'); ?>" method="POST" id="create_product_form">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="product_id" id="product_id" value="<?php echo e($product->id ?? ''); ?>">
                <input type="hidden" name="page" id="page" value="<?php echo e($page ?? ('' ?? '')); ?>">
                <input type="hidden" name="isajax" id="isajax" value="<?php echo e(Request::ajax()); ?>">
                <input type="hidden" name="ref_id" id="ref_id" value="<?php echo e($product->id ?? ''); ?>">
                <input type="hidden" name="ref_type" id="ref_type" value="P">
                <input type="hidden" name="product_type" id="product_id" value="<?php echo e($product->type ?? ''); ?>">
                <input type="hidden" name="product_discount" id="discount_id" value="<?php echo e($product_discount->id ?? ''); ?>">
                <div class="row gutter">


                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                        <div class="card" id="product-basic-details-panel">
                            <div class="card-header">
                                <h4><?php echo e(__('xproduct::product.headings.panel_basic_details')); ?></h4>
                            </div>
                            <?php
                                $system_setting = App\SystemSetting::first();
                                if(empty($system_setting))
                                {
                                    $system_setting= App\SystemSetting::create([]);
                                }
                            ?>

                            <div class="card-body">
                                <?php echo e(formText('Stock ID', 'stock_id', $product->stock_id ?? '', ['class' => 'form-control validate[required]','id' => 'stock_id','maxlength' => $system_setting->stock_id_limit])); ?>


                                <?php echo e(formText(__('xproduct::product.labels.product_name_code'), 'product_code', $product->item_code ?? '', ['class' => 'form-control validate[required]','id' => 'product_code'])); ?>

                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formDropdown(__('xproduct::product.labels.product_type'),'product_type',Config::get('system.product_types'),isset($product->type) ? $product->type : Config::get('system.default_product_type'),['class' => 'form-control', 'id' => 'product_type'])); ?>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">

                                        <?php
                                            $categories = \Pramix\XProduct\Models\ProductCategoriesModel::where('parent_id', 0)->get();
                                        ?>
                                        <div class="form-group">
                                            <label for="product_category">Category</label>
                                            <select class="form-control select2" name="product_category"
                                                id="product_category">
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <optgroup label="<?php echo e($category->category_name); ?>">

                                                        <?php $childs = \Pramix\XProduct\Models\ProductCategoriesModel::where('parent_id', $category->id)->get(); ?>
                                                        <?php if(count($childs) > 0): ?>
                                                            <ul class="list-group">
                                                                <?php $__currentLoopData = $childs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($child->id ?? ''); ?>">
                                                                        <?php echo e($child->category_name ?? ''); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </ul>
                                                        <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>


                                    </div>
                                </div>
                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label for="manufacture">Manufacture</label>
                                            <?php echo e(Form::select('manufacture',\Pramix\XProduct\Models\ManufactureModel::pluck('manufacture_name', 'manufacture_name'),isset($manufacture) ? $manufacture : '',['class' => 'common_auto_load_data form-control select2','name' => 'manufacture','data-loading_value' => $manufacture ?? '','placeholder' => 'Select Manufacture','id' => 'manufacture'])); ?>

                                        </div>
                                    </div>
                                </div>
                                <?php if( Gate::check('EDIT_ITEM_DESCRIPION') && !empty($product)): ?>
                                <?php echo e(formTextArea(__('xproduct::product.labels.description'), 'description', $product->description ?? '', ['class' => 'form-control validate[maxSize[45]]','id' => 'description','rows' => 3,'maxlength' => $system_setting->product_description_limit])); ?>

                                <?php else: ?>
                                <?php if(!empty($product)): ?>
                                <?php echo e(formTextArea(__('xproduct::product.labels.description'), 'description', $product->description ?? '', ['class' => 'form-control validate[maxSize[45]]','id' => 'description','rows' => 3,'maxlength' => $system_setting->product_description_limit ,'readonly'])); ?>


                                <?php else: ?>
                                <?php echo e(formTextArea(__('xproduct::product.labels.description'), 'description', $product->description ?? '', ['class' => 'form-control validate[maxSize[45]]','id' => 'description','rows' => 3,'maxlength' => $system_setting->product_description_limit])); ?>


                                <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="card" id="product-pic-panel">
                            <div class="card-header">
                                <h4><?php echo e(__('xproduct::product.headings.picture')); ?></h4>
                            </div>
                            <div class="card-body">
                                <input type="hidden" name="media_type" id="media_type"
                                    value="<?php echo e(getConfigArrayValueByKey('MEDIA_TYPES', 'products_media')); ?>">


                                    <?php echo $__env->make('xmedia::add_multiple_images_template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            </div>
                        </div>
                        <div class="card" id="product-discount-panel">
                            <div class="card-header">
                                <h4><?php echo e(__('xproduct::product.headings.discounts')); ?></h4>
                            </div>
                            <div class="card-body">

                                <?php if(isset($product_discount) && $product_discount != null): ?>
                                    <div class="row gutter">
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                            <strong><?php echo e(__('xproduct::product.labels.discount')); ?></strong>
                                        </div>
                                        <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
                                            <?php if($product_discount->discount_type == 'percentage'): ?>
                                                <?php echo e($product_discount->amount); ?> %
                                            <?php else: ?>
                                                <?php echo e(Helper::formatPrice($product_discount->amount)); ?>

                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="row gutter">
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                            <strong><?php echo e(__('xproduct::product.labels.discount_starts')); ?></strong>
                                        </div>
                                        <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
                                            <?php echo e($product_discount->start_date); ?></div>
                                    </div>
                                    <div class="row gutter">
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                            <strong><?php echo e(__('xproduct::product.labels.discount_ends')); ?></strong>
                                        </div>
                                        <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12"><?php echo e($product_discount->end_date); ?>

                                        </div>
                                    </div>
                                    <div class="row gutter">
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                            <strong><?php echo e(__('xproduct::product.labels.discount_limit')); ?></strong>
                                        </div>
                                        <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12"><?php echo e($product_discount->limit); ?>

                                        </div>
                                    </div>
                                    <button class="btn btn-success"
                                        id="btn_discount_edit"><?php echo e(__('xproduct::product.buttons.discount_edit')); ?></button>
                                <?php endif; ?>
                                <div id="product_discount_form">
                                    <div class="row gutter">
                                        <div class="col-lg-7 col-md-9 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label
                                                    for="discount_amount"><?php echo e(__('xproduct::product.labels.discount')); ?></label>
                                                <div class="row gutter">
                                                    <div class="col-md-5">
                                                        <input type="number" class="form-control" name="discount_amount"
                                                            value="<?php echo e($product->discount->amount ?? ''); ?>">
                                                    </div>
                                                    <div class="col-md-7">
                                                        <?php echo e(Form::select('discount_type',getConfig('DISCOUNT_TYPE'),isset($customer->discount_type) ? $customer->discount_type : getConfigValue('DISCOUNT_TYPE'),['class' => 'form-control', 'id' => 'discount_type'])); ?>

                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="row gutter">
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label
                                                    for="discount_start_time"><?php echo e(__('xproduct::product.labels.discount_starts')); ?></label>
                                                <div class="row gutter">
                                                    <div class="col-md-5">
                                                        <input type="time"
                                                            value="<?php echo e(isset($product->discount->start_date)? date('H:i', strtotime($product->discount->start_date)): Carbon\Carbon::now()->format('H:i')); ?>"
                                                            class="form-control" name="discount_start_time">
                                                    </div>
                                                    <div class="col-md-7">
                                                        <input
                                                            value="<?php echo e(isset($product->discount->start_date)? date('Y-m-d', strtotime($product->discount->start_date)): Carbon\Carbon::now()->format('Y-m-d')); ?>"
                                                            type="date" class="form-control" name="discount_start_date">

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label
                                                    for="discount_end_time"><?php echo e(__('xproduct::product.labels.discount_ends')); ?></label>
                                                <div class="row gutter">
                                                    <div class="col-md-5">
                                                        <input type="time"
                                                            value="<?php echo e(isset($product->discount->end_date)? date('H:i', strtotime($product->discount->end_date)): Carbon\Carbon::now()->format('H:i')); ?>"
                                                            class="form-control" name="discount_end_time">
                                                    </div>
                                                    <div class="col-md-7">
                                                        <input
                                                            value="<?php echo e(isset($product->discountend_date)? date('Y-m-d', strtotime($product->discount->end_date)): Carbon\Carbon::now()->format('Y-m-d')); ?>"
                                                            type="date" class="form-control" name="discount_end_date">

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="row gutter">
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label
                                                    for="discount_limit"><?php echo e(__('xproduct::product.labels.discount_limit')); ?></label>
                                                <input type="number" class="form-control" name="discount_limit"
                                                    value="<?php echo e($product->discount->limit ?? ''); ?>">
                                            </div>
                                        </div>


                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">


                        <div class="card" id="inventory-panel">
                            <div class="card-header">
                                <h4><?php echo e(__('xproduct::product.headings.panel_inventory')); ?></h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label for="qty"><?php echo e(__('xproduct::product.labels.quantity_on_hand')); ?></label>
                                            <?php if(isset($product)): ?>
                                                <?php $qty_on_hand = \Pramix\XInventory\Models\Inventory::getProductStock($product->id) ?>
                                            <?php endif; ?>
                                            <input type="number" class="form-control" name="qty_on_hand" id="qty_on_hand"
                                                value="<?php echo e($qty_on_hand ?? '0'); ?>">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label for="barcode"><?php echo e(__('xproduct::product.labels.barcode')); ?></label>
                                            <input type="text" class="form-control" name="barcode"
                                                value="<?php echo e($product->barcode ?? ''); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">

                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label
                                                for="reorder_point"><?php echo e(__('xproduct::product.labels.reorder_point')); ?></label>
                                            <input type="number" class="form-control" name="reorder_point"
                                                value="<?php echo e($product->reorder_point ?? ''); ?>">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label
                                                for="reorder_qry"><?php echo e(__('xproduct::product.labels.reorder_quantity')); ?></label>
                                            <input type="number" class="form-control" name="reorder_qry"
                                                value="<?php echo e($product->reorder_qty ?? 1); ?>">
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="card" id="cost-and-price-panel">
                            <div class="card-header">
                                <h4><?php echo e(__('xproduct::product.headings.panel_cost_and_price')); ?></h4>
                            </div>
                            <div class="card-body">
                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label for="cost"><?php echo e(__('xproduct::product.labels.cost')); ?></label>
                                            <input type="number" class="form-control" name="cost"
                                                value="<?php echo e($product->cost ?? ''); ?>">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label
                                                for="normal_price"><?php echo e(__('xproduct::product.labels.normal_price')); ?></label>
                                            <input type="number" class="form-control" name="normal_price"
                                                value="<?php echo e($product->price ?? ''); ?>"<?php if(!empty($product)): ?>
                                                 <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('EDIT_ITEM_PRICE')): ?>
                                                readonly
                                                <?php endif; ?>
                                                <?php endif; ?>
                                                >
                                        </div>
                                    </div>

                                </div>


                            </div>

                        </div>


                        <div class="card" id="measurement-panel">
                            <div class="card-header">
                                <h4><?php echo e(__('xproduct::product.headings.panel_measurements')); ?></h4>
                            </div>
                            <div class="card-body">
                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label for="length"><?php echo e(__('xproduct::product.labels.length')); ?></label>
                                            <input type="text" class="form-control" name="length"
                                                value="<?php echo e($product->length ?? ''); ?>">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label for="width"><?php echo e(__('xproduct::product.labels.width')); ?></label>
                                            <input type="text" class="form-control" name="width"
                                                value="<?php echo e($product->width ?? ''); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label for="height"><?php echo e(__('xproduct::product.labels.height')); ?></label>
                                            <input type="text" class="form-control" name="height"
                                                value="<?php echo e($product->height ?? ''); ?>">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label for="weight"><?php echo e(__('xproduct::product.labels.weight')); ?></label>
                                            <input type="text" class="form-control" name="weight"
                                                value="<?php echo e($product->weight ?? ''); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- Row ends -->


                </div>
            </form>

        </div>
        <!-- Main container ends -->
    </div>
    <!-- Dashboard wrapper ends -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('include_js'); ?>
    <script src='https://cdnjs.cloudflare.com/ajax/libs/dragula/3.7.2/dragula.min.js'></script>

    <script src="<?php echo e(asset('/pramix/js/product_js.js')); ?>"></script>
    <script src="<?php echo e(asset('/pramix/js/media_js.js')); ?>"></script>
    <script src="<?php echo e(asset('/plugins/fineuploader/fine-uploader.min.js')); ?>"></script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom_script'); ?>
    <?php echo $__env->make('xmedia::qq_template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        $(document).ready(function() {

            window.onbeforeunload = function() {
                return "Are you sure you want to leave?";
            };

            $("#product_location").select2({
                tags: true
            });

            var product_category = new Option('Product Category', '', true, true);
            $('#product_category').append(product_category);

            $('#product_category').val('<?php echo e($product->category_id ?? ''); ?>').trigger("change");


            <?php if(!isset($product->store_location)): ?>
                var product_location = new Option('Please select location', '', true, true);
                $('#product_location').append(product_location).trigger('change');
            <?php endif; ?>




            window.initializeSelectTwo = function() {

                $(".common_auto_load_data").each(function() {
                    var $this = $(this);

                    if ($this.attr("data-loading_value") != '' && typeof $this.attr(
                            "data-loading_value") !== "undefined") {
                        var $option = $('<option selected>' + $this.attr("data-loading_value") +
                            '</option>').val($this.attr("data-loading_value"));

                        $this.append($option).trigger('change'); // append the option and update Select2
                    }

                    $this.select2({


                        tags: true,
                        ajax: {
                            url: BASE + 'get_manufactures_list',
                            dataType: 'json',
                            delay: 500,
                            processResults: function(data) {
                                return {
                                    results: $.map(data, function(item) {
                                        return {
                                            text: item.name,
                                            id: item.name
                                        }
                                    })
                                };
                            },
                        },
                    });
                });
            };

            initializeSelectTwo();

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make((( Request::ajax()) ? 'layouts.model' : 'layouts.app' ), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/packages/pramix/xproduct/src/views/create_product.blade.php ENDPATH**/ ?>