<?php $__env->startSection('content'); ?>
    <div class="container-fluid mt-4">
        <div class="row mb-4">
            <div class="col-md-6">
                <h4><?php echo e(__('xcustomer::customer.headings.all_customer_list')); ?></h4>
            </div>
            <div class="col-md-6 text-right">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ADD_CUSTOMER')): ?>
                    <a href="<?php echo e(url('customer/create')); ?>" class="btn btn-primary">
                        <i class="fa fa-plus"></i> <?php echo e(__('xcustomer::customer.buttons.new_customer')); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>

        <form class="form-inline mb-4" action="<?php echo e(route('customer.index')); ?>">
            <div class="form-group mb-2 mr-2">
                <label for="searchbusinessname" class="sr-only"><?php echo e(__('xcustomer::customer.labels.business_name')); ?></label>
                <input type="text" name="business_name" value="<?php echo e(request('business_name')); ?>" class="form-control select2" id="searchbusinessname" placeholder="<?php echo e(__('xcustomer::customer.labels.business_name')); ?>">
            </div>
            <div class="form-group mb-2 mr-2">
                <label for="searchfullname" class="sr-only"><?php echo e(__('xcustomer::customer.labels.full_name')); ?></label>
                <input type="text" name="company_name" value="<?php echo e(request('company_name')); ?>" class="form-control select2" id="searchfullname" placeholder="<?php echo e(__('xcustomer::customer.labels.full_name')); ?>">
            </div>
            <div class="form-group mb-2 mr-2">
                <label for="searchmobile" class="sr-only"><?php echo e(__('xcustomer::customer.labels.mobile')); ?></label>
                <input type="text" name="mobile" value="<?php echo e(request('mobile')); ?>" class="form-control select2" id="searchmobile" placeholder="<?php echo e(__('xcustomer::customer.labels.mobile')); ?>">
            </div>
            <div class="form-group mb-2 mr-2">
                <label for="rep" class="sr-only"><?php echo e(__('Select Rep')); ?></label>
                <select name="rep_id" id="rep" class="form-control select2">
                    <option value="">Select Rep</option>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($role->id); ?>" <?php if(request('rep_id') == $role->id): ?> selected <?php endif; ?>><?php echo e($role->username); ?> - <?php echo e($role->fname); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group mb-2 mr-2">
                <label for="grade" class="sr-only"><?php echo e(__('Select Grade')); ?></label>
                <select name="customer_grade" id="grade" class="form-control select2">
                    <option value="">Please Select</option>
                    <option value="A" <?php if(request('customer_grade') == 'A'): ?> selected <?php endif; ?>>A</option>
                    <option value="B" <?php if(request('customer_grade') == 'B'): ?> selected <?php endif; ?>>B</option>
                    <option value="C" <?php if(request('customer_grade') == 'C'): ?> selected <?php endif; ?>>C</option>
                    <option value="D" <?php if(request('customer_grade') == 'D'): ?> selected <?php endif; ?>>D</option>
                </select>
            </div>
            <div class="form-group mb-3">
                <button type="submit" class="btn btn-primary">Submit</button>
                <a href="<?php echo e(route('customer.index')); ?>" class="btn btn-secondary ml-2">Reset</a>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th hidden>ID</th>
                        <th>CUSTOMER CODE</th>
                        <th>FULLNAME</th>
                        <th>MOBILE</th>
                        <th>AREA</th>
                        <th>REP</th>
                        <th>GRADE</th>
                        <th>OUTSTANDING AMOUNT</th>
                        <th>ACTION</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td hidden><?php echo e($customer->id); ?></td>
                            <td><?php echo e($customer->business_name); ?></td>
                            <td><b><?php echo e($customer->company_name); ?></b></td>
                            <td><?php echo e($customer->mobile); ?></td>
                            <td><?php echo e($customer->customerPrivateAddress->city->name_en ?? ''); ?></td>
                            <td><?php echo e($customer->rep->username); ?></td>
                            <td><?php echo e($customer->customer_grade); ?></td>
                            <?php
                                $outstanding_amount = App\Utils\CommonUtil::calculateCustomerInvoiceOutstanding($customer->id);
                            ?>
                            <td><?php echo e(App\Http\Helper::formatPrice($outstanding_amount)); ?></td>
                            <td>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('SHOW_ATTECH_FILES')): ?>
                                    <a class="btn btn-success btn-xs" href="<?php echo e(route('file-attech', $customer->id)); ?>" title="View Files"><i class="fa fa-file"></i></a>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('BLOCK_CUSTOMER')): ?>
                                <?php
                                    $route = $customer->block_status == 'Blocked' ? route('unblock.customer', $customer->id) : route('block.customer', $customer->id);
                                    $icon = $customer->block_status == 'Blocked' ? 'fa-check' : 'fa-ban';
                                    $title = $customer->block_status == 'Blocked' ? 'Unblock Customer' : 'Block Customer';
                                    $buttonClass = $customer->block_status == 'Blocked' ? 'btn-danger' : 'btn-warning';  
                                ?>
                                <a class="btn <?php echo e($buttonClass); ?> btn-xs" href="<?php echo e($route); ?>" title="<?php echo e($title); ?>">
                                    <i class="fa <?php echo e($icon); ?>"></i>
                                </a>
                            <?php endif; ?>
                            

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('EDIT_CUSTOMER')): ?>
                                    <a class="btn btn-info btn-xs" href="<?php echo e(url('/customer/' . $customer->id . '/edit')); ?>" title="Edit Customer"><i class="fa fa-pencil"></i></a>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('DELETE_CUSTOMER')): ?>
                                    <button class="delete_customer btn btn-danger btn-xs" data-id="<?php echo e($customer->id); ?>" title="Delete Customer"><i class="fa fa-trash-o"></i></button>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-end">
            <?php echo e($customers->appends(request()->input())->links()); ?> 
        </div>
    </div>


    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('include_js'); ?>
<script>
    jQuery(document).ready(function($) {
        $('.select2').select2();

        $(document).on('click', '.delete_customer', function() {
            var customerId = $(this).data('id');
            if (confirm('Are you sure you want to delete this customer?')) {
                $.ajax({
                    url: '/customer/' + customerId,
                    type: 'DELETE',
                    success: function(response) {
                        location.reload(); 
                    },
                    error: function(xhr, status, error) {
                        alert('An error occurred while deleting the customer.');
                    }
                });
            }
        });
    });
    
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/packages/pramix/xcustomer/src/views/index.blade.php ENDPATH**/ ?>