<?php $__env->startSection('include_css'); ?>
    <!-- Fine Upload -->
    <link href="<?php echo e(asset('/plugins/fineuploader/fine-uploader-gallery.min.css')); ?>" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/dragula/3.7.2/dragula.min.css" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Dashboard wrapper starts -->
    <div class="dashboard-wrapper">

        <!-- Top bar starts -->
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4><?php echo e(__('xgeneral::settings.headings.setting')); ?></h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <ul class="right-stats">
                        <a href="javascript:void(0)" class="btn btn-danger"
                            id="company_save_btn"><?php echo e(__('common.buttons.btn_save')); ?></a>
                    </ul>

                </div>
            </div>
        </div>
        <!-- Top bar ends -->

        <!-- Main container starts -->
        <div class="main-container">
            <form id="company_settings_form" action="<?php echo e(url('/') . '/settings'); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <input type="hidden" name="ref_id" id="ref_id" value="">

                <!-- Row starts -->
                <div class="row gutter">
                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">

                        <div class="card" id="payment-details-card">
                            <div class="card-header">
                                <h4><?php echo e(__('xgeneral::settings.headings.logo')); ?></h4>
                            </div>
                            <div class="card-body">
                                <input type="hidden" name="media_type" id="media_type"
                                    value="<?php echo e(getConfigArrayValueByKey('MEDIA_TYPES', 'company_logo')); ?>">

                                <?php echo $__env->make('xmedia::add_multiple_images_template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                            </div>
                        </div>

                        <div class="card" id="payment-details-card">
                            <div class="card-header">
                                <h4>System Settings</h4>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <label for="">Stock Id Limit</label>
                                <input type="number" name="product_description_limit" id="stock_id_limit" class="form-control" value="<?php echo e($system_setting->stock_id_limit); ?>">
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <label for="">Product Description Limit</label>
                                <input type="number" name="product_description_limit" id="product_description_limit" class="form-control" value="<?php echo e($system_setting->product_description_limit); ?>">
                            </div>
                        </div>


                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">

                        <div class="card" id="company-details-card">
                            <div class="card-header">
                                <h4><?php echo e(__('xgeneral::settings.headings.company_details')); ?></h4>
                            </div>
                            <div class="card-body">
                                <?php echo e(formText(__('xgeneral::settings.labels.company_name'), 'company_name', getConfigArrayValueByKey('COMPANY_DETAILS', 'company_name') ?? '', ['class' => 'form-control', 'id' => 'company_name'])); ?>



                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xgeneral::settings.labels.mobile'), 'mobile', getConfigArrayValueByKey('COMPANY_DETAILS', 'mobile') ?? '', ['class' => 'form-control', 'id' => 'mobile'])); ?>


                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xgeneral::settings.labels.telephone'), 'telephone', getConfigArrayValueByKey('COMPANY_DETAILS', 'telephone') ?? '', ['class' => 'form-control', 'id' => 'telephone'])); ?>


                                    </div>


                                </div>
                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xgeneral::settings.labels.email'), 'email', getConfigArrayValueByKey('COMPANY_DETAILS', 'email') ?? '', ['class' => 'form-control', 'id' => 'email'])); ?>


                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xgeneral::settings.labels.website'), 'website', getConfigArrayValueByKey('COMPANY_DETAILS', 'website') ?? '', ['class' => 'form-control', 'id' => 'website'])); ?>


                                    </div>

                                </div>
                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xgeneral::settings.labels.street1'), 'street1', getConfigArrayValueByKey('COMPANY_DETAILS', 'street1') ?? '', ['class' => 'form-control', 'id' => 'street1'])); ?>


                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xgeneral::settings.labels.street2'), 'street2', getConfigArrayValueByKey('COMPANY_DETAILS', 'street2') ?? '', ['class' => 'form-control', 'id' => 'street2'])); ?>


                                    </div>

                                </div>
                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xgeneral::settings.labels.city'), 'city', getConfigArrayValueByKey('COMPANY_DETAILS', 'city') ?? '', ['class' => 'form-control', 'id' => 'city'])); ?>


                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xgeneral::settings.labels.country'), 'country', getConfigArrayValueByKey('COMPANY_DETAILS', 'country') ?? '', ['class' => 'form-control', 'id' => 'country'])); ?>



                                    </div>

                                </div>


                            </div>
                        </div>
                    </div>




                </div>
                <!-- Row ends -->

            </form>



        </div>
        <!-- Main container ends -->

    </div>
    <!-- Dashboard wrapper ends -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('include_js'); ?>
    <script src="<?php echo e(asset('/plugins/fineuploader/fine-uploader.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/pramix/js/media_js.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('custom_script'); ?>
    <?php echo $__env->make('xmedia::qq_template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script>
        $(document).ready(function() {
            $("#company_save_btn").click(function(e) {

                var company_details = $('#company_settings_form').serialize();
                var stock_id_limit = $('#stock_id_limit').val();
                var product_description_limit = $('#product_description_limit').val();

                var params = {
                    company_details: company_details,
                    stock_id_limit: stock_id_limit,
                    product_description_limit : product_description_limit,

                };
                e.preventDefault();
                $.ajax({
                    url: BASE + 'settings/store',
                    type: 'POST',
                    dataType: 'JSON',
                    data: $.param(params),
                    success: function(response) {
                        if (response.status == 'error') {
                            notification(response);
                        } else {
                            notification(response);
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError) {

                        notificationError(xhr, ajaxOptions, thrownError);
                    }
                });
                e.preventDefault();
                return false;
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/packages/pramix/xgeneral/src/views/settings/settings.blade.php ENDPATH**/ ?>