<?php $__env->startSection('include_css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('/pramix/css/custom.css')); ?>">
    <style>
        #create_new_customer_model {
            display: none !important;
        }

        .info-label {
            font-size: 1.1em;
            font-weight: 600;
        }

        .info-value {
            font-size: 1.1em;
            padding-left: 8px;
        }

        .disabled-card {
            opacity: 0.7;
            pointer-events: none;
        }

        .outstanding_amount {
            color: red;
            font-size: 17px;
            font-weight: 900;
        }

        .select2 {
            width: 100% !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4><?php echo e(__('xpayment::payment.headings.new_payment')); ?></h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <ul class="right-stats" id="save_button_group">
                        <a href="javascript:void(0)" class="btn btn-primary mt-1 save_payment_btn"
                            button-type="SAVE">SAVE</a>
                        <a href="javascript:void(0)" class="btn btn-primary mt-1 save_payment_btn d-none"
                            button-type="NEW">SAVE
                            AND
                            NEW</a>
                        <a href="javascript:void(0)" class="btn btn-primary mt-1 save_payment_btn"
                            button-type="SAME_CUSTOMER">ADD PAYMENT FOR SAME CUSTOMER</a>
                    </ul>
                </div>
            </div>
        </div>

        <div class="main-container">
            
            <form action="<?php echo e(route('payment.create_new')); ?>" method="GET" id="customer_selection_form">
                <input type="hidden" name="customer_id_selected" value="<?php echo e($customer_id ?? ''); ?>">
            </form>

            <form action="<?php echo e(route('payment.create_new')); ?>" method="GET" id="filter_form">
                <input type="hidden" name="customer_id_selected" value="<?php echo e($customer_id ?? ''); ?>">
                <input type="hidden" name="filter_payment_ref_no">
                <input type="hidden" name="filter_remarks">
                <input type="hidden" name="filter_payment_date">
                <input type="hidden" name="filter_payment_amount">
                <input type="hidden" name="filter_payment_method">
                <input type="hidden" name="filter_rep">
            </form>

            <!-- Form for final submission -->
            <form action="<?php echo e(route('payment.store_new')); ?>" method="POST" id="payment_form">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="customer_id" id="customer_id" value="<?php echo e($customer_id ?? ''); ?>">
                <input type="hidden" name="button_type" class="button_type">
                <!-- Row for Customer Selection & Payment Details -->
                <div class="row gutter">
                    <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                        <div class="card" id="customer_detail_panel">
                            <div class="card-body">
                                <?php if($customer_id): ?>
                                    
                                    <div class="form-group">
                                        <label class="info-label">Customer:</label>
                                        <span class="info-value"><?php echo e($customer_info->company_name ?? 'N/A'); ?></span>
                                    </div>
                                    <div class="form-group">
                                        <a href="<?php echo e(route('payment.create_new')); ?>" class="btn btn-info btn-block">Start
                                            Over</a>
                                    </div>
                                <?php else: ?>
                                    
                                    <?php echo $__env->make('xcustomer::customer_filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <div class="form-group">
                                        <button type="button" id="load_customer_invoices_btn"
                                            class="btn btn-success btn-block">Load Customer Invoices</button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="alert alert-info alert-dismissible" id="customer_info_alert" style="display: none;">
                        </div>
                    </div>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
                        <div class="card <?php if(empty($outstanding_invoices)): ?> disabled-card <?php endif; ?>"
                            id="payment_details_card_form">
                            <div class="card-body">
                                <div class="row gutter">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="payment_amount">Payment Amount <span
                                                    class="text-danger">*</span></label>
                                            <input type="number" step="0.01" class="form-control" id="payment_amount"
                                                name="payment_amount" placeholder="0.00">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="payment_date">Payment Date <span
                                                    class="text-danger">*</span></label>
                                            <input type="date" class="form-control" id="payment_date" name="payment_date"
                                                value="<?php echo e(\Carbon\Carbon::today()->format('Y-m-d')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="payment_method">Payment Method <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-control" id="payment_method" name="payment_method">
                                                <option value="cash">Cash</option>
                                                <option value="cheque">Cheque</option>
                                                <option value="credit">Over payments</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row gutter">
                                    <div class="col-md-4" id="cheque_date_col">
                                        <div class="form-group">
                                            <label for="cheque_date" id="cheque_date_lable">Effective Date <span
                                                    class="text-danger">*</span></label>
                                            <input type="date" class="form-control" id="cheque_date"
                                                name="cheque_date"
                                                value="<?php echo e(\Carbon\Carbon::today()->format('Y-m-d')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4" id="cheque_bank_col" style="display: none;">
                                        <div class="form-group">
                                            <label for="cheque_bank">Bank</label>
                                            <?php echo e(formDropdown('', 'cheque_bank', getConfig('BANKS_LIST'), '', ['class' => 'form-control select2', 'id' => 'cheque_bank', 'placeholder' => 'Select Bank'])); ?>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="payment_ref_no">Reference No</label>
                                            <input type="text" class="form-control" id="payment_ref_no"
                                                name="payment_ref_no" placeholder="Reference No">
                                        </div>
                                    </div>
                                </div>
                                <div class="row gutter">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label for="payment_remarks">Remarks</label>
                                            <textarea class="form-control" id="payment_remarks" name="payment_remarks" rows="2"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="rep">Representative <span
                                                    class="text-danger">*</span></label>
                                            <?php echo e(Form::select('rep', !empty($roles) ? $roles->pluck('username', 'id') : [], null, ['class' => 'form-control representative', 'id' => 'rep', 'placeholder' => 'Select Rep'])); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card <?php if(empty($old_payments)): ?> disabled-card <?php endif; ?>" id="">
                            <div class="card-header">
                                <div class="card-title">
                                    Previous Payments
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row gutter">
                                    <div class="col-md-3">
                                        <label>Reference No</label>
                                        <input type="text" class="form-control" id="filter_payment_ref_no_input"
                                            value="<?php echo e(request('filter_payment_ref_no')); ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label>Remarks</label>
                                        <input type="text" class="form-control" id="filter_remarks_input"
                                            value="<?php echo e(request('filter_remarks')); ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label>Payment Date</label>
                                        <input type="date" class="form-control" id="filter_payment_date_input"
                                            value="<?php echo e(request('filter_payment_date')); ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label>Payment Amount</label>
                                        <input type="number" step="0.01" class="form-control"
                                            id="filter_payment_amount_input"
                                            value="<?php echo e(request('filter_payment_amount')); ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label>Payment Method</label>
                                        <select class="form-control" id="filter_payment_method_input">
                                            <option value="">Select Type</option>
                                            <option value="cash"
                                                <?php echo e(request('filter_payment_method') == 'cash' ? 'selected' : ''); ?>>Cash
                                            </option>
                                            <option value="cheque"
                                                <?php echo e(request('filter_payment_method') == 'cheque' ? 'selected' : ''); ?>>Cheque
                                            </option>
                                            <option value="credit"
                                                <?php echo e(request('filter_payment_method') == 'credit' ? 'selected' : ''); ?>>Over
                                                payments</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label>Representative</label>
                                        <?php echo e(Form::select(
                                            'filter_rep_input',
                                            ['' => 'Select Rep'] + (!empty($roles) ? $roles->pluck('username', 'id')->toArray() : []),
                                            request('filter_rep'),
                                            ['class' => 'form-control', 'id' => 'filter_rep_input'],
                                        )); ?>

                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group mt-3">
                                            <button type="button"
                                                class="btn btn-gradient-primary waves-effect waves-light float-left" id="filter_search_btn">Submit</button>
                                            <button type="button"
                                                class="btn btn-gradient-primary waves-effect waves-light ml-2" id="filter_reset_btn">Reset</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row gutter">
                                    <div class="table-responsive">
                                        <table id="customer_payments_table"
                                            class="table table-striped table-bordered no-margin" cellspacing="0"
                                            width="100%">
                                            <thead>
                                                <tr>
                                                    <th>Payment Code</th>
                                                    <th>Invoice Code</th>
                                                    <th>Date</th>
                                                    <th>Method</th>
                                                    <th>Effective Date</th>
                                                    <th>Cheque Bank</th>
                                                    <th>Ref #</th>
                                                    <th>Remarks</th>
                                                    <th>Amount</th>
                                                    
                                                    <th>rep</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if(!empty($old_payments)): ?>
                                                    <?php $__empty_1 = true; $__currentLoopData = $old_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $old_payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <tr>
                                                            <td><?php echo e($old_payment->payment_code); ?></td>
                                                            <td><?php echo e($old_payment->invoice->invoice_code); ?></td>
                                                            <td><?php echo e($old_payment->payment_date); ?></td>
                                                            <td><?php echo e($old_payment->payment_method); ?></td>
                                                            <td><?php echo e($old_payment->cheque_date); ?></td>
                                                            <td><?php echo e($old_payment->bank_id ? getConfigArrayValueByKey('BANKS_LIST', $old_payment->bank_id) : 'N/A'); ?>

                                                            </td>
                                                            <td><?php echo e($old_payment->payment_ref_no ?? 'N/A'); ?></td>
                                                            <td><?php echo e($old_payment->payment_remarks); ?></td>
                                                            <td><?php echo e(number_format($old_payment->payment_amount, 2)); ?>

                                                            </td>
                                                            
                                                            <td>
                                                                <?php if(!empty($old_payment->rep_id)): ?>
                                                                    <?php
                                                                        $rep = DB::table('users')->find(
                                                                            $old_payment->rep_id,
                                                                        );
                                                                    ?>
                                                                    <?php echo e($rep->username); ?>

                                                                <?php else: ?>
                                                                    <?php echo e('N/A'); ?>

                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <tr>
                                                            <td colspan="10" class="text-center">No found data.</td>
                                                        </tr>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td colspan="10" class="text-center">No found data.</td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                        <?php if(!empty($old_payments)): ?>
                                            <div class="d-flex justify-content-end">
                                                <?php echo e($old_payments->appends($_GET)->links()); ?>

                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Row -->

                <div id="all_details_panel">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title d-flex justify-content-between">
                                Outstanding Invoices
                                <div class="d-flex justify-content-end">
                                    <span class="outstanding_amount">0.00</span>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="customer_outstanding_table"
                                    class="table table-striped table-bordered no-margin" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th>Invoice No</th>
                                            <th>Invoice Date</th>
                                            <th class="text-right">Total</th>
                                            <th class="text-right">Paid</th>
                                            <th class="text-right">Balance</th>
                                            <th>Amount to Pay</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(!empty($outstanding_invoices)): ?>
                                            <?php $__empty_1 = true; $__currentLoopData = $outstanding_invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td><input type="checkbox" class="invoice-checkbox"
                                                            name="selected_invoices[<?php echo e($invoice->id); ?>][id]"
                                                            value="<?php echo e($invoice->id); ?>"></td>
                                                    <td><?php echo e($invoice->invoice_code); ?></td>
                                                    <td><?php echo e(\Carbon\Carbon::parse($invoice->invoice_date)->format('Y-m-d')); ?>

                                                    </td>
                                                    <td class="text-right"><?php echo e(number_format($invoice->total, 2)); ?></td>
                                                    <td class="text-right"><?php echo e(number_format($invoice->paid_amount, 2)); ?>

                                                    </td>
                                                    <td class="text-right balance-cell">
                                                        <?php echo e(number_format($invoice->balance, 2)); ?></td>
                                                    <td><input type="number" step="0.01"
                                                            class="form-control amount-to-pay"
                                                            name="selected_invoices[<?php echo e($invoice->id); ?>][amount]"
                                                            placeholder="0.00" onwheel="this.blur()" disabled></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="7" class="text-center">No outstanding invoices found
                                                        for this customer.</td>
                                                </tr>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="7" class="text-center">Please load a customer to see their
                                                    outstanding invoices.</td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function() {
            // Display Session-based Notifications
            <?php if(session('success')): ?>
                $.notify({
                    message: "<?php echo e(session('success')); ?>"
                }, {
                    type: 'success',
                    z_index: 10000
                });
            <?php endif; ?>
            <?php if($errors->any()): ?>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    $.notify({
                        message: "<?php echo e($error); ?>"
                    }, {
                        type: 'danger',
                        z_index: 10000
                    });
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

            // $('#customer_payments_table').DataTable({
            //     paging: true,
            //     searching: true,
            //     ordering: true,
            //     pageLength: 2,
            //     lengthChange: false,
            //     order: [
            //         [0, 'desc']
            //     ]
            // });

            $('#payment_amount, #payment_date, #cheque_date, #payment_ref_no, #payment_remarks, #filter_payment_ref_no_input, #filter_remarks_input, #filter_payment_date_input, #filter_payment_amount_input')
                .on('keydown', function(e) {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                    }
                });

            var customerId = "<?php echo e($customer_id ?? ''); ?>";
            if (customerId) {
                if ($('#customer_id_selected').find("option[value='" + customerId + "']").length) {
                    $('#customer_id_selected').val(customerId).trigger('change');
                } else {
                    var customerName = "<?php echo e($customer_info->company_name ?? 'N/A'); ?>";
                    var newOption = new Option(customerName, customerId, true, true);
                    $('#customer_id_selected').append(newOption).trigger('change');
                }
                if (typeof changeCustomer !== 'undefined') {
                    changeCustomer.run(customerId, '', '');
                }
            }

            $('#customer_id_selected').on('change', function() {
                var selectedCustomerId = $(this).val();
                $('#customer_selection_form input[name="customer_id_selected"]').val(selectedCustomerId);
            });

            $('#load_customer_invoices_btn').on('click', function() {
                var selectedCustomerId = $('#customer_id_selected').val();
                if (!selectedCustomerId) {
                    alert('Please select a customer first.');
                    return;
                }
                $('#customer_selection_form input[name="customer_id_selected"]').val(selectedCustomerId);
                $('#customer_selection_form').submit();
            });

            // FIXED: Unbind the global handler and attach a local one
            $('#payment_method').off('change').on('change', function() {
                if ($(this).val() === 'cheque') {
                    $('#cheque_date_lable').text('Cheque Date');
                    $('#cheque_bank_col').show();
                    $('#cheque_bank').prop('disabled', false);
                } else {
                    $('#cheque_date_lable').text('Effective Date');
                    $('#cheque_bank_col').hide();
                    $('#cheque_bank').prop('disabled', true);
                }
            }).trigger('change');

            $('#customer_outstanding_table').on('change', '.invoice-checkbox', function() {
                var isChecked = $(this).is(':checked');
                var $input = $(this).closest('tr').find('.amount-to-pay');
                $input.prop('disabled', !isChecked);
                if (!isChecked) {
                    $input.val('');
                }
            });

            // Enable/disable amount input on checkbox toggle
            $(document).on('change', '.invoice-checkbox', function() {
                let rowInput = $(this).closest('tr').find('.amount-to-pay');
                if ($(this).is(':checked')) {
                    rowInput.prop('disabled', false);
                } else {
                    rowInput.prop('disabled', true).val('');
                }
                calculateOutstanding();
            });

            // Recalculate when typing in Payment Amount or Amount to Pay
            $(document).on('keyup change', '#payment_amount, .amount-to-pay', function() {
                calculateOutstanding();
            });

            // --- SAVE BUTTON VALIDATION ---
            $('.save_payment_btn').on('click', function(e) {
                e.preventDefault();

                var button = $(this);
                var button_type = button.attr('button-type');

                $('.button_type').val(button_type);

                submit_form(button);
            });

            $('#filter_search_btn').on('click', function() {
                $('#filter_form input[name="filter_payment_ref_no"]').val($('#filter_payment_ref_no_input')
                    .val());
                $('#filter_form input[name="filter_remarks"]').val($('#filter_remarks_input').val());
                $('#filter_form input[name="filter_payment_date"]').val($('#filter_payment_date_input')
                    .val());
                $('#filter_form input[name="filter_payment_amount"]').val($('#filter_payment_amount_input')
                    .val());
                $('#filter_form input[name="filter_payment_method"]').val($('#filter_payment_method_input')
                    .val());
                $('#filter_form input[name="filter_rep"]').val($('#filter_rep_input').val());

                $('#filter_form').submit();
            });
            
            $('#filter_reset_btn').on('click', function() {
                $('#filter_form input[name="filter_payment_ref_no"]').val('');
                $('#filter_form input[name="filter_remarks"]').val('');
                $('#filter_form input[name="filter_payment_date"]').val('');
                $('#filter_form input[name="filter_payment_amount"]').val('');
                $('#filter_form input[name="filter_payment_method"]').val('');
                $('#filter_form input[name="filter_rep"]').val('');

                $('#filter_form').submit();
            });
        });

        function submit_form(button) {

            var paymentAmount = parseFloat($('#payment_amount').val());
            if (isNaN(paymentAmount) || paymentAmount <= 0) {
                alert('Please enter a valid Payment Amount.');
                return;
            }

            if (!$('#payment_date').val()) {
                alert('Please select a Payment Date.');
                return;
            }

            if (!$('#payment_method').val()) {
                alert('Please select a Payment Method.');
                return;
            }

            if ($('#payment_method').val() === 'cheque') {
                if (!$('#cheque_date').val() || !$('#cheque_bank').val()) {
                    alert('Please fill in both Cheque Date and Bank for cheque payments.');
                    return;
                }
            } else {
                if (!$('#cheque_date').val()) {
                    alert('Please fill in effective date for payments.');
                    return;
                }
            }

            if (!$('.representative').val()) {
                alert('Please select a sales representative.');
                return;
            }

            if ($('#customer_outstanding_table .invoice-checkbox:checked').length === 0) {
                alert('Please select at least one invoice to apply the payment to.');
                return;
            }

            var totalAllocated = 0;
            var validationPassed = true;
            $('#customer_outstanding_table .invoice-checkbox:checked').each(function() {
                var $row = $(this).closest('tr');
                var balance = parseFloat($row.find('.balance-cell').text().replace(/,/g, ''));
                var amountToPay = parseFloat($row.find('.amount-to-pay').val());

                if (isNaN(amountToPay) || amountToPay <= 0) {
                    alert('Please enter a valid amount for all selected invoices.');
                    validationPassed = false;
                    return false;
                }

                // if (amountToPay > balance) {
                //     var invoiceCode = $row.find('td:eq(1)').text();
                //     alert('Amount for invoice ' + invoiceCode + ' (' + amountToPay.toFixed(2) +
                //         ') cannot exceed its balance of ' + balance.toFixed(2) + '.');
                //     validationPassed = false;
                //     return false;
                // }
                totalAllocated += amountToPay;
            });

            if (!validationPassed) {
                return;
            }

            if (Math.abs(paymentAmount - totalAllocated) > 0.01) {
                alert('The total Amount to Pay (' + totalAllocated.toFixed(2) +
                    ') must exactly match the Payment Amount (' + paymentAmount.toFixed(2) + ').');
                return;
            }

            button.addClass('disabled');

            // If all validations pass, submit the form
            $('#payment_form').submit();
        }

        // Calculate outstanding amount
        function calculateOutstanding() {
            let paymentAmount = parseFloat($('#payment_amount').val()) || 0;
            let totalAllocated = 0;

            $('.amount-to-pay').each(function() {
                let val = parseFloat($(this).val());
                if (!isNaN(val)) {
                    totalAllocated += val;
                }
            });

            let outstanding = paymentAmount - totalAllocated;
            $('.outstanding_amount').text(outstanding.toFixed(2));
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(Request::ajax() ? 'layouts.model' : 'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/resources/views/payment/create_payment_new.blade.php ENDPATH**/ ?>