<!DOCTYPE html>
<html lang="en">

<head>

    <style>
        body {
            font-size: 12px;
            font-family: sans-serif;
            padding-top: 74px;
            text-transform: uppercase;
        }
    </style>

</head>

<body>

    <table style="width: 100%">
        <tr>
            <td style="width: 70%">
                <table style="width: 80% border-collapse: collapse;border-spacing: 0;" >
                    <tbody style="border-spacing:0;">
                        <tr rowspacing=0;>
                            <td style="width: 20%">
                                <?php if(isset($customer)): ?>
                                    <abbr title="code">Dealer :</abbr>
                            </td>
                            <?php endif; ?>
                            <td style="width: 80%">
                                <?php if(isset($customer->company_name) && $customer->company_name != ''): ?>
                                    <?php echo e($customer->company_name ?? ''); ?><br>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr style="margin-top: -10px;">
                            <td style="width: 20%"><abbr title="code"> </abbr></td>
                            <td style="width: 80%">
                               <?php if(isset($business_address->address_line_1) && $business_address->address_line_1 != ''): ?>
                                    <?php echo e($business_address->address_line_1 ?? ''); ?>,
                                <?php endif; ?>
                                <?php if(isset($business_address->address_line_2) && $business_address->address_line_2 != ''): ?>
                                    <?php echo e($business_address->address_line_2 ?? ''); ?>, <br>
                                <?php endif; ?>
                                <?php if(isset($business_address->city_name) && $business_address->city_name != ''): ?>
                                    <?php echo e($business_address->city_name ?? ''); ?>.
                                <?php endif; ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
            <td style="width: 30%">
                <table style="width: 100%;border-collapse: collapse;border-spacing: 0;">
                    <tbody>
                        <tr>
                            <td style="width: 40%">Invoice #</td>
                            <td> :</td>
                            <td><?php echo e($invoice->invoice_code ?? ''); ?></td>
                        </tr>
                        <tr>
                            <td style="width: 40%">Date & Time</td>
                            <td> :</td>
                            <td><?php echo e(Carbon\Carbon::parse($invoice->invoice_date)->format('Y-m-d') ?? ''); ?></td>
                        </tr>
                        <?php if(isset($invoice->rep)): ?>
                            <tr>
                                <td style="width: 40%">Rep.</td>
                                <td> :</td>
                                <td><?php echo e($invoice->rep->fname ?? ''); ?>

                                    <br></td>
                            </tr>
                            
                                <tr>
                                    <td style="width: 40%">Phone</td>
                                    <td> :</td>
                                    <td><?php echo e($invoice->rep->lname ?? ''); ?></td>
                                </tr>
                            
                        <?php endif; ?>
                    </tbody>
                </table>
            </td>
        </tr>
    </table>
    <table style="width: 100%">
        <tbody>
            <tr>
                <td style="width: 10%;">Remarks :</td>
                <td style="width: 90%;">
                    <?php if(isset($invoice->remarks) && $invoice->remarks != ''): ?>
                        <div class=""><?php echo $invoice->remarks; ?></div>
                    <?php endif; ?>
                </td>
            </tr>
        </tbody>
    </table>

    <table id="invoice_table" style="width: 100%; margin-top: 5px; margin-right: 0; margin-left: -20px;">
        <thead>
            <tr>

                <th class="text-center" style="text-center: right;font-size:11px;" colspan="3" >Description</th>
                <th class="text-center"style="text-align: right;font-size:11px;">Qty</th>
                <th class="text-right" style="text-align: right;font-size:11px;">Unit Price</th>
                
                <th class="text-right"style="text-align: right;font-size:11px;">DISC%</th>
                <th class="text-right"style="text-align: right;font-size:11px;">Net Value</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $count = $invoiceproducts->count();
            ?>
            <?php $__currentLoopData = $invoiceproducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <tr class="text-body">
                    <td><?php echo e($product->product->stock_id); ?></td>
                    
                    <td colspan="2" style="width: 50%;"><?php echo e($product->product->item_code); ?>

                        <?php echo html_entity_decode($product->description, ENT_QUOTES); ?></td>
                    <td style="text-align: right;padding-right:1mm;"><?php echo e($product->qty); ?></td>
                    <td style="text-align: right;"><?php echo e(\App\Http\Helper::formatPrice($product->unit_price)); ?></td>
                    
                    <td style="text-align: right;">
                        <?php if($product->discount != '' && $product->discount != 0): ?>
                            <?php if($product->discount_type == 'P'): ?>
                                <?php echo e($product->discount); ?> %
                            <?php else: ?>
                                <?php echo e(\App\Http\Helper::formatPrice($product->discount)); ?>

                            <?php endif; ?>
                        <?php else: ?>
                            0.00
                        <?php endif; ?>
                    </td>
                    <td style="text-align: right;"><?php echo e(\App\Http\Helper::formatPrice($product->sub_total)); ?></td>
                </tr>


            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php for($count ;$count<10;$count++): ?>

                <tr>
                    <td> <br></td>
                </tr>
                <?php endfor; ?>
        </tbody>
    </table>
    <table style="width: 100% ; margin-top: 8px;margin-right:-22px;">
        <tr>
            <td style="width: 60%">
            </td>
            <td style="width: 5%"></td>
            <td style="width: 35%">
                <table style="width: 100%; text-align: right;">
                    <tbody class="text-body2">
                        <tr>
                            <td class="total">Gross Amount</td>
                            <td class="text-right"><?php echo e(\App\Http\Helper::formatPrice($invoice->sub_total)); ?></td>
                        </tr>
                        <?php if($invoice->discount != '' && $invoice->discount != 0): ?>
                            <tr>
                                <td class="total">Discount</td>
                                <?php if($invoice->discount_type == 'P'): ?>
                                    <td class="text-right">
                                        <?php echo e($invoice->discount); ?>%
                                    </td>
                                <?php else: ?>
                                    <td class="text-right">
                                        <?php echo e(\App\Http\Helper::formatPrice($invoice->discount)); ?>

                                    </td>
                                <?php endif; ?>
                            </tr>
                        <?php endif; ?>
                        <tr class="font-text-bold ">
                            <td class="total">Total Amount</td>
                            <td class="text-right"> <?php echo e(\App\Http\Helper::formatPrice($invoice->total)); ?></td>
                        </tr>
                    </tbody>
                </table>
                </th>
        </tr>
    </table>

</body>

</html>
<?php /**PATH /var/www/html/cmk-portal/packages/pramix/templates/src/views/generate_invoice.blade.php ENDPATH**/ ?>