<?php $__env->startSection('content'); ?>
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>Show Credit Note</h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="main-container">

            <div class="row gutter">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Customer Information</h5>
                            <p class="card-text">Name: <?php echo e($invoice_return->customer->company_name); ?></p>
                            <p class="card-text">Code: <?php echo e($invoice_return->customer->business_name); ?></p>
                            
                            <p class="card-text">
                                Return from Invoice:
                                <?php if($invoice_return->invoice_id): ?>
                                    <?php echo e($invoice_return->invoice->invoice_code ?? 'N/A'); ?>

                                <?php else: ?>
                                    <?php if($invoices->isNotEmpty()): ?>
                                        <?php echo e($invoices->pluck('invoice_code')->join(', ')); ?>

                                    <?php else: ?>
                                        No invoices found
                                    <?php endif; ?>
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Return Details</h5>
                            <p class="card-text">Return Code: <?php echo e($invoice_return->invoice_return_code); ?></p>
                            <p class="card-text">Return Date: <?php echo e($invoice_return->invoice_return_date); ?></p>
                            <p class="card-text">Remarks: <?php echo e($invoice_return->remarks); ?></p>
                        </div>
                    </div>
                </div>
                <div class="card mt-3">
                    <div class="card-body">
                        <h5 class="card-title">Returned Products</h5>
                        <table class="table">
                            <thead>
                                <tr>

                                    <th>Description</th>
                                    <th class="text-right">Quantity</th>
                                    <th class="text-right">Unit Price</th>
                                    <th class="text-right">Discount</th>
                                    <th class="text-center">Discount Type</th>
                                    <th class="text-right">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $invoice_return->invoiceReturnProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice_return_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-center"><?php echo e($invoice_return_product->description); ?></td>
                                        <td class="text-right"><?php echo e($invoice_return_product->qty); ?></td>
                                        <td class="text-right">Rs.
                                            <?php echo e(number_format($invoice_return_product->unit_price, 2)); ?></td>
                                        <td class="text-right">Rs. <?php echo e(number_format($invoice_return_product->discount, 2)); ?>

                                        </td>
                                        <td class="text-center"><?php echo e($invoice_return_product->discount_type); ?></td>
                                        <td class="text-right">Rs.
                                            <?php echo e(number_format($invoice_return_product->sub_total, 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                <!-- Add more rows for additional returned products -->
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-body">
                        <h5 class="card-title">CREDIT NOTE DEDUCT FROM</h5>
                        <table class="table">
                            <thead>
                                <tr>

                                    <th>Invoice return code</th>
                                    <th class="text-right">Invoice Return Date</th>
                                    <th class="text-right">Deduction Total</th>
                                    <th class="text-center">Remarks</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $deduction_invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deduction_invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>

                                        <td class="text-center"><?php echo e($deduction_invoice->invoice_return_code); ?></td>
                                        <td class="text-right"><?php echo e($deduction_invoice->invoice_return_date); ?></td>
                                        <td class="text-right">RS. <?php echo e(number_format($deduction_invoice->total, 2)); ?></td>
                                        <td class="text-center"><?php echo e($deduction_invoice->remarks); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                <!-- Add more rows for additional returned products -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/packages/pramix/xinvoice/src/views/invoice_return/show.blade.php ENDPATH**/ ?>