<?php $__env->startSection('content'); ?>
<input type="hidden" name="page" id="page" value="<?php echo e($page ?? ''); ?>">
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                            <h4>Cheque Return Payment List</h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    
                        <ul class="right-stats" id="mini-nav-right">
                            <a href="<?php echo e(url('cheque-return-payments/create')); ?>" class="btn btn-primary"><i class="fa fa-plus" aria-hidden="true"></i>
                                Add Cheque Return Payment</a>
                        </ul>
                    
                      </div>
            </div>
        </div>

        <div class="main-container">
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="<?php echo e(url('cheque-return-payments')); ?>" method="get" id="filter_form">
                            <div class="form-inline data_list_filters">
                                    <div class="form-group">
                                       <div class="col-sm-12">
                                           <label for="">Customer Name</label> <br>
                                           <select name="customer_id" class="form-control select2 select3 select-width" id="customer_id">
                                               <option value="">Select Customer Name</option>
                                               <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                               <option value="<?php echo e($customer->id); ?>" <?php if(request('customer_id') == $customer->id): ?> selected <?php endif; ?>><?php echo e($customer->company_name); ?></option>
                                               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                           </select>
                                       </div>
                                   </div>

                                   <div class="form-group">
                                       <label for="">Payment Ref Number</label> <br>
                                       <input type="text" class="form-control"  name="payment_ref_no"
                                       placeholder="PAY #" value="<?php echo e(request('payment_ref_no')); ?>">
                                   </div>

                                   <div class="form-group">
                                      <label for="">Search Payment Remarks</label><br>
                                      <input type="text" class="form-control" name="payment_remarks" placeholder="Search by Payment Remarks" value="<?php echo e(request('payment_remarks')); ?>">
                                   </div>
                                   <div class="form-group">
                                    <br><div class="col-sm-12 padding-mini">
                                        <label for="">Cheque Date</label><br>
                                        <input type="date" class="form-control" id="cheque_date" name="cheque_date"
                                               placeholder="Cheque Date" 
                                               value="<?php echo e(request('cheque_date', '')); ?>" 
                                               <?php if(!request('cheque_date')): ?> placeholder="Select Cheque Date" <?php endif; ?>>
                                    </div>
                                </div>
                                

                                   <div class="form-group padding-mini">
                                    <button type="submit" class="btn btn-primary">SUBMIT</button> &nbsp;
                                    <a href=" <?php echo e(url('cheque-return-payments')); ?> " class="btn btn-primary">Reset</a>
                                   </div>

                                    </div>
                                    </form>

                        </div>

                    </div>
                    <div class="table-responsive">
                        <table id="cheque_payment_list_table" class="table table-striped table-bordered no-margin dataTable no-footer"
                               cellspacing="0" width="100%">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Payment Code</th>
                                <th>Customer Name</th>
                                <th class="text-right">Payment Date</th>
                                <th class="text-right">Cheque Date</th>
                                <th>Payment Method</th>
                                <th>Payment Ref No</th>
                                <th>Payment Remarks</th>
                                <th class="text-right">Payment Amount</th>
                                <th class="text-center">Cheque Bank</th>
                                <th><?php echo e(__('common.labels.action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>

                                <?php if(!empty($returned_cheque_payments)): ?>
                                <?php $__currentLoopData = $returned_cheque_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $returned_cheque_payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($returned_cheque_payment->id); ?></td>
                                    <td><?php echo e($returned_cheque_payment->payment_code ? $returned_cheque_payment->payment_code : 'N/A'); ?></td>
                                    <td><?php echo e($returned_cheque_payment->customer->company_name); ?></td>
                                    <td class="text-right"><?php echo e($returned_cheque_payment->payment_date); ?></td>
                                    <td class="text-right"><?php echo e($returned_cheque_payment->cheque_date); ?></td>
                                    <td><?php echo e($returned_cheque_payment->payment_method); ?></td>
                                    <td><?php echo e($returned_cheque_payment->payment_ref_no ? $returned_cheque_payment->payment_ref_no : 'N/A'); ?></td>
                                    <td><?php echo e($returned_cheque_payment->payment_remarks ? $returned_cheque_payment->payment_remarks : 'N/A'); ?></td>
                                    <td class="text-right">RS. <?php echo e(number_format($returned_cheque_payment->total_payment_amount, 2)); ?></td>
                                    <td class="text-center"><?php echo e($returned_cheque_payment->bank_id ? getConfigArrayValueByKey('BANKS_LIST', $returned_cheque_payment->bank_id) : 'N/A'); ?></td>
                                    <td>
                                        <a href="<?php echo e(url('/cheque-return-payments/show/' . $returned_cheque_payment->id)); ?>" class="btn btn-warning btn-sm cheque_payment-view-button fa fa-eye"></a>
                                        <button class="btn btn-danger btn-sm delete_cheque_payment fa fa-trash-o" data-id="<?php echo e($returned_cheque_payment->id); ?>" aria-hidden="true"></button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        NO MATCHING RECORDS FOUND
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <div class="d-flex justify-content-end" >
                            <?php echo e($returned_cheque_payments->appends($_GET)->links()); ?>

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom_script'); ?>
<script>



    $('#cheque_payment_list_table').on('click','.delete_cheque_payment', function(){
        var cheque_payment_id = $(this).data('id');

        $.confirm({
                    title: 'Cheque Payment Delete!',
                    content: 'Are you sure?!',
                    buttons: {
                        cancel: function() {},
                        delete: {
                            text: 'Delete',
                            btnClass: 'btn-danger',
                            keys: ['enter', 'shift'],
                            action: function() {

                               
                                $.ajax({
                                    url: BASE + 'cheque-return-payments/delete/' + cheque_payment_id,
                                    type: 'POST',
                                    dataType: 'JSON',

                                    success: function(response) {
                                        if (response.status == 'success') {

                                            notification(response);
                                            location.reload();
                                        } else {
                                            notification(response);
                                            return false;
                                        }
                                    },
                                    error: function(xhr, ajaxOptions, thrownError) {

                                        notificationError(xhr, ajaxOptions,
                                            thrownError);
                                    }
                                });

                            }
                        }
                    }
                });
    })
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/resources/views/cheque_return_payment/index.blade.php ENDPATH**/ ?>