<?php $__env->startSection('content'); ?>
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <?php
                            if(\Illuminate\Support\Facades\Route::is('reports.daily_sales_summary_report')) {
                                $reportName = 'DAILY SALE SUMMERY';
                            }
                        ?>
                        <h4><?php echo e($reportName); ?></h4>
                    </div>
                </div>

            </div>
        </div>
        <!-- Top bar ends -->

        <!-- Main container starts -->
        <div class="main-container">
            <!-- Row starts -->
            <div class="row gutter">
                <div class="card">
                    <div class="card-body">
                        <form class="" action="#" id="report-filter">
                            <div class="row">
                                <div class="col-sm-3">
                                    <label>Invoice Date</label>
                                    <?php echo $__env->make('xreports::common.report_date_range_select', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label>REP</label>
                                        <div class="form-group">
                                            
                                            <select name="rep_id" id="rep_id" class="form-control select2">
                                                <option value="">Select Rep</option>
                                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <option value="<?php echo e($role->id); ?>"><?php echo e($role->username); ?> - <?php echo e($role ->fname); ?></option>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label>Customer</label>
                                        <?php
                                            $customers = \Pramix\XCustomer\Models\CustomerModel::all();
                                            $user = Auth::user();
                                            if ($user->username != 'admin' && $user->username != 'user35') {
                                                if (Auth::user()->can(['SHOW_OWN_CUSTOMERS'])) {
                                                    $customers = $customers->where('rep_id', $user->id);
                                                }
                                            }
                                            if ($user->username == 'user35') {
                                                $customers = $customers->where('invoice_type', '35');
                                            }
                                            $customers = $customers->pluck('company_name', 'id');
                                        ?>
                                        <div class="form-group">
                                            <?php echo e(Form::select('customer_id', $customers, '', ['class' => 'form-control select2', 'placeholder' => 'Select Customer', 'id' => 'customer_id'])); ?>

                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-sm-2">
                                    <br>
                                    <button id="generate_report_btn" class="btn btn-primary">
                                        <span id="spinner" hidden class="spinner-border spinner-border-sm" role="status"
                                            aria-hidden="true"></span> Generate
                                    </button>
                                </div>
                            </div>


                        </form>
                    </div>
                </div>
            </div>
            <!-- Row ends -->

        </div>
        <!-- Main container ends -->

    </div>
    <!-- Dashboard wrapper ends -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('include_js'); ?>
    <script src="<?php echo e(asset('/pramix/js/reports_js.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function() {
            $("#generate_report_btn").click(function(e) {
                $('#generate_report_btn').prop('disabled', true);
                $('#spinner').prop('hidden', false);

                var date_range = $('#date_range').val();
                var rep = $('#rep_id').val();
                var customer = $('#customer_id').val();

                if(date_range === '')
                {
                    notification({ status: 'error', msg: 'Please select Rep or Customer to proceed.!' });
                    e.preventDefault();
                    location.reload();
                }

                // else if (rep === '' && customer === '')
                // {

                //     notification({ status: 'error', msg: 'Please select Rep or Customer to proceed.!' });
                //     e.preventDefault();
                //     location.reload();
                // }
                else{

                    var params = {
                        filter_details: $('#report-filter :input').serialize(),
                        report: '<?php echo e($reportName); ?>'
                    };
                    e.preventDefault();
                    $.ajax({
                        url: "<?php echo e(route('reports.generate_sales_commission_report')); ?>",
                        type: 'POST',
                        dataType: 'JSON',
                        data: $.param(params),
                        success: function(response) {
                            $('#generate_report_btn').prop('disabled', false);
                            $('#spinner').prop('hidden', true);
                            var url = response.report_url
                            window.open(url, '_blank');
                        },
                    });
                    e.preventDefault();
                    return false;
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/packages/pramix/xreports/src/views/commission/sales_commission/index.blade.php ENDPATH**/ ?>