<?php $__env->startSection('content'); ?>
    <input type="hidden" name="page" id="page" value="<?php echo e($page ?? ''); ?>">
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4><?php echo e(__('xpayment::payment.headings.payment')); ?></h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ADD_PAYMENT')): ?>
                        <ul class="right-stats" id="mini-nav-right">
                            <a href="<?php echo e(url('payment/create/new')); ?>" class="btn btn-primary"><i class="fa fa-plus"
                                    aria-hidden="true"></i>
                                <?php echo e(__('xpayment::payment.buttons.new_payment')); ?></a>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="main-container">
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="<?php echo e(route('payment.index')); ?>">

                                
                                <div class="row gutter">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="">Payment Receipt Number</label> <br>
                                            <input type="text" class="form-control" name="payment_receipt_no"
                                                value="<?php echo e(request('payment_receipt_no')); ?>" id="searchpaymentycode"
                                                placeholder="<?php echo e(__('xpayment::payment.labels.payment_receipt_no')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="">Payment Date</label> <br>
                                            <input name="payment_date" value="<?php echo e(request('payment_date')); ?>"
                                                class="form-control dates">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="">Pay Customer</label> <br>
                                            <input type="text" class="form-control" name="customer_name"
                                                value="<?php echo e(request('customer_name')); ?>" id="searchcustomername"
                                                placeholder="<?php echo e(__('xpayment::payment.labels.payment_customer')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="rep">Select Rep</label> <br>
                                            <select name="rep_id" id="rep" class="form-control select2 select3">
                                                <option value="">Select Rep</option>
                                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($role->id); ?>"
                                                        <?php if(request('rep_id') == $role->id): ?> selected <?php endif; ?>>
                                                        <?php echo e($role->username); ?> - <?php echo e($role->fname); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="">Cheque no</label> <br>
                                            <input type="text" class="form-control" name="cheque_no"
                                                value="<?php echo e(request('cheque_no')); ?>" id="searchcustomername"
                                                placeholder="CHEQUE NO">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="">Amount</label> <br>
                                            <input type="number" step="0.01" min="0" class="form-control"
                                                name="amount" value="<?php echo e(request('amount')); ?>" id=""
                                                placeholder="Amount" onwheel="this.blur()">
                                        </div>
                                    </div>
                                </div>
                                <div class="row gutter mt-3">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="btn-group" data-toggle="buttons">
                                                <label class="btn btn-primary active">
                                                    <input type="radio" name="payment_status" value=""
                                                        <?php if(request('payment_status') == ''): ?> checked <?php endif; ?>> All
                                                </label>
                                                <label class="btn btn-primary" id="all_status" data-toggle="tooltip"
                                                    data-placement="top" title="Status">
                                                    <input type="radio" name="payment_status" value="COMPLETED"
                                                        <?php if(request('payment_status') == 'COMPLETED'): ?> checked <?php endif; ?>> Completed
                                                </label>
                                                <label class="btn btn-primary ">
                                                    <input type="radio" name="payment_status" value="CANCELLED"
                                                        <?php if(request('payment_status') == 'CANCELLED'): ?> checked <?php endif; ?>> Cancelled
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        &nbsp;&nbsp;<button type="submit"
                                            class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Submit</button>
                                    </div>
                                    <div class="form-group">
                                        &nbsp;&nbsp; <a href="<?php echo e(route('payment.index')); ?>"
                                            class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Reset</a>
                                    </div>
                                </div>
                                
                            </form>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table id="payment_list_table" class="table table-striped table-bordered no-margin"
                            cellspacing="0" width="100%">
                            <thead>
                                <tr>

                                    <th></th>
                                    <th>PAYMENT RECEIPT NUMBER</th>
                                    <th>PAYMENT METHOD</th>
                                    <th>PAY CUSTOMER</th>
                                    <th>CHEQUE NO</th>
                                    <th>PAYMENT REMARKS</th>
                                    <th>AMOUNT</th>
                                    <th>PAYMENT DATE</th>
                                    <th>STATUS</th>
                                    <th>REP</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(!empty($payments)): ?>
                                    <?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($payment->id); ?></td>
                                            <td><?php echo e($payment->payment_code); ?></td>
                                            <td><?php echo e($payment->payment_method); ?></td>
                                            <td>
                                                <?php if(isset($payment->invoice->customer->business_name)): ?>
                                                    <?php echo e($payment->invoice->customer->business_name); ?>

                                                <?php elseif(isset($payment->customer->business_name)): ?>
                                                    <?php echo e($payment->customer->business_name); ?>

                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>
                                                -
                                                <?php if(isset($payment->invoice->customer->company_name)): ?>
                                                    <?php echo e($payment->invoice->customer->company_name); ?>

                                                <?php elseif(isset($payment->customer->company_name)): ?>
                                                    <?php echo e($payment->customer->company_name); ?>

                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>
                                            </td>
                                            
                                            <td><?php echo e(!empty($payment->cheque->payment_ref_no) ? $payment->cheque->payment_ref_no : ''); ?>

                                            </td>
                                            <td><?php echo e($payment->payment_remarks); ?></td>
                                            <td><?php echo e(App\Http\Helper::formatPrice($payment->payment_amount)); ?></td>
                                            <td><?php echo e($payment->payment_date); ?></td>
                                            <td>
                                                <?php if($payment->status != 0): ?>
                                                    <span class="text-success"><strong>Completed</strong></span>
                                                <?php elseif($payment->cheque_status == 2): ?>
                                                    <span class="text-danger"><strong>Cancelled</strong></span>
                                                <?php else: ?>
                                                    <span class="text-warning"><strong>Pending</strong></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(!empty($payment->rep_id)): ?>
                                                    

                                                    <?php
                                                        $rep = DB::table('users')->find($payment->rep_id);
                                                        // dd($rep);
                                                    ?>
                                                    <?php echo e($rep->username); ?>

                                                <?php else: ?>
                                                    <?php echo e('N/A'); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <button class="btn btn-warning btn-sm payment-view-button fa fa-eye"
                                                    aria-hidden="true"></button>
                                                
                                                <button class="btn btn-danger btn-sm delete_payment fa fa-trash-o"
                                                    aria-hidden="true"></button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="11" class="text-center">No found data.</td>
                                        </tr>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="11" class="text-center">No found data.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <?php if(!empty($payments)): ?>
                            <div class="d-flex justify-content-end">
                                <?php echo e($payments->appends($_GET)->links()); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function() {



            $('#payment_list_table tbody').on('click', 'button.payment-print-button', function(e) {

                // var $btn = $(this);
                // $btn.button('loading');
                var data = {};
                var payment_id = $('#payment_id').val();
                data['id'] = payment_id;
                var params = {
                    invoice_id: data['invoice_id'],
                    record_payment_id: data['id']
                };
                $.ajax({
                    url: BASE + 'invoice/print_payment',
                    type: 'POST',
                    dataType: 'JSON',
                    data: $.param(params),
                    success: function(response) {
                        if (response.status == 'success') {
                            window.open(response.url);
                            // $btn.button('reset');

                        } else {
                            notification(response);
                            // $btn.button('reset');
                            return false;
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        notificationError(xhr, ajaxOptions, thrownError);
                    }
                });
                return false;
            });

            $(document).on('click', '.payment-view-button', function(e) {

                var data = {};
                var firstTDValue = $(this).closest('tr').find('td:first').text().trim();
                data['id'] = firstTDValue;
                window.payment_model = $.confirm({
                    title: '',
                    draggable: true,
                    boxWidth: '80%',
                    closeIcon: true,
                    useBootstrap: false,
                    buttons: {
                        close: function() {}
                    },
                    content: 'url:' + BASE + 'payment/view/' + data['id'],
                    onContentReady: function() {},
                    columnClass: 'medium',
                });
                return false;
            });
            // $(document).on('click', '.delete_payment', function(e) {
            //     var data = {};
            //     var firstTDValue = $(this).closest('tr').find('td:first').text().trim();
            //     data['id'] = firstTDValue;
            //     var parent = $(this).parents('tr');
            //     let url = "<?php echo e(route('payment.destroy', ':id')); ?>";
            //     url = url.replace(':id', data['id']);
            //     var delete_confirm = $.confirm({
            //         title: "Delete Payment",
            //         type: 'red',
            //         buttons: {
            //             delete: {
            //                 text: 'Delete',
            //                 btnClass: 'btn-red',
            //                 action: function() {
            //                     e.preventDefault();
            //                     var params = {};
            //                     $.ajax({
            //                         url: url,
            //                         type: 'DELETE',
            //                         dataType: 'JSON',
            //                         data: $.param(params),
            //                         success: function(response) {
            //                             if (response.status == 'error') {
            //                                 delete_confirm.close();
            //                                 notification(response);
            //                             } else {
            //                                 delete_confirm.close();
            //                                 notification(response);
            //                                location.reload();
            //                             }
            //                         },
            //                         error: function(errors) {}
            //                     });
            //                     e.preventDefault();
            //                     return false;
            //                 }
            //             },
            //             close: function() {}
            //         }
            //     });
            // });
            $(document).on('click', '.delete_payment', function(e) {
                var data = {};
                var firstTDValue = $(this).closest('tr').find('td:first').text().trim();
                data['id'] = firstTDValue;
                var parent = $(this).parents('tr');
                let url = "<?php echo e(route('payment.destroy', ':id')); ?>";
                url = url.replace(':id', data['id']);
                var delete_confirm = $.confirm({
                    title: "Delete Payment",
                    type: 'red',
                    buttons: {
                        delete: {
                            text: 'Delete',
                            btnClass: 'btn-red',
                            action: function() {
                                e.preventDefault();
                                var params = {};

                                // Get CSRF token value from the page
                                var csrfToken = $('meta[name="csrf-token"]').attr('content');

                                // Include CSRF token in headers
                                $.ajaxSetup({
                                    headers: {
                                        'X-CSRF-TOKEN': csrfToken
                                    }
                                });

                                $.ajax({
                                    url: url,
                                    type: 'DELETE',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function(response) {
                                        if (response.status == 'error') {
                                            delete_confirm.close();
                                            notification(response);
                                        } else {
                                            delete_confirm.close();
                                            notification(response);
                                            location.reload();
                                        }
                                    },
                                    error: function(errors) {}
                                });
                                e.preventDefault();
                                return false;
                            }
                        },
                        close: function() {}
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/packages/pramix/xpayments/src/views/payments_list.blade.php ENDPATH**/ ?>