<?php $__env->startSection('include_css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('/pramix/css/custom.css')); ?>">
    <style>
        #create_new_customer_model {
            display: none !important;
        }

        .info-label {
            font-size: 1.1em;
            font-weight: 600;
        }

        .info-value {
            font-size: 1.1em;
            padding-left: 8px;
        }

        .outstanding_amount {
            color: red;
            font-size: 17px;
            font-weight: 900;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4><?php echo e(__('xinvoice::invoice.headings.new_credit_note')); ?></h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <ul class="right-stats">
                        <a href="javascript:void(0)" class="btn btn-primary"
                            id="invoice_return_save"><?php echo e(__('xinvoice::invoice.buttons.save')); ?></a>
                    </ul>
                </div>
            </div>
        </div>

        <div class="main-container">
            <!-- Step 1: Form for Customer and Invoice Selection -->
            <div class="row gutter">
                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                    <div class="card">
                        <div class="card-body" id="customer_filter">
                            
                            <form action="<?php echo e(route('invoice_return.create_new')); ?>" method="GET" id="load_invoice_form">
                                <?php echo $__env->make('xcustomer::customer_filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <div class="form-group">
                                    <label for="invoice_code_selected">Invoice Code</label>
                                    <select class="form-control select2" id="invoice_code_selected"
                                        name="invoice_code_selected">
                                        
                                        <?php $__currentLoopData = $customer_invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice_option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($invoice_option->id); ?>"
                                                <?php echo e($invoice_id == $invoice_option->id ? 'selected' : ''); ?>>
                                                <?php echo e($invoice_option->invoice_code); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                
                            </form>
                            
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                    <div class="alert alert-info alert-dismissible" id="customer_info_alert" style="display: none;"></div>
                    <div class="alert alert-info alert-dismissible" id="products_info_alert" style="display: none;"></div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                    <div class="card" id="invoice_return_details_panel">
                        <div class="card-body disabled" id="invoice_return_details_card_body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <?php echo e(formText(__('xinvoice::invoice.labels.invoice_return_code'), 'invoice_return_no', '', ['class' => 'form-control ', 'id' => 'invoice_return_no', 'readonly' => 'readonly'])); ?>

                                </div>
                                <div class="col-sm-12">
                                    <?php echo e(formDate('Credit note date', 'invoice_return_date_created', old('date_created', \Carbon\Carbon::today()->format('Y-m-d')), ['class' => 'form-control', 'id' => 'invoice_return_date_created'])); ?>

                                </div>
                                <div class="col-md-12">
                                    <?php echo e(formTextArea('Remarks', 'remarks', '', ['class' => 'form-control ', 'rows' => '2', 'id' => 'parent_remark'])); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Step 1 -->

            <hr>

            <!-- Step 2: Form for Creating the Return -->
            <form action="<?php echo e(route('invoice_return.store_new')); ?>" method="POST" id="create_return_form">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="customer_id" id="customer_id" value="<?php echo e($customer_id ?? ''); ?>">
                <input type="hidden" name="invoice_id" value="<?php echo e($invoice_id ?? ''); ?>">
                <input type="hidden" name="invoice_ids" value="" id="input_invoice_id">
                <input type="hidden" name="" value="" id="input_invoice_text">

                <input type="hidden" name="invoice_return_date_created" value=""
                    id="invoice_return_date_created_hidden">
                <input type="hidden" name="remarks" value="" id="remarks_hidden">

                <!-- Product selection panel with labels -->
                <div class="card card-primary" id="product-detail-card">
                    <div class="card-body disabled" id="product_detail_card_body">
                        <div class="row gutter">
                            <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                                <div class="form-group">
                                    <label for="item_stock_id">Stock ID</label>
                                    <select name="stock_id" id="item_stock_id" class="form-control select2">
                                        <option value="">Select Stock ID</option>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($product->id); ?>"><?php echo e($product->stock_id); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                                <div class="form-group">
                                    <label for="invoice_return_item_product_code">Item</label><br>
                                    <select name="products" id="invoice_return_item_product_code"
                                        class="form-control select2">
                                        <option value="">Select Product</option>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($product->id); ?>"><?php echo e($product->item_code); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                                <div class="form-group no-margin">
                                    <label for="description">Description</label>
                                    <input type="text" class="form-control" id="description" name="description"
                                        placeholder="Description">
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-2 col-sm-6 col-xs-12">
                                <div class="form-group no-margin">
                                    <label for="quantity">Quantity</label>
                                    <input type="number" class="form-control" id="quantity" name="quantity"
                                        onwheel="this.blur()" placeholder="Qty">
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-2 col-sm-6 col-xs-12">
                                <div class="form-group no-margin">
                                    <label for="unit_price">Unit Price</label>
                                    <input type="number" step="0.01" class="form-control" id="unit_price"
                                        name="unit_price" onwheel="this.blur()" placeholder="Price">
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-2 col-sm-6 col-xs-12">
                                <div class="form-group no-margin">
                                    <label for="product_discount">Discount</label>
                                    <input type="number" step="0.01" class="form-control" id="product_discount"
                                        name="discount" onwheel="this.blur()" placeholder="Discount">
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-2 col-sm-6 col-xs-12">
                                <div class="form-group no-margin">
                                    <label for="product_discount_type">Type</label>
                                    <?php echo e(Form::select('discount_type', getConfig('DISCOUNT_TYPE'), 'P', ['class' => 'form-control', 'id' => 'product_discount_type', 'style' => 'height: 33px'])); ?>

                                </div>
                            </div>
                            <div class="col-lg-1 col-md-4 col-sm-6 col-xs-12" style="padding-top: 15px;">
                                <div class="checkbox checkbox-inline">
                                    <input type="checkbox" id="checked_discarded" name='checked_discarded' />
                                    <label for="checked_discarded">Discarded</label>
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-4 col-sm-6 col-xs-12" style="padding-top: 15px;">
                                <div class="form-group no-margin">
                                    <button type="button" class="btn btn-success btn-block"
                                        id="add_item_row_btn">ADD</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row gutter">
                    <div class="col-12">
                        <div class="table-responsive">
                            <table id="ProductTable" class="table table-bordered no-margin" cellspacing="0"
                                width="100%">
                                <thead>
                                    <tr>
                                        <th>INVOICE CODE</th>
                                        <th>ITEM</th>
                                        <th>DESCRIPTION</th>
                                        <th>QTY</th>
                                        <th class="text-right">UNIT PRICE</th>
                                        <th class="text-right">DISCOUNT</th>
                                        <th class="text-right">SUB TOTAL</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="6" class="text-right">GRAND TOTAL</th>
                                        <th class="text-right" id="grand_total">0.00</th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="d-flex justify-content-between">
                    <h5>Credit Note Deduct from</h5>
                    <div class="d-flex justify-content-end">
                        <span class="outstanding_amount">0.00</span>
                    </div>
                </div>
                <div class="card card-primary">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="PendingInvoiceTable" class="table table-striped table-bordered no-margin"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>Invoice No</th>
                                        <th>Invoice Date</th>
                                        <th class="text-right">Total</th>
                                        <th class="text-right">Paid</th>
                                        <th class="text-right">Balance</th>
                                        <th>Credit Note Balance</th>
                                        <th>Remarks</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $outstanding_invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $outstanding_invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><input type="checkbox" class="cn-checkbox"
                                                    name="deduct_invoices[<?php echo e($outstanding_invoice->id); ?>][id]"
                                                    value="<?php echo e($outstanding_invoice->id); ?>"></td>
                                            <td><?php echo e($outstanding_invoice->invoice_code); ?></td>
                                            <td><?php echo e($outstanding_invoice->invoice_date); ?></td>
                                            <td class="text-right"><?php echo e(number_format($outstanding_invoice->total, 2)); ?>

                                            </td>
                                            <td class="text-right">
                                                <?php echo e(number_format($outstanding_invoice->paid_amount, 2)); ?></td>
                                            <td class="text-right balance-cell">
                                                <?php echo e(number_format($outstanding_invoice->balance, 2)); ?></td>
                                            <td><input type="number" step="0.01"
                                                    class="form-control cn-balance-input"
                                                    name="deduct_invoices[<?php echo e($outstanding_invoice->id); ?>][amount]"
                                                    onwheel="this.blur()" placeholder="0.00" disabled></td>
                                            <td><input type="text" class="form-control cn-remarks-input"
                                                    name="deduct_invoices[<?php echo e($outstanding_invoice->id); ?>][remarks]"
                                                    placeholder="Remarks" disabled></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="7" class="text-center">No outstanding invoices found or no
                                                invoice loaded.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Customer History Modal -->
    <div class="modal fade" id="customerHistoryModal" tabindex="-1" role="dialog"
        aria-labelledby="customerHistoryModalLabel" aria-hidden="true">
        
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function() {

            // --- NEW: Display Session-based Notifications ---
            <?php if(session('success')): ?>
                $.notify({
                    message: "<?php echo e(session('success')); ?>"
                }, {
                    type: 'success',
                    z_index: 10000,
                });
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    $.notify({
                        message: "<?php echo e($error); ?>"
                    }, {
                        type: 'danger',
                        z_index: 10000,
                    });
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            // --- END: Notifications ---

            var customerId = "<?php echo e($customer_id ?? ''); ?>";
            if (customerId) {
                if (typeof changeCustomer !== 'undefined') {
                    changeCustomer.run(customerId, '', '');
                }
            }

            $(document).on('change', '#customer_id_selected', function() {
                var customerId = $(this).val();

                $('#invoice_return_details_card_body').removeClass('disabled');
                $('#product_detail_card_body').removeClass('disabled');

                if (!customerId) {
                    $('#invoice_return_details_card_body').addClass('disabled');
                    $('#product_detail_card_body').addClass('disabled');
                    $('#PendingInvoiceTable tbody').html(
                        '<tr><td colspan="8" class="text-center">No outstanding invoices found.</td></tr>'
                    );
                    return;
                }

                $('#input_invoice_id').val('');
                $('#input_invoice_text').val('');
                $('#ProductTable tbody').empty();
                updateGrandTotal();

                $.ajax({
                    url: "<?php echo e(route('invoice_return.customer_outstanding')); ?>",
                    type: 'POST',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        customer_id: customerId
                    },
                    success: function(response) {
                        if (response.status === 'success') {
                            var rows = '';
                            if (response.data.length > 0) {
                                $.each(response.data, function(i, inv) {
                                    rows += `
                            <tr>
                                <td><input type="checkbox" class="cn-checkbox"
                                    name="deduct_invoices[${inv.id}][id]"
                                    value="${inv.id}"></td>
                                <td>${inv.invoice_code}</td>
                                <td>${inv.invoice_date}</td>
                                <td class="text-right">${parseFloat(inv.total).toFixed(2)}</td>
                                <td class="text-right">${parseFloat(inv.paid_amount).toFixed(2)}</td>
                                <td class="text-right balance-cell">${parseFloat(inv.balance).toFixed(2)}</td>
                                <td><input type="number" step="0.01" class="form-control cn-balance-input"
                                    name="deduct_invoices[${inv.id}][amount]" onwheel="this.blur()" placeholder="0.00" disabled></td>
                                <td><input type="text" class="form-control cn-remarks-input"
                                    name="deduct_invoices[${inv.id}][remarks]" placeholder="Remarks" disabled></td>
                            </tr>
                        `;
                                });
                            } else {
                                rows =
                                    '<tr><td colspan="8" class="text-center">No outstanding invoices found.</td></tr>';
                            }
                            $('#PendingInvoiceTable tbody').html(rows);
                        }
                    }
                });
            });

            $('#invoice_code_selected').on('change', function() {
                let invoiceId = $(this).val();
                let invoice_code = $(this).find("option:selected").text();

                if (!invoiceId) {
                    return;
                }

                $('#input_invoice_id').val(invoiceId);
                $('#input_invoice_text').val(invoice_code);

                $.ajax({
                    url: '/invoice/' + invoiceId + '/products',
                    method: 'GET',
                    success: function(products) {
                        // Clear and set default first options
                        $('#item_stock_id')
                            .empty()
                            .append('<option value="">Select Stock ID</option>');

                        $('#invoice_return_item_product_code')
                            .empty()
                            .append('<option value="">Select Product</option>');

                        // Loop through products and append options
                        products.forEach(function(p) {
                            $('#item_stock_id').append(
                                $('<option>', {
                                    value: p.id,
                                    text: p.stock_id
                                })
                            );
                            $('#invoice_return_item_product_code').append(
                                $('<option>', {
                                    value: p.id,
                                    text: p.item_code
                                })
                            );
                        });

                        // Reset other fields
                        $('#description').val('');
                        $('#quantity').val('');
                        $('#unit_price').val('');
                        $('#product_discount').val('');
                        $('#product_discount_type').val('P').trigger('change');
                        $('#checked_discarded').prop('checked', false);

                        // Refresh select2 without triggering change event
                        $('#item_stock_id, #invoice_return_item_product_code').select2();
                    },
                    error: function() {
                        alert('Error loading products for this invoice.');
                    }
                });
            });

            var originalQuantities = {}; // To store original purchased quantities

            $('#invoice_return_item_product_code, #item_stock_id').on('change', function(e) {
                var selectedValue = $(this).val();
                var triggerId = $(this).attr('id');

                if (triggerId === 'invoice_return_item_product_code') {
                    if ($('#item_stock_id').val() !== selectedValue) $('#item_stock_id').val(selectedValue)
                        .trigger('change.select2');
                } else {
                    if ($('#invoice_return_item_product_code').val() !== selectedValue) $(
                        '#invoice_return_item_product_code').val(selectedValue).trigger(
                        'change.select2');
                }

                var productId = selectedValue;
                // var invoiceId = "<?php echo e($invoice_id ?? ''); ?>";
                var invoiceId = $('#invoice_code_selected').val();

                if (!productId || !invoiceId) {
                    $('#description, #quantity, #unit_price, #product_discount').val('');
                    $('#products_info_alert').hide('slow');
                    return;
                }

                $.ajax({
                    url: "<?php echo e(route('invoice_return.product_details')); ?>",
                    type: 'POST',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        product_id: productId,
                        invoice_id: invoiceId
                    },
                    success: function(response) {
                        if (response.status == 'success' && response
                            .invoice_return_product_detail) {
                            var details = response.invoice_return_product_detail;
                            $('#description').val(details.description);
                            $('#quantity').val(1).focus();
                            $('#unit_price').val(details.unit_price);
                            $('#product_discount').val(details.discount);
                            $('#product_discount_type').val(details.discount_type);

                            originalQuantities[productId] = details
                                .qty; // Store original quantity

                            var tooltip = "<div class='row'>" +
                                "<div class='col-sm-12'><strong>" + details.product.item_code +
                                "</strong></div>" +
                                "<div class='col-sm-9'>No. of Items Purchased : " + details
                                .qty + "</div>" +
                                "</div>";
                            $('#products_info_alert').html(tooltip).show('slow');
                        } else {
                            $('#description, #quantity, #unit_price, #product_discount').val(
                                '');
                            $('#products_info_alert').hide('slow');
                        }
                    }
                });
            });

            var grandTotal = 0;
            var rowCounter = 0;

            function updateGrandTotal() {
                grandTotal = 0;
                $('#ProductTable tbody tr').each(function() {
                    var subTotal = parseFloat($(this).data('subtotal'));
                    if (!isNaN(subTotal)) grandTotal += subTotal;
                });
                $('#grand_total').text(grandTotal.toFixed(2));

                calculateOutstanding();
            }

            $('#add_item_row_btn').on('click', function() {
                var productId = $('#invoice_return_item_product_code').val();
                var quantity = parseFloat($('#quantity').val());

                if (!productId) {
                    alert('Please select an item to add.');
                    return;
                }
                if (!quantity || quantity <= 0) {
                    alert('Please enter a valid quantity greater than zero.');
                    return;
                }
                if (originalQuantities[productId] !== undefined && quantity > originalQuantities[
                        productId]) {
                    alert('Return quantity (' + quantity +
                        ') cannot exceed the original purchased quantity of ' + originalQuantities[
                            productId] + '.');
                    return;
                }

                var input_invoice_id = $('#input_invoice_id').val();
                var input_invoice_text = $('#input_invoice_text').val();
                var productText = $('#invoice_return_item_product_code option:selected').text();
                var description = $('#description').val();
                var unitPrice = parseFloat($('#unit_price').val());
                var discount = parseFloat($('#product_discount').val()) || 0;
                var discountType = $('#product_discount_type').val();
                var isDiscarded = $('#checked_discarded').is(':checked') ? 1 : 0;

                var subTotal = 0;
                var discountAmount = 0;
                if (discountType === 'P') {
                    discountAmount = (quantity * unitPrice) * (discount / 100);
                } else {
                    discountAmount = discount;
                }
                subTotal = (quantity * unitPrice) - discountAmount;

                var newRow = `
                <tr data-subtotal="${subTotal.toFixed(2)}">
                    <td>
                        ${input_invoice_text}
                        <input type="hidden" name="return_items[${rowCounter}][invoice_id]" value="${input_invoice_id}">
                    </td>
                    <td>
                        ${productText}
                        <input type="hidden" name="return_items[${rowCounter}][product_id]" value="${productId}">
                        <input type="hidden" name="return_items[${rowCounter}][discarded]" value="${isDiscarded}">
                    </td>
                    <td>
                        ${description}
                        <input type="hidden" name="return_items[${rowCounter}][description]" value="${description}">
                    </td>
                    <td>
                        ${quantity}
                        <input type="hidden" name="return_items[${rowCounter}][quantity]" value="${quantity}">
                    </td>
                    <td class="text-right">
                        ${unitPrice.toFixed(2)}
                        <input type="hidden" name="return_items[${rowCounter}][unit_price]" value="${unitPrice}">
                    </td>
                    <td class="text-right">
                        ${discountAmount.toFixed(2)}
                        <input type="hidden" name="return_items[${rowCounter}][discount]" value="${discount}">
                        <input type="hidden" name="return_items[${rowCounter}][discount_type]" value="${discountType}">
                    </td>
                    <td class="text-right">
                        ${subTotal.toFixed(2)}
                        <input type="hidden" name="return_items[${rowCounter}][sub_total]" value="${subTotal.toFixed(2)}">
                    </td>
                    <td><button type="button" class="btn btn-danger btn-xs delete-row"><i class="fa fa-trash"></i></button></td>
                </tr>
            `;

                $('#ProductTable tbody').append(newRow);
                rowCounter++;
                updateGrandTotal();
                $('#invoice_return_item_product_code').val('').trigger('change');
                $('#checked_discarded').prop('checked', false);
            });

            $('#ProductTable').on('click', '.delete-row', function() {
                $(this).closest('tr').remove();
                updateGrandTotal();
            });

            $('#PendingInvoiceTable').on('change', '.cn-checkbox', function() {
                var isChecked = $(this).is(':checked');
                var $balance_input = $(this).closest('tr').find('.cn-balance-input');
                var $remarks_input = $(this).closest('tr').find('.cn-remarks-input');
                $balance_input.prop('disabled', !isChecked);
                $remarks_input.prop('disabled', !isChecked);
                if (!isChecked) $balance_input.val('');
                if (!isChecked) $remarks_input.val('');

                calculateOutstanding();
            });

            $('#invoice_return_save').on('click', function(e) {
                e.preventDefault();

                if (!$('#invoice_return_date_created').val()) {
                    alert('Please select a Credit note date.');
                    return;
                }

                if ($('#ProductTable tbody tr').length === 0) {
                    alert('Please add at least one item to return before saving.');
                    return;
                }

                var grandTotalVal = parseFloat($('#grand_total').text());
                var totalCreditApplied = 0;
                var validationPassed = true;

                $('#PendingInvoiceTable .cn-checkbox:checked').each(function() {
                    var $row = $(this).closest('tr');
                    var balance = parseFloat($row.find('.balance-cell').text().replace(/,/g, ''));
                    var appliedAmount = parseFloat($row.find('.cn-balance-input').val());

                    if (isNaN(appliedAmount) || appliedAmount <= 0) {
                        alert('Please enter a valid amount for the checked invoices.');
                        validationPassed = false;
                        return false;
                    }

                    // if (appliedAmount > balance) {
                    //     var invoiceCode = $row.find('td:eq(1)').text();
                    //     alert('Credit for invoice ' + invoiceCode + ' (' + appliedAmount.toFixed(
                    //             2) + ') cannot exceed its outstanding balance of ' + balance
                    //         .toFixed(2) + '.');
                    //     validationPassed = false;
                    //     return false;
                    // }
                    totalCreditApplied += appliedAmount;
                });

                if (!validationPassed) return;

                if (Math.abs(grandTotalVal - totalCreditApplied) > 0.01) {
                    alert('The Total Credit Applied (' + totalCreditApplied.toFixed(2) +
                        ') must exactly match the Grand Total of returned items (' + grandTotalVal
                        .toFixed(2) + ').');
                    return;
                }

                $('#invoice_return_date_created_hidden').val($('#invoice_return_date_created').val());
                $('#remarks_hidden').val($('#parent_remark').val());

                var button = $(this);
                button.addClass('disabled');

                $('#create_return_form').submit();
            });

            $(document).on('keyup change', '.cn-balance-input', function() {
                calculateOutstanding();
            });
        });

        // Calculate outstanding amount
        function calculateOutstanding() {
            let paymentAmount = parseFloat($('#grand_total').text()) || 0;
            let totalAllocated = 0;

            $('.cn-balance-input').each(function() {
                let val = parseFloat($(this).val());
                if (!isNaN(val)) {
                    totalAllocated += val;
                }
            });

            let outstanding = paymentAmount - totalAllocated;
            $('.outstanding_amount').text(outstanding.toFixed(2));
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(Request::ajax() ? 'layouts.model' : 'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/cmk-portal/resources/views/invoice_return/create_return.blade.php ENDPATH**/ ?>