<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Http\Controllers\FileAttechController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

Route::get('/', 'HomeController@index')->name('home');
Route::get('/bulk/price/update', 'HomeController@bulk')->name('bulk');
Route::post('/bulk/price/update', 'HomeController@bulkUpdate')->name('bulk-update');

Route::get('/file/upload/{id}', 'FileAttechController@index')->name('file-attech');
Route::post('/file/upload/store', 'FileAttechController@store')->name('file-attech-store');


//* audit log
Route::get('log', 'AuditLogController@index')->name('log');
Route::get('log/list', 'AuditLogController@auditLogList')->name('log.list');

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

Route::get('/register', 'HomeController@index');


Route::get('/update', function () {
    // if (Auth::check()) {
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('config:cache');
    dd('Updated');
    //
});

Route::get('users/{id}', function ($id) {

});

// DB Backup
Route::get('backup/download/{file_name}', 'BackUpController@download')->name('backup.download');
Route::get('backup/delete/{file_name}', 'BackUpController@delete')->name('backup.delete');
Route::resource('backup', 'BackUpController')->only(['index', 'create', 'store']);
Route::get('backup/delete/{file_name}', 'BackUpController@delete')->name('backup.delete');

Route::group(['middleware' => ['web', 'auth']], function () {

    Route::get('cheque-return-payments', 'ChequeReturnPaymentController@index')->name('cheque-return-payments');
    Route::get('cheque-return-payments/create', 'ChequeReturnPaymentController@create')->name('cheque-return-payments.create');
    Route::post('cheque-return-payments/store', 'ChequeReturnPaymentController@store')->name('cheque-return-payments.store');
    Route::get('cheque-return-payments/cheque-return-details/{id}', 'ChequeReturnPaymentController@collectReturnedCheques')->name('cheque-return-payments.edit');
    Route::get('cheque-return-payments/cheque-return-payment-details/{id}', 'ChequeReturnPaymentController@collectChequeReturnPayments')->name('cheque-return-payments.edit');
    Route::get('cheque-return-payments/edit/{id}', 'ChequeReturnPaymentController@edit')->name('cheque-return-payments.edit');
    Route::get('cheque-return-payments/show/{id}', 'ChequeReturnPaymentController@show')->name('cheque-return-payments.show');
    Route::put('cheque-return-payments/update/{id}', 'ChequeReturnPaymentController@update')->name('cheque-return-payments.update');
    Route::post('cheque-return-payments/delete/{id}', 'ChequeReturnPaymentController@destroy')->name('cheque-return-payments.delete');
});


Route::group(['middleware' => ['web', 'auth']], function () {
    Route::get('/invoice-return/create', 'InvoiceReturnCreationController@create')->name('invoice_return.create_new');
    Route::post('/invoice-return/store-new', 'InvoiceReturnCreationController@store')->name('invoice_return.store_new');
    Route::get('/customer-history/{customerId}', 'InvoiceReturnCreationController@getCustomerHistory')->name('customer.history');
    Route::post('/get-invoice-product-details', 'InvoiceReturnCreationController@getInvoiceProductDetails')->name('invoice_return.product_details');
    Route::post('/invoice-return/customer-outstanding', 'InvoiceReturnCreationController@getCustomerOutstandingInvoices')->name('invoice_return.customer_outstanding');
    Route::get('/invoice/{id}/products', 'InvoiceReturnCreationController@getInvoiceProducts')->name('invoice.products');

    // Add these to your web routes file
    Route::get('/payment/create/new', 'PaymentCreationController@create')->name('payment.create_new');
    Route::post('/payment/store/new', 'PaymentCreationController@store')->name('payment.store_new');
});