<div class="table-responsive">
    <table class="table table-striped table-bordered">
        <thead>
            <tr>
                <th>Invoice Date</th>
                <th>Invoice Code</th>
                <th>Payment Status</th>
                <th class="text-right">Invoice Total</th>
                <th class="text-right">Total Paid</th>
                <th class="text-right">Outstanding Amount</th>
            </tr>
        </thead>
        <tbody>
            @forelse($invoices as $invoice)
                <tr>
                    <td>{{ \Carbon\Carbon::parse($invoice->invoice_date)->format('Y-m-d') }}</td>
                    <td>{{ $invoice->invoice_code }}</td>
                    <td>
                        @if($invoice->balance_calculated <= 0)
                            <span class="label label-success">Completed</span>
                        @elseif($invoice->paid_amount_calculated > 0 && $invoice->balance_calculated > 0)
                            <span class="label label-primary">Partial</span>
                        @else
                            <span class="label label-danger">Pending</span>
                        @endif
                    </td>
                    <td class="text-right">{{ number_format($invoice->total, 2) }}</td>
                    <td class="text-right">{{ number_format($invoice->paid_amount_calculated, 2) }}</td>
                    <td class="text-right">{{ number_format($invoice->balance_calculated, 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="text-center">No invoice history found for this customer.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

{{-- Render pagination links that will be handled by our JS --}}
<div class="pagination-container d-flex justify-content-center">
    {{ $invoices->links() }}
</div>
