$(document).ready(function () {

    // $("#payment-details-panel-form").hide('slow');
    $("#payment_update_item_btn").hide('slow');

    // window.customer_outstanding_table = $('#customer_outstanding_table').DataTable({
    //     order: [[0, "desc"]],
    //     processing: true,
    //     serverSide: false,
    //     order: [[1, "desc"]],
    //     iDisplayLength: 15,
    //     data: [],
    //     bInfo: false,
    //     columns: [
    //         {
    //             data: 'id', name: 'id',
    //             'targets': 0,
    //             'checkboxes': {
    //                 'selectRow': true
    //             },
    //             'createdCell': function (td, cellData, rowData, row, col) {

    //                 // this.api().cell(td).checkboxes.select();
    //                 // test comment to check
    //                 $(td).on('change', ':checkbox', function() {
    //                     let amount = parseFloat($('#payment_amount').val());

    //                     if(isNaN(amount))
    //                     {
    //                         $(this).prop('checked', false)
    //                         $('#value_show').prop('hidden', true);

    //                         $.notify({
    //                             // options
    //                             message: "Please enter the amount before proceeding",
    //                         }, {
    //                             // settings
    //                             z_index: 10000000000,
    //                             type: "danger",
    //                         });

    //                     }
    //                     else{

    //                         let row = $(this).closest('tr');
    //                         let input = row.find('input.amount');
    //                         let total_string = rowData.total;

    //                         if ($(this).is(':checked')) {
    //                             input.prop('disabled', false);
    //                             displayTotal(total_string);
    //                         } else {
    //                             input.prop('disabled', true);
    //                             input.val('');
    //                             subtractTotal(total_string)
    //                         }
    //                         calculate();
    //                     }
    //                 });

    //             }
    //         },

    //         { data: 'invoice_code', name: 'invoice_code' },
    //         { data: 'invoice_date', name: 'invoice_date' },
    //         { data: 'total', name: 'total', className: 'dt-body-right' },
    //         { data: 'paid_amount', name: 'paid_amount', className: 'dt-body-right' },
    //         { data: 'balance', name: 'balance', className: 'dt-body-right' },
    //         { data: 'amount', name: 'amount',
    //             render:function(data, type, full, meta){
    //                 let id = full.id;
    //                 return "<input type='number' value='' class='amount " + id + "' disabled>";
    //             } },
    //         { data: 'payment_status', name: 'payment_status' },
    //         { data: 'status', name: 'status' },
    //         { data: 'created_by', name: 'created_by' },
    //         { data: 'action', name: 'action' },
    //     ]
    // });

    // Initialize the DataTable
    var customer_outstanding_table = $('#customer_outstanding_table').DataTable({
        processing: true,
        serverSide: false,
        iDisplayLength: 15,
        data: [],
        info: false, // Modern equivalent of bInfo: false
        order: [
            [1, "desc"]
        ], // Use a single 'order' property

        // Define the columns
        columns: [{
                data: null, // Data is null for the select-checkbox column
                defaultContent: '', // The cell is empty, CSS draws the checkbox
                className: 'select-checkbox',
                orderable: false,
                targets: 0
            },
            { data: 'invoice_code', name: 'invoice_code' },
            { data: 'invoice_date', name: 'invoice_date' },
            { data: 'total', name: 'total', className: 'dt-body-right' },
            { data: 'paid_amount', name: 'paid_amount', className: 'dt-body-right' },
            { data: 'balance', name: 'balance', className: 'dt-body-right' },
            {
                data: 'amount',
                name: 'amount',
                orderable: false,
                render: function(data, type, full, meta) {
                    let id = full.id;
                    return "<input type='number' value='' class='amount " + id + "' disabled>";
                }
            },
            { data: 'payment_status', name: 'payment_status' },
            { data: 'status', name: 'status' },
            { data: 'created_by', name: 'created_by' },
            { data: 'action', name: 'action', orderable: false },
        ],

        // Configure the official Select extension for multi-row selection
        select: {
            style: 'multi',
            selector: 'td:first-child'
        }
    });

    // --- Custom Logic for Row Selection ---

    // Event listener for when a row is SELECTED or DESELECTED
    customer_outstanding_table.on('select deselect', function(e, dt, type, indexes) {
        if (type === 'row') {
            handleRowSelection(dt, indexes);
        }
    });

    // Central function to handle the selection logic
    function handleRowSelection(dt, indexes) {
        let amount = parseFloat($('#payment_amount').val());

        // If no payment amount is entered, show an error and deselect the row
        if (isNaN(amount) && dt.rows({ selected: true }).count() > 0) {
            $.notify({
                message: "Please enter the amount before proceeding",
            }, {
                z_index: 10000000000,
                type: "danger",
            });
            // Deselect the row that was just selected to trigger this check
            dt.rows(indexes).deselect();
            return;
        }

        // Get data for the specific rows that changed state
        let changedRows = dt.rows(indexes);
        
        changedRows.nodes().each(function(rowNode, i) {
            let rowData = changedRows.data()[i];
            let input = $(rowNode).find('input.amount');
            let total_string = rowData.total;
            let isSelected = dt.row(rowNode).selected();

            if (isSelected) {
                input.prop('disabled', false);
                displayTotal(total_string); // Your custom function
            } else {
                input.prop('disabled', true);
                input.val('');
                subtractTotal(total_string); // Your custom function
            }
        });

        calculate(); // Your custom function
    }

    customer_outstanding_table.on('input','.amount', function(){

        let row = $(this).closest('tr');
        let input = row.find('input.amount');
        let input_value = parseFloat(row.find('input.amount').val());
        let balanceString = row.find('td:eq(5)').text();
        let balance = balanceString.replace(/[^0-9-]+/g,"").slice(0, -2);
        let main_payment = $('#payment_amount').val();
        // alert(balance)

        if(input_value > main_payment)
        {

            input.val('');
        }
        calculate();
    })

    $('#payment_amount').on('input', function(){
        calculate();
    })

    let display_total  = 0;

    function  displayTotal(total_string){
        let total = total_string.replace(/[^0-9-]+/g,"").slice(0, -2);

        let float_total = parseFloat(total);

        if(!isNaN(float_total) ){

             display_total +=  float_total;

               $('#invoice_value').prop('hidden', true);
               $('#invoice_value_show').prop('hidden', false);
               let formatted_display_total = display_total.toLocaleString('en-US', { minimumFractionDigits: 2 });
               $('#invoice_value_show').text(formatted_display_total);
            }

    }
    function  subtractTotal(total_string){
        let grand_total_string = $('#invoice_value_show').text();
        let total = total_string.replace(/[^0-9-]+/g,"").slice(0, -2);
        let grand_total = grand_total_string.replace(/[^0-9-]+/g,"").slice(0, -2);
        let float_grand_total = parseFloat(grand_total);
        let float_total = parseFloat(total);
        if(!isNaN(float_total) ){

             display_total =  float_grand_total - float_total;

               $('#invoice_value').prop('hidden', true);
               $('#invoice_value_show').prop('hidden', false);
               let formatted_display_total = display_total.toLocaleString('en-US', { minimumFractionDigits: 2 });
               $('#invoice_value_show').text(formatted_display_total);
            }

    }

    function calculate(){

        let sum = 0;
        let amount = parseFloat($('#payment_amount').val());
        // alert(amount)
        $('.amount').each(function(){
            let value = parseFloat($(this).val());
            sum += isNaN(value) ? 0 : value;
        })
        let sub_amount = amount - sum;

        if(sub_amount < 0)
        {
            sub_amount = 0;
        }

        let formatted_sub_amount = sub_amount.toLocaleString('en-US', { minimumFractionDigits: 2 });
        let formatted_sum = sum.toLocaleString('en-US', { minimumFractionDigits: 2 });
        $('#payment_value').text(formatted_sum)
        $('#remaining_value').text(formatted_sub_amount)
        if(sub_amount == 0)
        {
            $('#payment_add_item_btn').removeClass('disabled');
        }
        if (sub_amount !== 0){
            $('#payment_add_item_btn').addClass('disabled');
        }

    }

    $(document).on('click', '#edit_invoice', function (e) {
        e.preventDefault();
        var url = $(this).attr('href');
        window.open(url, '_blank');
    });

    $(document).on('click', '#new_payment', function (e) {
        e.preventDefault();
        var data = customer_outstanding_table.row($(this).parents('tr')).data();

        $("#invoice_id").val(data['id'])

        $("#payment_hedding").text('Payment Details : ' + data['invoice_code']).css({ color: 'red' });

        InvoicePaymentsTable.ajax.url(BASE + 'invoice/get_sales_payments/' + $('#invoice_id').val()).load();
    });

    window.InvoicePaymentsTable = $('#paymentsTable').DataTable({
        searching: false,
        paging: true,
        responsive: true,
        "ordering": true,
        order: [[0, "desc"]],
        "destroy": true,
        ajax: BASE + 'invoice/get_sales_payments/' + $('#invoice_id').val(),
        bInfo: false,
        iDisplayLength: 5,
        columns: [
            { data: 'id', name: 'id', 'bVisible': false },
            { data: 'payment_code', name: 'payment_code' },
            { data: 'invoice_code', name: 'invoice_code', 'bVisible': false },
            { data: 'payment_date', name: 'payment_date' },
            { data: 'payment_method', name: 'payment_method' },
            { data: 'cheque_date', name: 'cheque_date' },
            { data: 'cheque_bank', name: 'cheque_bank' },
            { data: 'payment_ref_no', name: 'payment_ref_no' },
            { data: 'payment_remarks', name: 'payment_remarks' },
            { data: 'payment_amount', name: 'payment_amount' },
            { data: 'cheque_status', name: 'cheque_status' },
            { data: 'rep_id', name: 'rep_id' },
            { data: 'actions', name: 'actions', 'bVisible': false }
        ]
    });


    $('#paymentsTable tbody').on('click', 'button.payment-edit-button', function (e) {

        var data = InvoicePaymentsTable.row($(this).parents('tr')).data();

        $('#record_payment_update_id').val(data['id']);
        $('#payment_date').val(data['payment_date']);
        $("#payment_method").val(data['payment_method']);
        $('#payment_ref_no').val(data['payment_ref_no']);
        $('#payment_remarks').val(data['payment_remarks']);
        $('#payment_amount').val(data['payment_amount']);
        $('#payment_add_item_btn').hide('slow');
        $('#payment_update_item_btn').show('slow');
        return false;

    });

    $('#paymentsTable tbody').on('click', 'button.payment-delete-button', function (e) {

        var data = InvoicePaymentsTable.row($(this).parents('tr')).data();

        var payment_details = $('#payment-details-panel-form :input').serialize();

        var params = {
            payment_details: payment_details,
            invoice_id: $('#invoice_id').val(),
            record_payment_id: data['id']
        };
        $.ajax({
            url: BASE + 'invoice/delete_payment',
            type: 'POST',
            dataType: 'JSON',
            data: $.param(params),
            success: function (response) {
                if (response.status == 'success') {

                    InvoicePaymentsTable.ajax.reload();

                    calPrice.run();
                    customer_outstanding_table.ajax.url(BASE + 'invoices_list/' + $('#customer_id_selected').val() + '/customer/payment').load();
                } else {
                    notification(response);
                    return false;
                }
            },
            error: function (xhr, ajaxOptions, thrownError) {

                notificationError(xhr, ajaxOptions, thrownError);
            }
        });
        return false;
    });

    $('#paymentsTable tbody').on('click', 'button.payment-print-button', function (e) {
        var $btn = $(this);
        $btn.button('loading');

        var data = InvoicePaymentsTable.row($(this).parents('tr')).data();

        var params = {
            invoice_id: $('#invoice_id').val(),
            record_payment_id: data['id']
        };

        $.ajax({
            url: BASE + 'invoice/print_payment',
            type: 'POST',
            dataType: 'JSON',
            data: $.param(params),
            success: function (response) {
                if (response.status == 'success') {
                    window.open(response.url);
                    $btn.button('reset');

                } else {
                    notification(response);
                    $btn.button('reset');
                    return false;
                }
            },
            error: function (xhr, ajaxOptions, thrownError) {

                notificationError(xhr, ajaxOptions, thrownError);
            }
        });

        return false;
    });

    $('#customer_outstanding_table tbody').on('click', 'input[type="checkbox"]', function () {
        let selected_invoices = getSelectedInvoices();
        if (selected_invoices.length) {
            getSelectedInvoiceBalance(selected_invoices);
        } else {
            $('#invoice_value').text('0.00');
            $('#selected_invoice_value').val(0);
        }
    })

    function getSelectedInvoices() {
        let invoices_selected = customer_outstanding_table.column(0).checkboxes.selected();

        let invoices_array = [];
        $.each(invoices_selected, function (index, rowId) {
            invoices_array.push({
                invoice_id: rowId,
                // amount: parseFloat($('.amount.' + rowId).val())
                amount: $('.amount.' + rowId).val()
            });
        });
        console.log(invoices_array)
        return invoices_array;
    }

    function getSelectedInvoiceBalance(selected_invoices) {
        let amount = $('#payment_amount').val();
        $.ajax({
            method: 'GET',
            url: BASE + 'payments/get/selected/invoice/balance',
            data: {
                selected_invoices: selected_invoices
            },
            success: function (response) {
                if(amount == isNaN || amount == '')
                {

                    $('#value_show').prop('hidden', true);
                }
                else{

                    $('#value_show').prop('hidden', false);
                    $('#invoice_value').text(response);
                    $('#selected_invoice_value').val(response);
                }
            }
        })
    }


    $("#payment_add_item_btn , #payment_update_item_btn").click(function (e) {
        if ($('#payment_amount').val() == '') {
            return false;
        }
        let sum = 0;

        $('.amount').each(function(){
            let value = parseFloat($(this).val());
            sum += isNaN(value) ? 0 : value;
        })
        let invoices_selected = getSelectedInvoices();
        if (!invoices_selected.length) {
            notification({ status: 'error', msg: 'Please select invoices to proceed.!' });
            return false;
        }
        let selected_invoice_value = $('#selected_invoice_value').val();
        let unformatted = selected_invoice_value.replace(/,/g, "");

        if (parseFloat($('#payment_amount').val()) > sum) {
            notification({ status: 'error', msg: 'Payment amount exceed selected invoice value.!' });
            return false;
        }
        // var invoices_selected = customer_outstanding_table.column(0).checkboxes.selected();
        // var invoices_array = [];

        // $.each(invoices_selected, function (index, rowId) {
        //     invoices_array.push(rowId);
        // });
        var payment_details = $('#payment_details_card_form :input').serialize();

        var params = {
            customer_id: $('#customer_id_selected').val(),
            payment_details: payment_details,
            record_payment_id: $('#record_payment_update_id').val(),
            invoices_selected: invoices_selected
        };
        $.ajax({
            url: BASE + 'payment/save_payment',
            type: 'POST',
            dataType: 'JSON',
            async: false,
            data: $.param(params),
            success: function (response) {
                notification(response);
                InvoicePaymentsTable.ajax.url(BASE + 'invoice/get_sales_payments/' + $('#customer_id_selected').val()+'/'+ 'customer').load();
                $('#record_payment_update_id').val('');
                $('#payment_update_item_btn').hide('slow');
                $('#payment_add_item_btn').show('slow');
                customer_outstanding_table.ajax.url(BASE + 'invoices_list/' + $('#customer_id_selected').val() + '/customer/payment').load();
                refreshCustomerDetails.run();
            },
            error: function (xhr, ajaxOptions, thrownError) {
                notificationError(xhr, ajaxOptions, thrownError);
            }
        });
        $('#payment_code').val('');
        $('#payment_ref_no').val('');
        $('#payment_remarks').val('');
        $('#payment_amount').val('');
    });

});
