/**
 * ===================================================================================
 * NEW HELPER FUNCTION
 * ===================================================================================
 * This function takes an array of invoice objects and builds the HTML rows for the
 * #PendingInvoiceTable. It replaces the DataTables initialization.
 */
function populatePendingInvoicesTable(invoices) {
    var tableBody = $('#PendingInvoiceTable tbody');
    tableBody.empty(); // Clear existing rows

    if (!invoices || invoices.length === 0) {
        var noDataRow = '<tr><td colspan="11" class="text-center">No outstanding invoices found for this customer.</td></tr>';
        tableBody.append(noDataRow);
        return;
    }

    $.each(invoices, function(index, invoice) {
        // Format numbers to 2 decimal places
        var total = parseFloat(invoice.total).toFixed(2);
        var paid_amount = parseFloat(invoice.paid_amount).toFixed(2);
        var balance = parseFloat(invoice.balance).toFixed(2);

        var newRow = `<tr>
            <td><input type="checkbox" class="invoice-checkbox" data-id="${invoice.id}" /></td>
            <td>${invoice.invoice_code}</td>
            <td>${invoice.invoice_date}</td>
            <td class="dt-body-right">${total}</td>
            <td class="dt-body-right">${paid_amount}</td>
            <td class="dt-body-right">${balance}</td>
            <td><input type='number' value='' class='cn-input ${invoice.id}' disabled></td>
            <td><span class="text-primary">Invoice</span></td>
            <td><span class="label label-danger">Pending</span></td>
            <td></td>
            <td></td>
        </tr>`;
        tableBody.append(newRow);
    });
}


$(document).ready(function () {

    document.getElementById("overlay").style.display = "block";

    function calculate(){
        let sum = 0;
        let sub_total_txt = $('#sub_total').text();
        let sub_total = parseFloat(sub_total_txt.replace('SUB TOTAL : ', ''));

        $('.cn-input').each(function(){
            let value = parseFloat($(this).val());
            sum += isNaN(value) ? 0 : value;
        })
        console.log(sub_total)
        if(sum == sub_total)
        { //chek
            console.log('equal');
            $('#invoice_return_save').removeClass('disabled')
            $('#invoice_return_save_and_new').removeClass('disabled')
        }
        if(sum < sub_total)
        {
            $('#invoice_return_save').addClass('disabled')
            $('#invoice_return_save_and_new').addClass('disabled')
        }
    }

    /**
     * ===================================================================================
     * NEW: Delegated Event Handlers for the new static table
     * ===================================================================================
     */
    // Handles clicks on the checkboxes in the pending invoices table
    $('#PendingInvoiceTable').on('change', 'tbody input.invoice-checkbox', function() {
        let sub_total_txt = $('#sub_total').text();
        let sub_total = parseFloat(sub_total_txt.replace('SUB TOTAL : ', ''));

        if(isNaN(sub_total) || sub_total <= 0){
            $(this).prop('checked', false);
            $.notify({
                message: "Please add products to the return before selecting an invoice to deduct from.",
            }, {
                z_index: 10000000000,
                type: "danger",
            });
            return; // Stop execution
        }

        let row = $(this).closest('tr');
        let input = row.find('input[type="number"]');
        input.prop('disabled', !$(this).is(':checked'));
        if (!$(this).is(':checked')) {
            input.val('');
        }

        calculate();
    });

    // Handles keyup on the credit note input fields
    $('#PendingInvoiceTable').on('input', '.cn-input', function(){
        let row = $(this).closest('tr');
        let input_value = parseFloat($(this).val());
        let balanceString = row.find('td:eq(5)').text();
        let balance = parseFloat(balanceString);
        let sub_total_txt = $('#sub_total').text();
        let sub_total = parseFloat(sub_total_txt.replace('SUB TOTAL : ', ''));

        if(input_value > balance || input_value > sub_total) {
            $(this).val('');
        }
        calculate();
    });


    $("#remarks").Editor();

    $('#update_item_row_btn').hide('slow');

    $('#create_new_customer_model').hide('slow');

    if ($('#invoice_return_id').val() != '') {

        $('#overlay').hide('slow');

        // $("#customer_filter :input").attr("disabled", true);
        calPrice.run();

    } else {
        $('#generate_invoice_return_pdf').hide('slow');

    }
    if ($('#invoice_return_status').val() == '' || $('#invoice_return_status').val() == 'D') {
        $('#invoice_return_update_btn').hide('slow');

    } else {
        $('#invoice_return_save_btn').hide('slow');
        $('#invoice_return_save_and_new_btn').hide('slow');
    }

    $("#invoice_return_discount_type").change(function (e) {
        calPrice.run();
    });

    $("#invoice_return_discount").keyup(function (e) {
        calPrice.run();
    });

    $("#refund").keyup(function (e) {
        calPrice.run();
    });

    $("#checked_vat").change(function (e) {
        calPrice.run();
    });

    $("#checked_nbt").change(function (e) {
        calPrice.run();
    });

    $("#generate_invoice_return_pdf").click(function (e) {

        if ($('#invoice_return_id').val() == '') {
            return false;
        }
        var $btn = $(this);
        $btn.button('loading');

        var params = {
            invoice_return_id: $('#invoice_return_id').val(),
        };

        $.ajax({
            url: BASE + 'invoice_return/generate_pdf',
            type: 'POST',
            dataType: 'JSON',
            data: $.param(params),
            success: function (response) {
                if (response.status == 'success') {
                    window.open(response.url);
                    $btn.button('reset');

                } else {
                    notification(response);
                    $btn.button('reset');
                    return false;
                }
            },
            error: function (xhr, ajaxOptions, thrownError) {

                notificationError(xhr, ajaxOptions, thrownError);
            }
        });
    });


    var selected_item = new Option('Please select Item', '', true, true);
    $('#invoice_return_item_product_code').append(selected_item).trigger('change.select2');

    var selected_category = new Option('Please select category', '', true, true);
    $('#invoice_return_item_category_code').append(selected_category).trigger('change.select2');



    window.createInvoiceReturnCode = {
        run: function () {
            var params = {
                customer_id: $("#customer_id").val(),
                invoice_id: $("#invoice_code_selected").val(),
                invoice_type: $('#invoice_type').val(),
            };
            var url;
            var method;
            if ($('#invoice_return_id').val() != '') {

                url = BASE + 'invoice_return/' + $('#invoice_return_id').val();
                method = 'PUT';
            } else {
                // alert('in');
                url = BASE + 'invoice_return';
                method = 'POST';
            }
            $.ajax({
                url: url,
                type: method,
                dataType: 'JSON',
                data: $.param(params),
                success: function (response) {
                    if (response.status == 'success') {
                        $('#overlay').hide('slow');
                        $("#invoice_return_id").val(response.invoice_return_details.id);
                        $("#ref_id").val(response.invoice_return_details.id);
                        $("#invoice_return_no").val(response.invoice_return_details.invoice_return_code);
                        $('#invoice_type').val(response.invoice_return_details.customer_type);


                        if (response.invoice_return_details.status == 'D')
                            $('#display_status').html('<span class="label label-danger">Draft</span>');
                        else if (response.invoice_return_details.status == 'A')
                            $('#display_status').html('<span class="label label-success">Completed</span>');
                    } else {
                        notification(response);
                    }
                },
                error: function (xhr, ajaxOptions, thrownError) {

                    notificationError(xhr, ajaxOptions, thrownError);
                }
            });
        }
    };

    $('#ProductsTable tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
        } else {
            ProductsTable.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }
    });




    $('#invoice_return_item_category_code').change(function (e) {

        var params = {
            category_id: $("#invoice_return_item_category_code").val(),
            invoice_id: $("#invoice_code_selected").val(),
        };
        var method = '';
        var url = '';
        url = BASE + 'get_invoice_products_by_category';
        method = 'POST';
        e.preventDefault();
        $.ajax({
            url: url,
            type: method,
            dataType: 'JSON',
            data: $.param(params),
            success: function (response) {
                if (response.status == 'success') {
                    $('#products_info_alert').hide('slow');
                    $("#invoice_return_item_product_code").find('option').remove();
                    $.each(response.products, function () {
                        $("#invoice_return_item_product_code").append($("<option />").val(this.id).text(this.item_code));
                    });
                    var selectedproduct = new Option('Please select product', '', true, true);
                    $('#invoice_return_item_product_code').append(selectedproduct).trigger('change.select2');
                    $('#invoice_return_item_product_code').select2('open');
                } else {
                    notification(response);
                }
            },
            error: function (xhr, ajaxOptions, thrownError) {

                notificationError(xhr, ajaxOptions, thrownError);
            }
        });
    });

    $('#item_stock_id').change(function (e) {
        $('#invoice_return_item_product_code').val($('#item_stock_id').val()).trigger('change.select2');


    });

    $('#invoice_return_item_product_code').change(function (e) {

        if ($("#invoice_return_item_product_code").val() == '') {
            $('#invoice_return_item_category_code').val('').trigger('change.select2');
            $('#description').val('').tooltip('show');
            $('#quantity').val('').tooltip('show');
            $('#unit_price').val('').tooltip('show');
            $('#discount').val('').tooltip('show');
            return false;
        }


        var params = {
            invoice_id: $("#invoice_code_selected").val(),
            product_id: $("#invoice_return_item_product_code").val()
        };

        var method = '';
        var url = '';


        url = BASE + 'get_invoice_return_product_details';
        method = 'POST';

        e.preventDefault();
        $.ajax({
            url: url,
            type: method,
            dataType: 'JSON',
            data: $.param(params),
            success: function (response) {

                if (response.status == 'success') {

                    $('#item_stock_id').val($("#invoice_return_item_product_code").val()).trigger('change.select2');
                    $('#description').val(response.invoice_return_product_detail.description).tooltip('show');
                    $('#quantity').val(1).tooltip('show').focus();
                    $('#unit_price').val(response.invoice_return_product_detail.unit_price).tooltip('show');
                    $('#discount').val(response.invoice_return_product_detail.discount).tooltip('show');
                    $('#discount_type').val(response.invoice_return_product_detail.discount_type);


                    var tooltip = " <a href='#' class='close' data-dismiss='alert' aria-label='close'> </a>" +
                        "<div class='row'>" +
                        "<div class='col-sm-12'>" +
                        "<strong>" + response.invoice_return_product_detail.product.item_code + "</strong>" +
                        "</div>" +
                        "<div class='col-sm-9'>No.of Items Purchased : " + response.invoice_return_product_detail.qty + "</div>" +
                        "</div>";

                    $('#products_info_alert').show('slow');
                    $('#products_info_alert').html(tooltip);

                    // $("#invoice_return_item_product_code").attr('title', tooltip).tooltip('fixTitle').tooltip('show');


                } else {
                    notification(response);

                }
            },
            error: function (xhr, ajaxOptions, thrownError) {

                notificationError(xhr, ajaxOptions, thrownError);
            }

        });

    });


    $('#quantity ,  #description, #unit_price, #product_discount').keypress(function (e) {
        var key = e.which;
        if (key == 13)  // the enter key code
        {
            $('#add_item_row_btn').click();
            return false;
        }
    });

    $('#item_stock_id').change(function (e) {
        $('#invoice_return_item_product_code').val($(this).val());
        $('#invoice_return_item_product_code').change();
    });

// adding and updating invoice products

var grand_total = 0;
var rowCounter = 0;

var disable_check = 0;

    $(document).on('click', '#add_item_row_btn', function(){

        var stock_id = $('#item_stock_id option:selected').text();
        var stock_id_value = $('#item_stock_id option:selected').val();
        var item = $('#invoice_return_item_product_code option:selected').text();
        var item_value = $('#invoice_return_item_product_code option:selected').val();
        var description = $('#description').val();
        var qty = $('#quantity').val();
        var unit_price = $('#unit_price').val();
        var discount_input = $('#product_discount').val();
        var discount_type = $('#product_discount_type option:selected').val();
        var discount_type_text = '';
        var total = 0;
        var sub_total = 0;
        var discount = 0;
        var stock_status = 'PENDING'
        // returns 2 types of output for percentage P and for amount A
        var is_discarded = $('#checked_discarded').prop('checked');
        if(is_discarded)
        {
            stock_status = 'DISCARDED'
        }
        if(discount_type == 'P')
        {
            discount_type_text = 'PERCENTAGE';
            total = qty * unit_price;
            discount = total * discount_input/100;
            sub_total = total - discount;
        }
        if(discount_type == 'A')
        {
            discount_type_text = 'AMOUNT';
            total = qty * unit_price;
            discount = discount_input;
            sub_total = total - discount;

        }
        rowCounter++;
        // item, description, qty, unit_price, discount, discount_type_text, sub_total, stock_status
        var newRow = $('<tr>');
        newRow.append('<td hidden>'+stock_id_value+'</td>');
        newRow.append('<td hidden>'+stock_id+'</td>');
        newRow.append('<td>'+item+'</td>');
        newRow.append('<td>'+description+'</td>');
        newRow.append('<td>'+qty+'</td>');
        newRow.append('<td>'+unit_price+'</td>');
        newRow.append('<td>'+discount+'</td>');
        newRow.append('<td>'+discount_type_text+'</td>');
        newRow.append('<td>'+sub_total+'</td>');
        newRow.append('<td>'+stock_status+'</td>');
        newRow.append("<td> <button class='btn btn-warning btn-sm icon-edit'><i class='fa fa-pencil'></i></button> <button class='btn btn-danger btn-sm icon-circle-cross icon-delete'><i class='fa fa-remove'></i></button> </td>");
        newRow.append('<td hidden>'+item_value+'</td>');
        newRow.append('<td hidden>'+rowCounter+'</td>');

        $('#ProductTable tbody').append(newRow);

        subTotalCalculate(sub_total);
    })

    function subTotalCalculate(sub_total){

        grand_total += sub_total;
        $('.sub_total').text('SUB TOTAL : ' + grand_total);
        var formattedTotal = grand_total.toFixed(2);
        $('.sub_total').val(formattedTotal);
        $('#total').val(formattedTotal);
        // disable_check = 1;
        // disableCheck(disable_check)

    }

    // this function clears the inputs after addition and update

    function disableCheck(disable_check)
    {
        if(disable_check == 1)
        {
             $('#item_stock_id').val('').trigger('change.select2');
            $('#invoice_return_item_product_code').val('').trigger('change.select2');
            $('#description').val('');
            $('#quantity').val('');
            $('#unit_price').val('');
            $('#product_discount').val('');
            $('#product_discount_type').val('P').trigger('change');
            $('#checked_discarded').prop('checked', false);

            disable_check = 0;

        }
    }


    $(document).on('click','#update_item_btn', function(e){

        var stock_id = $('#item_stock_id option:selected').text();
        var stock_id_value = $('#item_stock_id option:selected').val();
        var item = $('#invoice_return_item_product_code option:selected').text();
        var item_value = $('#invoice_return_item_product_code option:selected').val();
        var description = $('#description').val();
        var qty = $('#quantity').val();
        var unit_price = $('#unit_price').val();
        var discount_input = $('#product_discount').val();
        var discount_type = $('#product_discount_type option:selected').val();
        var discount_type_text = '';
        var total = 0;
        var sub_total = 0;
        var discount = 0;
        var stock_status = 'PENDING'
        // returns 2 types of output for percentage P and for amount A
        var is_discarded = $('#checked_discarded').prop('checked');
        if(is_discarded)
        {
            stock_status = 'DISCARDED'
        }
        if(discount_type == 'P')
        {
            discount_type_text = 'PERCENTAGE';
            total = qty * unit_price;
            discount = total * discount_input/100;
            sub_total = total - discount;
        }
        if(discount_type == 'A')
        {
            discount_type_text = 'AMOUNT';
            total = qty * unit_price;
            discount = discount_input;
            sub_total = total - discount;

        }

        // get the unique row number to update

        var row_number = $('.row_count').val();
        var rowToUpdate = $('#ProductTable tbody').find('tr').filter(function () {
            return $(this).find('td:eq(12)').text() == row_number;
          });

          rowToUpdate.find('td:eq(0)').text(stock_id_value);
          rowToUpdate.find('td:eq(1)').text(stock_id);
          rowToUpdate.find('td:eq(2)').text(item);
          rowToUpdate.find('td:eq(3)').text(description);
          rowToUpdate.find('td:eq(4)').text(qty);
          rowToUpdate.find('td:eq(5)').text(unit_price);
          rowToUpdate.find('td:eq(6)').text(discount);
          rowToUpdate.find('td:eq(7)').text(discount_type_text);
          rowToUpdate.find('td:eq(8)').text(sub_total);
          rowToUpdate.find('td:eq(9)').text(stock_status);
          rowToUpdate.find('td:eq(11)').text(item_value);

          subTotalUpdate(sub_total)
        //   disable_check = 1;
        //   disableCheck(disable_check)
    })


    /**
     * ===================================================================================
     * MODIFIED: Saving logic now reads from the static table
     * ===================================================================================
     * The logic for saving data was already using standard jQuery selectors, so it
     * requires minimal changes. We just need to ensure the selectors are correct
     * for the new checkbox and input structure.
     */
    $(document).on('click','#invoice_return_save, #invoice_return_save_and_new', function(){
        var isNew = $(this).attr('id') === 'invoice_return_save_and_new';

        // INVOICE RETURN DATA
        var invoice_id = $('#invoice_code_selected option:selected').val();
        var customer_id = $('#customer_id_selected option:selected').val();
        var invoice_return_sub_total = $('#invoice_return_sub_total').val();
        var invoice_return_remarks = $('#remarks').Editor("getText");
        var invoice_return_total = $('#total').val();
        var invoice_return_discount = $('#invoice_return_discount').val();
        var invoice_return_discount_type = $('#invoice_return_discount_type').val();

        // Deduction data collection
        var deduct_data_array = [];
        $('#PendingInvoiceTable tbody tr').each(function(){
           var checkbox = $(this).find('td:eq(0) .invoice-checkbox'); // Updated selector

           if(checkbox.is(':checked')){
               var invoice_code = $(this).find('td:eq(1)').text();
               var credit_note_balance = $(this).find('input.cn-input').val();

               if (credit_note_balance && parseFloat(credit_note_balance) > 0) {
                   var deduct_row = [invoice_code, credit_note_balance];
                   deduct_data_array.push(deduct_row);
               }
           }
        });

        // INVOICE RETURN PRODUCTS ARRAY (This logic is unchanged)
        var row_data_array = [];
        $('#ProductTable tbody tr').each(function(){
            var row_data = {
                product_id : $(this).find('td:eq(11)').text(),
                description : $(this).find('td:eq(3)').text(),
                qty : $(this).find('td:eq(4)').text(),
                unit_price : $(this).find('td:eq(5)').text(),
                discount : $(this).find('td:eq(6)').text(),
                discount_type : $(this).find('td:eq(7)').text(),
                sub_total : $(this).find('td:eq(8)').text(),
                stock_status : $(this).find('td:eq(9)').text(),
            };
            row_data_array.push(row_data);
        });

        $.ajax({
            url: BASE + 'invoice_return/create',
            method: 'POST',
            data:{
                invoice_return_product_data_array : row_data_array,
                invoice_return_sub_total : invoice_return_sub_total,
                invoice_return_total : invoice_return_total,
                invoice_return_remarks : invoice_return_remarks,
                invoice_id : invoice_id,
                customer_id : customer_id,
                invoice_return_discount :invoice_return_discount,
                invoice_return_discount_type : invoice_return_discount_type,
                deduct_data_array : deduct_data_array
            },
            success: function(response){
                notification(response);
                if (response.status === 'success') {
                    if (isNew) {
                        location.reload();
                    } else {
                        window.location.href = BASE + "invoice_return";
                    }
                }
            },
            error: function(xhr, ajaxOptions, thrownError){
                notificationError(xhr, ajaxOptions, thrownError);
            }
        });
    });


    function subTotalUpdate(sub_total){
        var sub_value = $('.update_amount').val();
        var updated_value = grand_total - sub_value;
        grand_total = updated_value + sub_total;
        $('.sub_total').text('SUB TOTAL : ' + grand_total);
        var formattedTotal = grand_total.toFixed(2);
        $('.sub_total').val(formattedTotal);
        $('#total').val(formattedTotal);

        // disable_check = 1;
        // disableCheck(disable_check)
        $('#add_item_row_btn').prop('hidden',false);
        $('#update_item_btn').prop('hidden',true);
    }

    $('#ProductTable tbody').on('click', 'button.icon-delete', function (e) {
        var row = $(this).closest('tr');
        var deduct_sub_total = row.find('td:eq(8)').text();
        subTotalSubtract(deduct_sub_total)
        row.remove();
        $('.row_count').val('');
        $('.update_amount').val('');
    });

    function subTotalSubtract(deduct_sub_total){

        var current_sub_total_text = $('.sub_total').text();
        var current_sub_total = parseFloat(current_sub_total_text.replace('SUB TOTAL : ', ''));

        grand_total -= deduct_sub_total;
        $('.sub_total').text('SUB TOTAL : ' + grand_total);


    }


    $('#ProductTable tbody').on('click', 'button.icon-edit', function (e) {

        // alert('ok')
        var row = $(this).closest('tr');
        var stock_id = row.find('td:eq(0)').text();
        var item = row.find('td:eq(11)').text();
        var description = row.find('td:eq(3)').text();
        var qty = row.find('td:eq(4)').text();
        var unit_price = row.find('td:eq(5)').text();
        var discount = row.find('td:eq(6)').text();
        var discount_type = row.find('td:eq(7)').text();
        var stock_status = row.find('td:eq(9)').text();
        var row_count = row.find('td:eq(12)').text();
        var sub_total = row.find('td:eq(8)').text();

        $('#item_stock_id').val(stock_id).trigger('change.select2');
        $('#invoice_return_item_product_code').val(item).trigger('change.select2');
        $('#description').val(description);
        $('#quantity').val(qty);
        $('#unit_price').val(unit_price);
        $('#product_discount').val(discount);
        $('.row_count').val(row_count)
        if(discount_type == 'PERCENTAGE')
        {
            $('#product_discount_type').val('P').trigger('change');
        }
        else
        {
            $('#product_discount_type').val('A').trigger('change');
        }
        if(stock_status == 'DISCARDED')
        {
            $('#checked_discarded').prop('checked', true);
        }
        $('#add_item_row_btn').prop('hidden',true);
        $('#update_item_btn').prop('hidden',false);

        // update the input with current sub_total
        $('.update_amount').val(sub_total)

    })






    $('#ProductsTable tbody').on('click', 'button.icon-edit', function (e) {

        var data = ProductsTable.row($(this).parents('tr')).data();

        $('#record_product_update_id').val(data['id']);

        $("#invoice_return_item_category_code").val(data['product'].category_id).trigger('change.select2');
        $("#invoice_return_item_product_code").val(data['product'].id).trigger('change.select2');
        $('#description').val(data['description']);
        $('#quantity').val(data['quantity']);
        $('#unit_price').val(data['unit_price']);
        $('#product_discount').val(data['discount']);
        $("#store_location").val(data['store_id']).trigger('change.select2');
        $('#product_discount_type').val(data['discount_type']);
        if (data['stock_status'] == 'Discarded')
            $('#checked_discarded').prop('checked', true);
        $('#add_item_row_btn').hide('slow');
        $('#update_item_row_btn').show('slow');
        return false;

    });


    $('#ProductsTable tbody').on('click', 'button.icon-circle-cross', function () {
        var data = ProductsTable.row($(this).parents('tr')).data();

        var invoice_price_details = $('#price_panel :input').serialize();

        var params = {
            invoice_price_details: invoice_price_details,
            record_id: data['id'],
        };

        $.ajax({
            url: BASE + 'invoice_return/delete_invoice_return_product',
            type: 'POST',
            dataType: 'JSON',
            data: $.param(params),
            success: function (response) {
                if (response.status == 'success') {
                    ProductsTable.ajax.reload();
                    // calPrice.run();
                } else {
                    notification(response);
                    return false;
                }
            },
            error: function (xhr, ajaxOptions, thrownError) {

                notificationError(xhr, ajaxOptions, thrownError);
            }
        });

        return false;
    });


    updateInvoiceReturn = {
        run: function (status, btn) {

            var return_from_invoices_selected = PendingInvoiceTable.column(0).checkboxes.selected();

            var return_from_invoices_array = [];

            $.each(return_from_invoices_selected, function (index, rowId) {
                return_from_invoices_array.push({
                    invoice_id:rowId,
                    credit_note_balance : parseFloat($('.cn-input.'+rowId).val()),
                });
                // return_from_invoices_array.push(rowId);
            });
            console.log(return_from_invoices_array);

            // if (return_from_invoices_array.length > 1) {
            //     alert('You can not select more than one invoice');
            //     return false;
            // }

            var params = {
                status: status,
                remarks: $('#remarks').Editor("getText"),
                customer_id: $('#customer_id').val(),
                invoice_type: $('#invoice_type').val(),
                invoice_id: $('#invoice_code_selected').val(),
                invoice_return_date_created: $('#invoice_return_date_created').val(),
                return_from_invoices_array: return_from_invoices_array

            };

            $.ajax({
                url: BASE + 'invoice_return/' + $('#invoice_return_id').val(),
                type: 'PUT',
                async: false,
                dataType: 'JSON',
                data: $.param(params),
                success: function (response) {
                    notification(response);
                    if (response.status == 'success') {
                        ProductsTable.ajax.reload();
                        if (btn == 'invoice_return_save_and_new_btn') {
                            setTimeout(
                                function () {
                                    window.location.href = BASE + 'invoice_return/create';
                                }, 1000);
                        }
                        else if (btn == 'invoice_return_update_btn') {
                            setTimeout(
                                function () {
                                    window.location.href = BASE + 'invoice_return';
                                }, 1000);
                        }
                        else {
                            $('#settle_outstanding_invoices').show('slow');
                            if (status == 'A') {
                                $('#product-details-panel').hide('slow');
                                $('#customer_detail_panel :input').prop("disabled", true);
                                $('#price_panel :input').prop("disabled", true);
                                $('#invoice_return_details_panel :input').prop("disabled", true);
                                $('#invoice_return_update_btn').show('slow');
                                $('#invoice_return_save_btn').hide('slow');
                                $('#invoice_return_save_and_new_btn').hide('slow');
                                $('#display_status').html('<span class="label label-success">Completed</span>');
                                $("#invoice_return_no").val(response.invoice_return_details.invoice_return_code);
                                $('#invoice_type').val(response.invoice_return_details.customer_type);
                            }
                        }
                    } else {
                        return false;
                    }
                },
                error: function (xhr, ajaxOptions, thrownError) {

                    notificationError(xhr, ajaxOptions, thrownError);
                }
            });

            return false;

        }
    };

    $("#settle_outstanding_invoices").hide();

    $("#settle_outstanding_invoices").click(function (e) {

        if ($('#customer_id_selected').val() != '') {
            var win = window.open(BASE + 'create/new?customer_id=' + $('#customer_id_selected').val(), '_blank');
            if (win) {
                //Browser has allowed it to be opened
                win.focus();
            } else {
                //Browser has blocked it
                alert('Please allow popups for this website');
            }
        }

    });


    $("#invoice_return_save_btn, #invoice_return_save_and_new_btn ,#invoice_return_update_btn").click(function (e) {

        var btn = $(this).attr("id");

        var valid = $("#invoice_return_form").validationEngine('validate');
        if (valid != true) {
            return false;
        }
        if ($("#invoice_id").val() == '') {
            return false;
        }

        if (btn == 'invoice_return_update_btn') {

            updateInvoiceReturn.run('A', btn);
            return false;
        }
        var invoice_return_save_confirm = $.confirm({
            title: 'Save Invoice Return',
            type: 'blue',
            buttons: {
                draft: {
                    text: 'Draft',
                    btnClass: 'btn-default',
                    action: function () {

                        updateInvoiceReturn.run('D', btn);
                    }
                },
                complete: {
                    text: 'Complete',
                    keys: ['shift', 'alt'],
                    btnClass: 'btn-primary',
                    action: function () {
                        updateInvoiceReturn.run('A', btn);

                    }
                },

            }
        });
        return false;


    });


    window.ProductsTable = $('#ProductsTable').DataTable({
        searching: false,
        paging: false,
        responsive: true,
        "ordering": false,
        "destroy": true,
        ajax: BASE + 'invoice_return/get_invoice_return_products/' + $('#invoice_return_id').val(),
        bInfo: false,
        iDisplayLength: 5,
        columns: [
            { data: 'id', name: 'id', 'bVisible': false },
            { data: 'item', name: 'item' },
            { data: 'description', name: 'description' },
            { data: 'quantity', name: 'quantity', className: 'dt-body-right' },
            { data: 'unit_price', name: 'unit_price', className: 'dt-body-right' },
            { data: 'discount', name: 'discount', className: 'dt-body-right' },
            { data: 'discount_type_show', name: 'discount_type_show' },
            { data: 'discount_type', name: 'discount_type', 'bVisible': false },
            { data: 'sub_total', name: 'sub_total',className: 'dt-body-right' },
            { data: 'stock_status', name: 'stock_status' },
            {
                data: 'actions',
                name: 'actions',
            }
        ]
    });

});
