<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>GOODS RETURN SUMMARY REPORT CUSTOMER WISE</H2>
    <p>Filtered by:</p>
    <p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
    {{-- <p>Customer : {{ $customer ?? '' }} | Area : {{ $city ?? '' }}</p> --}}
    <p>Rep : {{ $rep ?? '' }} | Item : {{ $item ?? '' }}</p>
    <table>
        <tr>
            <th style="width: 10%;">Date</th>
            <th style="width: 10%;">Code</th>
            <th style="width: 35%;">Customer</th>
            <th style="width: 35%;">Item Description</th>
            <th style="width: 12%; ">Quantity</th>
        </tr>
    </table>
    <?php
    $total_qty = 0;
    ?>
    @foreach ($customers as $customer)
        <table>
            <tr>
                @php
                    $total_qty += $customer['total_qty']
                @endphp
                <td style="width: 10%;">{{$customer['invoice_return_date']}}</td>
                <td style="width: 10%;">{{$customer['invoice_return_code']}}</td>
                <td style="width: 35%;">{{$customer['customer_name']}}</td>
                <td style="width: 35%;">{{$customer['product_stock_id']}} - {{$customer['product_description']}} - {{$customer['product_item_code']}}</td>
                <td style="width: 12%; text-align: right;">{{$customer['total_qty']}}</td>
            </tr>
        </table>
    @endforeach


    <table>
        <tr>
            <th style="width: 90%; text-align: center;" colspan="4">Total QTY</th>
            <th style="width: 12%; text-align: right;">{{ $total_qty }}</th>
        </tr>
    </table>
</body>

</html>
