<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .double_hr {
            overflow: visible;
            /* For IE */
            padding: 0;
            border: none;
            border-top: medium double #333;
            color: #333;
            text-align: center;
            margin-bottom: 10px;
        }

        hr {
            margin: 3px;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
        p.date{
            position: absolute;
            top: 0;
            right: 0;
        }
    </style>

</head>

<body>
{!! getLogo() !!}
    {{-- @php
        $currentDate = \Carbon\Carbon::now()->format('Y-m-d');
    @endphp
    <p class="date">{{$currentDate}}</p> --}}
<H2>SALES SUMMARY REPORT INVOICE WISE</H2>
<p>Filtered by:</p>
<p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
<p>Rep : {{ $rep ?? '' }}</p>
<table>
    <tr>

        <th style="width: 33%; " >Order #</th>
        <th style="width: 33%; ">Date</th>
        <th style="width: 33%; text-align: right;" >Total</th>
        {{-- <th style="width: 19%; text-align: right;">Credit Note</th> --}}
        {{-- <th style="width: 19%; text-align: right;">Paid</th> --}}
        {{-- <th style="width: 19%; text-align: right;">Sale</th> --}}
        {{-- <th style="width: 14%; text-align: right;">No of Days</th> --}}
    </tr>
</table>
@php
    $full_total = 0;
    $full_returned = 0;
    // $full_paid = 0;
    $full_balance = 0;
@endphp
<table>
    @php
        $total_invoice_amount = 0;
        $total_returned_amount = 0;
        // $total_paid_amount = 0;
        $total_balance = 0;
    @endphp
    @foreach ($invoices as $invoice)
        @php
            $full_total += $invoice->total;
            $full_returned += \App\Utils\CommonUtil::calculateTotalReturnAmountInvoice($invoice->id);
            $full_balance += $invoice->total - $full_returned;

            $total_invoice_amount += $invoice->total;
            $total_returned_amount += \App\Utils\CommonUtil::calculateTotalReturnAmountInvoice($invoice->id);;
            $total_balance += $invoice->total - $total_returned_amount;

            $outstanding = \App\Utils\CommonUtil::calculateInvoiceOutstanding($invoice->id);

        @endphp
        @if($outstanding > 0 || $outstanding < 0)
            <tr>

                <td style="width: 25%;">{{ $invoice->invoice_code }}</td>
                <td style="width: 25%;">
                    @php
                        $count_days = \Carbon\Carbon::parse($invoice->invoice_date)->diffInDays(\Carbon\Carbon::now(), false);
                    @endphp
                    {{ $invoice->invoice_date }}
                </td>
                <td style="width: 25%; text-align: right;">
                    {{ \App\Http\Helper::formatPrice($invoice->total) }}
                </td>
                {{-- <td style="width: 19%; text-align: right;">
                    {{ \App\Http\Helper::formatPrice(\App\Utils\CommonUtil::calculateTotalReturnAmountInvoice($invoice->id)) }}
                </td>

                <td style="width: 19%; text-align: right;">
                    {{ \App\Http\Helper::formatPrice($invoice->total - \App\Utils\CommonUtil::calculateTotalReturnAmountInvoice($invoice->id)) }}
                </td>
                <td style="width: 12%; text-align: center;">
                    @php
                        $count_days = \Carbon\Carbon::parse($invoice->invoice_date)->diffInDays(\Carbon\Carbon::now(), false);
                    @endphp
                    ({{ $count_days }})
                </td> --}}
            </tr>
        @endif
    @endforeach
    <tr>
        <th style="width: 24%;" colspan="2">Total</th>
        <th style="width: 19%; text-align: right;">
            {{ \App\Http\Helper::formatPrice($total_invoice_amount) }}
        </th>
        {{-- <th style="width: 19%; text-align: right;">
            {{ \App\Http\Helper::formatPrice($total_returned_amount) }}
        </th> --}}
        {{-- <th style="width: 19%; text-align: right;">{{ \App\Http\Helper::formatPrice($total_paid_amount) }}
            </th> --}}
        {{-- <th style="width: 19%; text-align: right;">{{ \App\Http\Helper::formatPrice($total_balance) }}
        </th> --}}
        {{-- <th style="width: 19%; text-align: right;">&nbsp;
        </th> --}}
    </tr>
</table>
<hr class="double_hr">
<table>
    <tr>
        <th style="width: 67%;">Full Total</th>
        <th style="width: 33%; text-align: right;">{{ \App\Http\Helper::formatPrice($full_total) }}
        </th>
        {{-- <th style="width: 25%; text-align: right;">{{ \App\Http\Helper::formatPrice($full_returned) }}
        </th> --}}
        {{-- <th style="width: 19%; text-align: right;">{{ \App\Http\Helper::formatPrice($full_paid) }}
        </th> --}}
        {{-- <th style="width: 25%; text-align: right;">{{ \App\Http\Helper::formatPrice($full_balance) }}
        </th> --}}

    </tr>
</table>
</body>

</html>
