@extends('layouts.app')

@section('content')
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>Daily Sales Summary Report</h4>
                    </div>
                </div>
            </div>
        </div>
        <!-- Top bar ends -->
        <!-- Main container starts -->
        <div class="main-container">
            <!-- Row starts -->
            <div class="row gutter">
                <div class="card">
                    <div class="card-body">
                        <form class="" action="#" id="report-filter">
                            <input type="hidden" name="report_type" value="daily">
                            <div class="row">
                                <div class="col-sm-3">
                                    <label>Invoice Date</label>
                                    @include('xreports::common.report_date_range_select')
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label>CUSTOMER REP</label>
                                        <div class="form-group">
                                            {{-- {{ Form::select('rep_id', \Pramix\XUser\Models\User::pluck('username', 'id'), '', ['class' => 'form-control select2', 'placeholder' => 'Select Rep', 'id' => 'rep_id']) }} --}}
                                            <select name="rep_id" id="rep_id" class="form-control select2">
                                                <option value="">Select Rep</option>
                                                @foreach($roles as $role)

                                                <option value="{{ $role->id }}">{{ $role->username }} - {{$role ->fname }}</option>

                                            @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label>SALES REP</label>
                                        <div class="form-group">
                                            {{-- {{ Form::select('rep_id', \Pramix\XUser\Models\User::pluck('username', 'id'), '', ['class' => 'form-control select2', 'placeholder' => 'Select Rep', 'id' => 'rep_id']) }} --}}
                                            <select name="invoice_rep" id="invoice_rep" class="form-control select2">
                                                <option value="">Select Rep</option>
                                                @foreach($roles as $role)

                                                <option value="{{ $role->id }}">{{ $role->username }} - {{$role ->fname }}</option>

                                            @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <br>
                                    <button id="generate_report_btn" class="btn btn-primary">
                                        <span id="spinner" hidden class="spinner-border spinner-border-sm" role="status"
                                            aria-hidden="true"></span> Generate
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- Row ends -->
        </div>
        <!-- Main container ends -->
    </div>
    <!-- Dashboard wrapper ends -->
@endsection

@section('include_js')
    <script src="{{ asset('/pramix/js/reports_js.js') }}"></script>
@endsection

@section('custom_script')
    <script>
        $(document).ready(function() {
            $("#generate_report_btn").click(function(e) {
                $('#generate_report_btn').prop('disabled', true);
                $('#spinner').prop('hidden', false);
                var params = {
                    filter_details: $('#report-filter :input').serialize(),
                };
                e.preventDefault();
                $.ajax({
                    url: "{{ route('reports.generate_daily_sales_summary_report') }}",
                    type: 'POST',
                    dataType: 'JSON',
                    data: $.param(params),
                    success: function(response) {
                        $('#generate_report_btn').prop('disabled', false);
                        $('#spinner').prop('hidden', true);
                        var url = response.report_url
                        window.open(url, '_blank');
                    },
                });
                e.preventDefault();
                return false;
            });
        });
    </script>
@endsection
