<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>DAILY GOODS RETURN SUMMARY REPORT</H2>
    <p>Filtered by:</p>
    <p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
    <p>Rep : {{ $rep ?? '' }}</p>
    <table>
        <tr>
            <th>#</th>
            <th>Date</th>
            <th style="text-align: right;">Total</th>

        </tr>
        <?php
        $grand_total = 0;
        ?>
        @foreach ($invoice_returns as $invoice_return)
            <tr>
                @php

                $invoice_return_total =  $invoice_return['credit_notes_total'] + $invoice_return['discount_total'];
                $grand_total += $invoice_return_total;

                @endphp
                <td>{{ $loop->iteration }}</td>
                <td>{{ $invoice_return['date'] }}</td>
                <td style="text-align: right;">{{\App\Http\Helper::formatPrice($invoice_return_total)}}</td>

        @endforeach
        <tr>
            <th style="text-align: center;" colspan="2">Total</th>
            <th style="text-align: right;">{{ \App\Http\Helper::formatPrice($grand_total) }}</th>
        </tr>
    </table>
</body>

</html>
