<!DOCTYPE html>
<html lang="en">

<head>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css"
        integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        .double_hr {
            overflow: visible;
            padding: 0;
            border: none;
            border-top: medium double #333;
            color: #333;
            text-align: center;
            margin-bottom: 10px;
        }

        hr {
            margin: 3px;
        }

        p.date {
            position: absolute;
            top: 0;
            right: 0;
        }

        table {
            width: 100%;
            margin-bottom: 20px;
        }

        table th,
        table td {
            padding: 5px;
            text-align: center;
        }

        table th {
            background-color: #f2f2f2;
        }

        table td.text-right {
            text-align: right;
        }

        table td.text-center {
            text-align: center;
        }
    </style>
</head>

<body>

    <div class="main-container">
        @php
            $currentDate = \Carbon\Carbon::now()->format('Y-m-d');
        @endphp
        <p class="date">{{ $currentDate }}</p>
        <div class="row">
            <div class="col-xs-6">
                <p>{{ getConfigArrayValueByKey('COMPANY_DETAILS', 'company_name') }}</p>
                <p>CHEQUE RETURN OUTSTANDING REPORT</p>
            </div>
        </div>

        @foreach ($customers->sortBy(function ($customer) {
            return $customer->company_name ?? $customer->business_name ?? '';
        }) as $customer)
            @php
                $returned_cheques = Pramix\XPayment\Models\ChequeModel::where('customer_id', $customer->customer_id)
                    ->where('status', 2)
                    ->orderBy('cheque_return_date')
                    ->get();
                
                $total_cheque_return_amount = 0;
                $total_credit = 0;
                $total_balance = 0;
                $has_non_zero_balance = false;
            @endphp
        
            @foreach ($returned_cheques as $returned_cheque)
                @php
                    $credit = \App\ChequeReturnPaymentHasCheque::where('cheque_id', $returned_cheque->id)
                        ->sum('payment_amount');
                    $balance = $returned_cheque->payment_amount - $credit;

                    // Skip if balance is zero or negative
                    if ($balance == 0) {
                        continue;
                    }

                    $has_non_zero_balance = true;
                    $total_cheque_return_amount += $returned_cheque->payment_amount;
                    $total_credit += $credit;
                    $total_balance += $balance;
                @endphp
            @endforeach
        
            @if ($has_non_zero_balance)
                <strong>Debator :</strong> {{ $customer->company_name ?? '' }} {{ $customer->business_name ?? '' }}
                | <strong>Rep :</strong> {{ $customer->rep_fname ?? '' }} {{ $customer->rep_lname ?? '' }} <br>
        
                @if (isset($customer->mobile) && $customer->mobile != '')
                    {{ $customer->mobile ?? '' }}
                @endif
                <hr>
        
                <table>
                    <thead>
                        <tr>
                            <th style="width: 12%;">Cheque #</th>
                            <th style="width: 12%;">Cheque Return Ref No</th>
                            <th style="width: 12%;">Cheque Return Date</th>
                            <th style="width: 20%;">Description</th>
                            <th style="width: 14%;" class="text-right">Cheque Return Amount</th>
                            <th style="width: 14%;" class="text-right">Credit</th>
                            <th style="width: 14%;" class="text-right">Balance</th>
                            <th style="width: 12%;" class="text-center">No of Days</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($returned_cheques as $returned_cheque)
                            @php
                                $credit = \App\ChequeReturnPaymentHasCheque::where('cheque_id', $returned_cheque->id)
                                    ->sum('payment_amount');
                                $balance = $returned_cheque->payment_amount - $credit;

                                // Skip cheques with zero or negative balance
                                if ($balance == 0) {
                                    continue;
                                }
                            @endphp
                            <tr>
                                <td>{{ $returned_cheque->payment_ref_no ?? 'N/A' }}</td>
                                <td>{{ $returned_cheque->cheque_rtn_ref_no ?? 'N/A' }}</td>
                                <td>{{ \Carbon\Carbon::parse($returned_cheque->cheque_return_date)->format('Y-m-d') }}</td>
                                <td>{{ $returned_cheque->payment_remarks ?? 'N/A' }}</td>
                                <td class="text-right">{{ \App\Http\Helper::formatNumber($returned_cheque->payment_amount) }}</td>
                                <td class="text-right">{{ \App\Http\Helper::formatNumber($credit) }}</td>
                                <td class="text-right">{{ \App\Http\Helper::formatNumber($balance) }}</td>
                                <td class="text-center">
                                    @php
                                        $count_days = \Carbon\Carbon::parse($returned_cheque->cheque_date)
                                            ->diffInDays(\Carbon\Carbon::now(), false);
                                    @endphp
                                    ({{ $count_days }})
                                </td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot>
                        <tr>
                            <td><b>Total</b></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td class="text-right"><b>{{ \App\Http\Helper::formatPrice($total_cheque_return_amount) }}</b></td>
                            <td class="text-right"><b>{{ \App\Http\Helper::formatPrice($total_credit) }}</b></td>
                            <td class="text-right"><b>{{ \App\Http\Helper::formatPrice($total_balance) }}</b></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
                <hr class="double_hr">
            @endif
        @endforeach
    </div>

</body>

</html>
