<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .double_hr {
            overflow: visible;
            /* For IE */
            padding: 0;
            border: none;
            border-top: medium double #333;
            color: #333;
            text-align: center;
            margin-bottom: 10px;
        }

        hr {
            margin: 3px;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>CHEQUE RETURN REPORT CUSTOMER WISE</H2>
    <p>Filtered by:</p>
    <p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
    <p>Customer : {{ $customer_name ?? '' }} | Area : {{ $city ?? '' }} | Rep : {{ $rep ?? '' }}</p>
    <table>
        <tr>
            <th style="width: 15%;">Payment #</th>
            <th style="width: 16%">Cheque Date</th>
            <th style="width: 15%">Cheque Return Date</th>
            <th style="width: 21%">Payment Ref</th>
            <th style="width: 21%">Remarks</th>
            <th style="width: 16%">Cheque Return Ref No</th>
            <th style="width: 15%; text-align: right;">Total</th>
        </tr>
    </table>
    @php
        $full_total = 0;
    $customer_count = 0;
    @endphp
    @foreach ($customers as $customer)
        <strong>Customer  :</strong> {{ $customer->customer_company_name ?? '' }} {{ $customer->customer_business_name ?? '' }} | <strong>Rep:</strong>
        {{ $customer->fname ?? '' }} {{ $customer->lname ?? '' }} <br>
        <hr>
        <table>
            @php
                $total = 0;
                $customer_count++;
                $cheques = Pramix\XPayment\Models\ChequeModel::where('customer_id', $customer->customer_id)->where('status',2)->get();
                // dd($cheques);
            @endphp
            @foreach ($cheques as $cheque)
                @php
                $cheque_payment_total = \App\Utils\CommonUtil::calculateChequePaymentAmountTotal($cheque->id);
                    $total += $cheque_payment_total;
                    $full_total += $cheque_payment_total;
                @endphp
                <tr>
                    <td style="width: 15%;">{{ $cheque->invoice_payment ? $cheque->invoice_payment->payment_code : 'N/A' }}</td>
                    <td style="width: 16%;">{{ $cheque->cheque_date }}</td>
                    <td style="width: 15%;">{{ \Carbon\Carbon::parse($cheque->cheque_return_date)->format('Y-m-d') }}
                    </td>
                    <td style="width: 21%;">{{ $cheque->payment_ref_no }}</td>
                    <td style="width: 21%;">{{ $cheque->payment_remarks }}</td>
                    <td style="width: 16%;">{{ $cheque->cheque_rtn_ref_no ?? 'N/A' }}</td>
                    <td style="width: 15%; text-align: right;">
                        {{ \App\Http\Helper::formatPrice($cheque->payment_amount) }}
                    </td>
                </tr>
            @endforeach
            <tr>
                <th style="width: 84%;" colspan="6">Total</th>
                <th style="width: 16%; text-align: right;">
                    {{ \App\Http\Helper::formatPrice($total) }}
                </th>
            </tr>
        </table>
        <hr class="double_hr">
    @endforeach
    <table>
        <tr>
            <th style="width: 86%;" colspan="6">Full Total</th>

            <th style="width: 14%; text-align: right;">{{ \App\Http\Helper::formatPrice($full_total) }}
            </th>
        </tr>
    </table>
</body>

</html>
