<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 10px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>Inventory/ Stock Valuation</H2>
    <p>Filtered by:</p>
    {{-- <p>From Date : {{ $from_date ?? '' }}</p> --}}
    {{-- <p>To Date : {{ $end_date ?? '' }}</p> --}}
    {{-- <p>Category : {{ $category ?? '' }}</p> --}}
    <p>Item : {{ $item ?? '' }}</p>
    <table>
        <tr>
            <th>Stock Id #</th>
            <th>Item Code</th>
            <th>Description</th>
            <th style="text-align: right;">Qty</th>
            <th style="text-align: right;">Price</th>
            <th style="text-align: right;">Total Qty Value</th>
        </tr>
        <?php
        $total_qty = 0;
        $total_price = 0;
        $total_qty_value = 0;
        ?>
        @foreach ($inventories as $inventory)
            <tr>
                @php
                    $total_qty += $inventory->qty_on_hand;
                    $total_price += $inventory->price;
                    $total_qty_value += $inventory->qty_value;
                @endphp
                <td>{{ $inventory->stock_id }}</td>
                <td>{{ $inventory->item_code }}</td>
                <td>{{ $inventory->description }}</td>
                <td style="text-align: right;">{{ number_format($inventory->qty_on_hand) }}</td>
                <td style="text-align: right;">{{ \App\Http\Helper::formatPrice($inventory->price) }}</td>
                <td style="text-align: right;">{{ \App\Http\Helper::formatPrice($inventory->qty_value) }}</td>
            </tr>
        @endforeach
        <tr>
            <th style="text-align: center;" colspan="3">Total</th>
            <th style="text-align: right;">{{ number_format($total_qty) }}</th>
            <th style="text-align: right;">{{ \App\Http\Helper::formatPrice($total_price) }}</th>
            <th style="text-align: right;">{{ \App\Http\Helper::formatPrice($total_qty_value) }}</th>
        </tr>
    </table>
</body>

</html>
