<?php

use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['web', 'auth']], function () {

    Route::group(['namespace' => 'Pramix\XReports\Controllers'], function () {

        Route::get('reports/index', 'ReportsController@index')->name('reports.index');

        Route::get('reports/inventory_movement_summary_report', 'ReportsController@inventoryMovementSummaryReport');
        Route::get('reports/products_report', 'ReportsController@productsReport');
        Route::get('reports/sales_by_product_summary_report', 'ReportsController@salesByProductSummary');
        Route::get('reports/sales_order_summary_report', 'ReportsController@salesOrderSummary');
        Route::get('reports/payment_summary_report', 'ReportsController@paymentSummaryReport');
        Route::get('reports/billing_summary_report', 'ReportsController@billingSummaryReport');
        Route::get('reports/outstanding_report', 'ReportsController@customerOutstandingReport');
        Route::get('reports/outstanding_report_period_wise', 'ReportsController@customerOutstandingReportPeriodWise');
        Route::get('reports/cheque_return_outstanding_report', 'ReportsController@chequeReturnOutstandingReport');
        Route::get('reports/low_stock_products_report', 'ReportsController@lowStockProductsReport');
        Route::get('reports/sales_report', 'ReportsController@salesReport')->name('reports.sales_report');
        Route::get('reports/sales_report_item_wise', 'ReportsController@salesReportItemWise')->name('reports.sales_report_item_wise');
        Route::get('reports/goods_return_report', 'ReportsController@goodsReturnReport')->name('reports.goods_return_report');
        Route::get('reports/grn_report', 'ReportsController@grnReport')->name('reports.grn_report');
        Route::get('reports/inventory_report', 'ReportsController@inventoryReport')->name('reports.inventory_report');
        Route::get('reports/customer_transaction_history_report', 'ReportsController@customerTransactionHistoryReport')->name('reports.customer_transaction_history_report');
        Route::get('reports/cheque_return_outstanding_report_period_wise', 'ReportsController@chequeReturnOutstandingReportPeriodWise')->name('reports.cheque_return_outstanding_report_period_wise');
        Route::get('reports/collection_commission_report', 'ReportsController@collectionCommissionReport')->name('reports.collection_commission_report');
        Route::get('reports/direct_sale_report', 'ReportsController@directSaleReport')->name('reports.direct_sale_report');
        Route::get('reports/sales_report_invoice_wise', 'ReportsController@salesReportInvoiceWise')->name('reports.sales_report_invoice_wise');
        Route::get('reports/daily_sales_summary', 'ReportsController@salesCommissionReport')->name('reports.daily_sales_summary_report');
        Route::get('reports/goods_return_wise_summary', 'ReportsController@goodsReturnWise')->name('reports.goods_return_wise_summary');
        Route::get('reports/daily_goods_return_summary', 'ReportsController@dailyGoodsReturnSummaryReport')->name('reports.daily_goods_return_summary_report');
        Route::get('reports/payment_summary_report_invoice_wise', 'ReportsController@paymentSummaryReportInvoiceWise')->name('reports.payment_summary_report_invoice_wise');
        Route::get('reports/daily_payment_summary_report', 'ReportsController@dailyPaymentSummaryReport')->name('reports.daily_payment_summary_report');
        Route::get('reports/cheque_return_report', 'ReportsController@chequeReturnReport')->name('reports.cheque_return_report');
        Route::get('reports/cheque_return_invoice_wise_report', 'ReportsController@chequeReturnInvoiceWiseReport')->name('reports.cheque_return_invoice_wise_report');
        Route::get('reports/daily_cheque_return_report', 'ReportsController@dailyChequeReturnReport')->name('reports.daily_cheque_return_report');
        Route::get('reports/sales_commission_report', 'ReportsController@salesCommissionReport')->name('reports.sales_commission_report');

        Route::get('reports/purchasing_summary_report', 'ReportsController@purchasingSummaryReport');
        Route::post('reports/generate_daily_collection_report', 'ReportsController@generateInventoryMovementSummaryReport');
        Route::post('reports/generate_products_report', 'ReportsController@generateProductsReport');
        Route::post('reports/generate_sales_by_product_summary_report', 'ReportsController@generateSalesByProductSummaryReport');
        Route::post('reports/generate_sales_order_summary_report', 'ReportsController@generateSalesOrderSummaryReport');
        Route::post('reports/generate_purchase_order_summary_report', 'ReportsController@generatePurchaseOrderSummaryReport');
        //        Route::post('reports/generate_customer_outstanding_report', 'ReportsController@generateCustomerOutstandingReport');
        Route::post('reports/generate_payment_summary_report', 'ReportsController@generatePaymentSummaryReport');
        Route::post('reports/generate_bill_summary_report', 'ReportsController@generateBillingSummaryReport');
        Route::post('reports/generate_customer_outstanding_report', 'ReportsController@generateCustomerOutstandingReport');
        Route::post('reports/generate_customer_outstanding_period_wise_report', 'ReportsController@generateCustomerOutstandingPeriodWiseReport');
        Route::post('reports/generate_cheque_return_outstanding_report', 'ReportsController@generateChequeReturnOutstandingReport');
        Route::post('reports/generate_low_stock_products_report', 'ReportsController@generateLowStockProductsReport');
        Route::post('reports/generate_sales_report', 'ReportsController@generateSalesReport')->name('reports.generate_sales_report');
        Route::post('reports/generate_sales_report_item_wise', 'ReportsController@generateSalesReportItemWise')->name('reports.generate_sales_report_item_wise');
        Route::post('reports/generate_goods_return_report', 'ReportsController@generateGoodsReturnReport')->name('reports.generate_goods_return_report');
        Route::post('reports/generate_grn_report', 'ReportsController@generateGrnReport')->name('reports.generate_grn_report');
        Route::post('reports/generate_inventory_report', 'ReportsController@generateInventoryReport')->name('reports.generate_inventory_report');
        Route::post('reports/generate_customer_transaction_history_report', 'ReportsController@generateCustomerTransactionHistoryReport')->name('reports.generate_customer_transaction_history_report');
        Route::post('reports/generate_cheque_return_outstanding_report_period_wise', 'ReportsController@generateChequeReturnOutstandingReportPeriodWise')->name('reports.generate_cheque_return_outstanding_report_period_wise');
        Route::post('reports/generate_collection_commission_report', 'ReportsController@generateCollectionCommissionReport')->name('reports.generate_collection_commission_report');
        Route::post('reports/generate_direct_sale_report', 'ReportsController@generateDirectSaleReport')->name('reports.generate_direct_sale_report');
        Route::post('reports/generate_sales_report_invoice_wise', 'ReportsController@generateSalesReportInvoiceWise')->name('reports.generate_sales_report_invoice_wise');
        Route::post('reports/generate_daily_sales_summary', 'ReportsController@generateDailySalesSummaryReport')->name('reports.generate_daily_sales_summary_report');
        Route::post('reports/generate_goods_return_wise_summary', 'ReportsController@generateGoodsReturnWise')->name('reports.generate_goods_return_wise_summary');
        Route::post('reports/generate_daily_goods_return_summary', 'ReportsController@generateDailyGoodsReturnSummaryReport')->name('reports.generate_daily_goods_return_summary_report');
        Route::post('reports/generate_payment_summary_report_invoice_wise', 'ReportsController@generatePaymentSummaryReportInvoiceWise')->name('reports.generate_payment_summary_report_invoice_wise');
        Route::post('reports/generate_daily_payment_summary_report', 'ReportsController@generateDailyPaymentSummaryReport')->name('reports.generate_daily_payment_summary_report');
        Route::post('reports/generate_cheque_return_report', 'ReportsController@generateChequeReturnReport')->name('reports.generate_cheque_return_report');
        Route::post('reports/generate_cheque_return_invoice_wise_report', 'ReportsController@generateChequeReturnInvoiceWiseReport')->name('reports.generate_cheque_return_invoice_wise_report');
        Route::post('reports/generate_daily_cheque_return_report', 'ReportsController@generateDailyChequeReturnReport')->name('reports.generate_daily_cheque_return_report');
        Route::post('reports/generate_sales_commission_report', 'ReportsController@generateSalesCommissionReport')->name('reports.generate_sales_commission_report');

    });
});
