<?php

namespace Pramix\XReports\Models;

use App\Customer;
use App\Utils\CommonUtil;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use PDF;
use Pramix\XCustomer\Models\CustomerModel;
use Pramix\XInvoice\Models\InvoicePaymentModel;
use Pramix\XInvoice\Models\InvoiceProductsModel;
use Pramix\XInvoice\Models\InvoiceReturnModel;
use Pramix\XInvoice\Models\InvoiceReturnProductModel;
use Pramix\XProduct\Models\ProductCategoriesModel;
use Pramix\XProduct\Models\ProductsModel;
use Pramix\XUser\Models\User;

class PaymentSummaryReport extends Model
{
    public static function generatePaymentSummaryReport($filter_details = NULL)
    {

        $date_range = NULL;
        $from_date = NULL;
        $end_date = NULL;
        $customer_id = NULL;
        $customer_details = NULL;
        $rep = null;
        $payment_method = $filter_details['payment_method'];

        if ($filter_details['date_range'] != '') {
            $date_range_details = ReportsModel::getReportTimeRange($filter_details);
            $date_range = $filter_details['date_range'];
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
        }


        if (isset($filter_details['customer_id']) && $filter_details['customer_id'] != '') {
            $customer_id = $filter_details['customer_id'];
        }

        $customers = Customer::with(['invoices', 'invoices.invoice_payments'])
            ->where('customer.status', 'A');

        $user = Auth::user();
        if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $customers->where('invoice_type', '35');
        }
        $customers->whereHas('invoices', function ($query) {
            $query->where('status', 'I');
        });
        // $customers->whereHas('invoices.invoice_payments', function ($query) {
        //     $query->where('status', 1);
        // });

        if ($customer_id != NULL) {
            $customers->whereHas('invoices', function ($query) use ($customer_id) {
                $query->where('customer_id', $customer_id);
            });
        }

        if ($date_range != null) {
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');
            $customers->whereHas('invoices.invoice_payments', function ($query) use ($from_date, $end_date) {
                $query->whereBetween('cheque_date', [$from_date, $end_date])->orderBy('cheque_date');
            });
        }

        if ($filter_details['payment_method'] != 'All') {
            if ($filter_details['payment_method'] == 'cash')
                $customers->whereHas('invoices.invoice_payments', function ($query) {
                    $query->where('payment_method', 'cash');
                });
            elseif ($filter_details['payment_method'] == 'cheque')
                $customers->whereHas('invoices.invoice_payments', function ($query) {
                    $query->where('payment_method', 'cheque');
                });
            elseif ($filter_details['payment_method'] == 'debit')
                $customers->whereHas('invoices.invoice_payments', function ($query) {
                    $query->where('payment_method', 'debit');
                });
        }
        if (!empty($filter_details['invoice_rep'])) {
            // dd('in');
            $rep_id = $filter_details['invoice_rep'];
            $customers->whereHas('invoices', function ($query) use ($rep_id) {
                $query->where('rep_id', $rep_id);
            });
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }
        if (!empty($filter_details['payment_rep'])) {
            // dd('in');
            $rep_id = $filter_details['payment_rep'];
            $customers->whereHas('invoices.invoice_payments', function ($query) use ($rep_id) {
                $query->where('invoice_payments.rep_id', $rep_id);
            });
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }
        if (!empty($filter_details['rep_id'])) {
            // dd('in');
            $rep_id = $filter_details['rep_id'];
            $customers->where('rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }
        $customers = $customers->orderBy('business_name')->get();

        //

        if ($customer_id != NULL) {
            $customer_details = CustomerModel::find($customer_id);
        }
        $pdf = PDF::loadView('xreports::sales.payment_summary.payment_summary', array('customers' => $customers, 'from_date' => $from_date, 'end_date' => $end_date, 'payment_method' => $payment_method, 'customer_details' => $customer_details, 'rep' => $rep))
            ->setPaper('letter', 'portrait');

        $file_name = 'payment_summary_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/payment');
        return $path;
    }
}
