<?php

namespace Pramix\XReports\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Utils\ReportUtil;
use App\Jobs\CustomerOutstandingReportEmailJob;
use Exception;
use Pramix\XReports\Models\BillingSummaryReport;
use Pramix\XReports\Models\CustomerOutstandingReport;
use Pramix\XReports\Models\InventoryMovementSummaryReport;
use Pramix\XReports\Models\PaymentSummaryReport;
use Pramix\XReports\Models\ProductsReport;
use Pramix\XProduct\Models\ProductsModel;
use Pramix\XReports\Models\PurchaseOrderSummaryReport;
use Pramix\XReports\Models\ReportsModel;
use Pramix\XReports\Models\SalesByProductSummaryReport;
use Pramix\XReports\Models\SalesOrderSummaryReport;
use Illuminate\Support\Facades\Auth;
use Pramix\XBranches\Models\BranchesModel;
use Pramix\XUser\Models\User;
use Pramix\XConfig\Models\XConfig;

class ReportsController extends Controller
{

    private $reportUtil;
    public function __construct(ReportUtil $reportUtil)
    {
        $this->reportUtil = $reportUtil;
    }

    public function index()
    {
        return view('xreports::index');
    }

    public function inventoryMovementSummaryReport(Request $request)
    {
        return view('xreports::inventory.inventory_movement_summary.index');
    }

    public function productsReport()
    {
        return view('xreports::inventory.products_report.index');
    }

    public function salesOrderSummary()
    {
        return view('xreports::sales.sales_order_summary_report.index');
    }

    public function salesByProductSummary()
    {
        return view('xreports::sales.sales_by_product_summary.index');
    }

    public function paymentSummaryReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.payment_summary.index', compact('roles'));
    }

    public function purchasingSummaryReport()
    {
        return view('xreports::purchasing.purchasing_summary.index');
    }

    public function billingSummaryReport()
    {
        return view('xreports::purchasing.billing_summary.index');
    }

    public function customerOutstandingReport()
    {

        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.customer_outstanding.index', compact('roles'));
    }

    public function customerOutstandingReportPeriodWise()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP')
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }

        return view('xreports::sales.customer_outstanding_period_wise.index', compact('roles'));
    }

    public function chequeReturnOutstandingReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.cheque_return_outstanding.index', compact('roles'));
    }

    public function lowStockProductsReport()
    {
        return view('xreports::inventory.low_stock_products_report.index');
    }


    public function generateProductsReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url =  ProductsReport::generateProductsReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }


    public function generateCustomerOutstandingReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        try{
            if($filter_details['is_send_email']){
                $email_config = XConfig::where('name', 'REPORT_EMAILS')->first();
                if(!empty($email_config)){
                    $send_email = $email_config->value;
                    if(!empty($send_email)){
                        $user = Auth::user();
                        CustomerOutstandingReportEmailJob::dispatch($filter_details, $send_email, $user->username);
                        return response()->json(['status' => 'success', 'msg' => __('common.email.send_successfully')]);
                    }else{
                        return response()->json(['status' => 'error', 'msg' => __('common.email.email_address_not_found')]);
                    }
                }else{
                    return response()->json(['status' => 'error', 'msg' => __('common.email.configurations_error')]);
                }
            }else{
                $report_url =  CustomerOutstandingReport::generateCustomerOutstandingReport($filter_details);
                return response()->json(['status' => 'success', 'report_url' => $report_url]);
            }
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function generateCustomerOutstandingPeriodWiseReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url =  CustomerOutstandingReport::generateCustomerOutstandingPeriodWiseReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }



    public function generateInventoryMovementSummaryReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url =  InventoryMovementSummaryReport::generateInventoryMovementSummaryReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function generateSalesByProductSummaryReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url =  SalesByProductSummaryReport::generateSalesByProductSummaryReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function generateSalesOrderSummaryReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url =  SalesOrderSummaryReport::generateSalesOrderSummaryReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function generatePurchaseOrderSummaryReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url =  PurchaseOrderSummaryReport::generatePurchaseOrderSummaryReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function generateBillingSummaryReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url =  BillingSummaryReport::generateBillingSummaryReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function generatePaymentSummaryReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url =  PaymentSummaryReport::generatePaymentSummaryReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function generateChequeReturnOutstandingReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url =  ReportsModel::generateChequeReturnReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }


    public function generateLowStockProductsReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url =  ReportsModel::generateLowStockProductsReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function salesReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.sales_report.index', compact('roles'));
    }

    public function generateSalesReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url = $this->reportUtil->salesReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }
    public function salesReportItemWIse()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }

        $products = ProductsModel::all();

        return view('xreports::sales.sales_report_item_wise.index',compact('roles', 'products'));
    }

    public function generateSalesReportItemWise(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url = $this->reportUtil->salesReportItemWIse($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function goodsReturnReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.goods_return_report.index', compact('roles'));
    }

    public function generateGoodsReturnReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url = $this->reportUtil->goodsReturnReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function grnReport()
    {
        return view('xreports::purchasing.grn_report.index');
    }

    public function generateGrnReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url = $this->reportUtil->grnReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function inventoryReport()
    {
        return view('xreports::inventory.inventory_report.index');
    }

    public function generateInventoryReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url = $this->reportUtil->inventoryReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function customerTransactionHistoryReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP')
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }


        return view('xreports::sales.customer_transaction_history_report.index', compact('roles'));
    }

    public function generateCustomerTransactionHistoryReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url = $this->reportUtil->customerTransactionHistoryReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function chequeReturnOutstandingReportPeriodWise()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP')
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE'|| $role["name"] !== 'REP'){
            $roles = User::role('REPRESENTATIVE')->get();
        }
        return view('xreports::sales.cheque_return_outstanding_period_wise.index', compact('roles'));
    }

    public function generateChequeReturnOutstandingReportPeriodWise(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url = $this->reportUtil->chequeReturnOutstandingPeriodWiseReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function collectionCommissionReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP')
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::commission.index', compact('roles'));
    }

    public function generateCollectionCommissionReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url = $this->reportUtil->collectionCommissionReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function directSaleReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }

        return view('xreports::sales.direct_sale_report.index', compact('roles'));
    }

    public function generateDirectSaleReport(Request $request)
    {
        parse_str($request['filter_details'], $filter_details);
        $report_url = $this->reportUtil->directSaleReport($filter_details);
        return response()->json(['status' => 'success', 'report_url' => $report_url]);
    }

    public function salesReportInvoiceWise()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.sales_report_invoice_wise.index', compact('roles'));
    }

    public function generateSalesReportInvoiceWise(Request $request)
    {
        try {
            parse_str($request['filter_details'], $filter_details);
            $report_url = $this->reportUtil->generateSalesReportWise($filter_details);
            return response()->json(['status' => 'success', 'report_url' => $report_url]);
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function dailySalesSummaryReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP')
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.daily_sales_summary.index', compact('roles'));
    }

    public function generateDailySalesSummaryReport(Request $request)
    {
        try {
            parse_str($request['filter_details'], $filter_details);
            $report_url = $this->reportUtil->generateDailySalesSummaryReport($filter_details);
            return response()->json(['status' => 'success', 'report_url' => $report_url]);
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function goodsReturnWise()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP')
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.goods_return_wise_summary.index', compact('roles'));
    }

    public function generateGoodsReturnWise(Request $request)
    {
        try {
            parse_str($request['filter_details'], $filter_details);
            $report_url = $this->reportUtil->generateGoodReturnWiseSummaryReport($filter_details);
            return response()->json(['status' => 'success', 'report_url' => $report_url]);
        } catch (Exception $e) {
            // dd('exception');
            dd($e);
        }
    }

    public function dailyGoodsReturnSummaryReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.daily_goods_return_summary.index', compact('roles'));
    }

    public function generateDailyGoodsReturnSummaryReport(Request $request)
    {
        try {
            parse_str($request['filter_details'], $filter_details);

            $report_url = $this->reportUtil->generateDailyGoodsReturnSummaryReport($filter_details);
            return response()->json(['status' => 'success', 'report_url' => $report_url]);
        } catch (Exception $e) {
            // dd('exception');
            dd($e);
        }
    }

    public function paymentSummaryReportInvoiceWise()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.payment_summary_invoice_wise.index', compact('roles'));
    }

    public function generatePaymentSummaryReportInvoiceWise(Request $request)
    {
        try {
            parse_str($request['filter_details'], $filter_details);
            $report_url = $this->reportUtil->generatePaymentSummaryReportWise($filter_details);
            return response()->json(['status' => 'success', 'report_url' => $report_url]);
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function dailyPaymentSummaryReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.daily_payment_summary.index', compact('roles'));
    }

    public function generateDailyPaymentSummaryReport(Request $request)
    {
        try {
            parse_str($request['filter_details'], $filter_details);
            $report_url = $this->reportUtil->generatePaymentSummaryReportWise($filter_details);
            return response()->json(['status' => 'success', 'report_url' => $report_url]);
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function chequeReturnReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.cheque_return.index', compact('roles'));
    }

    public function generateChequeReturnReport(Request $request)
    {
        try {
            parse_str($request['filter_details'], $filter_details);
            $report_url = $this->reportUtil->generateChequeReturnReport($filter_details);
            return response()->json(['status' => 'success', 'report_url' => $report_url]);
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function chequeReturnInvoiceWiseReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.invoice_wise_cheque_return.index', compact('roles'));
    }

    public function generateChequeReturnInvoiceWiseReport(Request $request)
    {
        try {
            parse_str($request['filter_details'], $filter_details);
            $report_url = $this->reportUtil->generateChequeReturnWiseReport($filter_details);
            return response()->json(['status' => 'success', 'report_url' => $report_url]);
        } catch (Request $e) {
            dd($e);
        }
    }

    public function dailyChequeReturnReport()
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::sales.daily_cheque_return.index', compact('roles'));
    }

    public function generateDailyChequeReturnReport(Request $request)
    {
        try {
            parse_str($request['filter_details'], $filter_details);
            $report_url = $this->reportUtil->generateChequeReturnWiseReport($filter_details);
            return response()->json(['status' => 'success', 'report_url' => $report_url]);
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function salesCommissionReport($isDailySalesReport = 'No')
    {
        $user = Auth::user();

        $role = $user->roles()->first();

        $reportName = 'SALES COMMISSION REPORT';

        if($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP' )
        {
            $roles = User::where('id', $user->id)->get();
        }
        else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP'){
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        return view('xreports::commission.sales_commission.index', compact('roles', 'reportName'));
    }

    public function generateSalesCommissionReport(Request $request)
    {
        try {
            parse_str($request['filter_details'], $filter_details);

            $report_url = $this->reportUtil->salesCommissionReportGenerate($filter_details, $request['report']);
            return response()->json(['status' => 'success', 'report_url' => $report_url]);
        } catch (Exception $e) {
            dd($e);
        }
    }
}