<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePurchaseOrderProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchase_order_products', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('branch_id')->nullable();
            $table->integer('purchase_order_id');
            $table->integer('product_id');
            $table->text('description')->nullable();
            $table->integer('qty');
            $table->double('unit_price');
            $table->integer('discount')->nullable();
            $table->string('discount_type')->default('percentage');
            $table->double('sub_total');
            $table->boolean('discarded')->default(false);
            $table->string('type');
            $table->char('status')->nullable();
            $table->integer('created_by');
            $table->integer('updated_by');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_order_products');
    }
}
