<?php

namespace Pramix\XProduct\Models;

use App\Scopes\BranchScopes;
use Illuminate\Database\Eloquent\Model;
use Pramix\XBranches\Models\BranchesModel;
use Pramix\XGRN\Models\GRNProductModel;
use Pramix\XInventory\Models\Inventory;
use Pramix\XInvoice\Models\InvoiceProductsModel;
use Pramix\XMedia\Models\MediaModel;
use Pramix\XMedia\Models\MediaSortModel;
use Pramix\XPurchaseOrder\Models\PurchaseOrderProductsModel;
use Spatie\Activitylog\Traits\LogsActivity;

class ProductsModel extends Model
{
    use LogsActivity;
    protected $table = 'product';
    protected $primaryKey = 'id';
    protected $guarded = ['id'];
    protected static $logAttributes = ['id', 'stock_id', 'item_code', 'price'];
    // protected static $recordEvents = ['updated', 'deleted'];
    protected static $logName = 'product';
    public function setDescriptionAttribute($value)
    {
        $this->attributes['description'] = html_entity_decode($value, ENT_QUOTES);
    }
    
    public static function boot()
    {
        parent::boot();

        static::addGlobalScope(new BranchScopes());

        static::creating(function ($model) {
            $userid = auth()->user()->id;
            $model->created_by = $userid;
            $model->updated_by = $userid;
            $model->branch_id = BranchesModel::getBranchID();
        });

        static::updating(function ($model) {
            $userid = auth()->user()->id;
            $model->updated_by = $userid;
        });

        static::deleting(function ($model) {
            $grnProducts = GRNProductModel::where('product_id', $model->id)->count();
            if ($grnProducts != 0) {
                return false;
            }
            $invoiceProducts = InvoiceProductsModel::where('product_id', $model->id)->count();
            if ($invoiceProducts != 0) {
                return false;
            }
            $purchaseOrderProducts = PurchaseOrderProductsModel::where('product_id', $model->id)->count();
            if ($purchaseOrderProducts != 0) {
                return false;
            }
            $productDiscount = ProductDiscountsModel::where('product_id', $model->id)->first();
            if ($productDiscount) {
                $productDiscount->delete();
            }
            $media = MediaModel::where('ref_id', $model->id)->first();
            if ($media) {
                $mediaSort = MediaSortModel::where('ref_id', $model->id)->first();
                if ($mediaSort) {
                    $mediaSort->delete();
                }
                $media->delete();
            }
            $productInventory = Inventory::where('product_id', $model->id)->first();
            if ($productInventory) {
                $productInventory->delete();
            }
        });
    }

    public function category()
    {
        return $this->hasOne('Pramix\XProduct\Models\ProductCategoriesModel', 'id', 'category_id');
    }

    public function discount()
    {
        return $this->hasOne('Pramix\XProduct\Models\ProductDiscountsModel', 'product_id', 'id');
    }

    public function store_location()
    {
        return $this->hasOne('Pramix\XProduct\Models\StoreLocationsModel', 'id', 'store_location');
    }
}
