@extends('layouts.app')

@section('content')
    <input type="hidden" name="page" id="page" value="{{ $page ?? '' }}">
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>{{ __('xpayment::payment.headings.payment') }}</h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    @can('ADD_PAYMENT')
                        <ul class="right-stats" id="mini-nav-right">
                            <a href="{{ url('payment/create/new') }}" class="btn btn-primary"><i class="fa fa-plus"
                                    aria-hidden="true"></i>
                                {{ __('xpayment::payment.buttons.new_payment') }}</a>
                        </ul>
                    @endcan
                </div>
            </div>
        </div>

        <div class="main-container">
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="form-inline data_list_filters">

                                <div class="form-group">
                                    <label for="">Payment Receipt Number</label> <br>
                                    <input type="text" class="form-control" id="searchpaymentycode"
                                        placeholder="{{ __('xpayment::payment.labels.payment_receipt_no') }}">
                                </div>
                                <div class="form-group">
                                    <div class="col-sm-12">
                                        <br><label for="">Date</label>
                                        {{ formDate(__(''), 'invoice_date_created', Carbon\Carbon::today()->format('Y-m-d'), ['style' => 'margin-bottom: 20px;','class' => 'form-control', 'id' => 'invoice_date_created']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="">Pay Customer</label> <br>
                                    <input type="text" class="form-control" id="searchcustomername"
                                        placeholder="{{ __('xpayment::payment.labels.payment_customer') }}">
                                </div>
                                <div class="form-group">
                                    <br>
                                    <div class="btn-group" data-toggle="buttons">
                                        <label class="btn btn-primary active">
                                            <input type="radio" name="payment_status" value="" checked> All
                                        </label>
                                        <label class="btn btn-primary" id="all_status" data-toggle="tooltip"
                                            data-placement="top" title="Status">
                                            <input type="radio" name="payment_status" value="COMPLETED"> Completed
                                        </label>
                                        <label class="btn btn-primary ">
                                            <input type="radio" name="payment_status" value="CANCELLED"> Cancelled
                                        </label>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                    <div class="table-responsive">
                        <table id="payment_list_table" class="table table-striped table-bordered no-margin" cellspacing="0"
                            width="100%">
                            <thead>
                                <tr>
                                    <th></th>
                                    <th></th>
                                    <th>{{ __('xpayment::payment.labels.payment_receipt_no') }}</th>
                                    <th>{{ __('xpayment::payment.labels.payment_customer') }}</th>
                                    <th>{{ __('xpayment::payment.labels.payment_invoice') }}</th>
                                    <th>{{ __('xpayment::payment.labels.payment_remarks') }}</th>
                                    <th>{{ __('xpayment::payment.labels.payment_amount') }}</th>
                                    <th>{{ __('xpayment::payment.labels.payment_date') }}</th>
                                    <th>{{ __('xpayment::payment.labels.payment_status') }}</th>
                                    <th>REP</th>
                                    <th>{{ __('common.labels.action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('custom_script')
    <script>
        $(document).ready(function() {

            $('#all_status').tooltip('show');

            var payment_list_table = $('#payment_list_table').DataTable({
                'iDisplayLength': 15,
                ajax: '{!! route('get.all_payments') !!}',
                order: [
                    [0, "desc"]
                ],

                columns: [{
                        data: 'id',
                        name: 'id',
                        'bVisible': false
                    },
                    {
                        data: 'invoice_id',
                        name: 'invoice_id',
                        'bVisible': false
                    },
                    {
                        data: 'payment_code',
                        name: 'payment_code'
                    },
                    {
                        data: 'customer',
                        name: 'customer'
                    },
                    {
                        data: 'invoice_code',
                        name: 'invoice_code'
                    },
                    {
                        data: 'payment_remarks',
                        name: 'payment_remarks'
                    },
                    {
                        data: 'payment_amount',
                        name: 'payment_amount'
                    },
                    {
                        data: 'payment_date',
                        name: 'payment_date'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'rep_id',
                        name: 'rep_id'
                    },
                    {
                        data: 'action',
                        name: 'action'
                    },
                ]
            });


            $('#searchpaymentycode').on('keyup', function() {
                payment_list_table.column(2)
                    .search(this.value)
                    .draw();
            });
            $('#searchcustomername').on('keyup', function() {
                payment_list_table.column(3)
                    .search(this.value)
                    .draw();
            });
            $('#invoice_date_created').on('change', function(){
                payment_list_table.column(7)
                    .search(this.value)
                    .draw();
            })
            $('input[type=radio][name="payment_status"]').change(function() {
                payment_list_table.column(8)
                    .search(this.value)
                    .draw();
            });

            $('#payment_list_table tbody').on('click', 'button.payment-print-button', function(e) {
                var $btn = $(this);
                $btn.button('loading');
                var data = payment_list_table.row($(this).parents('tr')).data();
                var params = {
                    invoice_id: data['invoice_id'],
                    record_payment_id: data['id']
                };
                $.ajax({
                    url: BASE + 'invoice/print_payment',
                    type: 'POST',
                    dataType: 'JSON',
                    data: $.param(params),
                    success: function(response) {
                        if (response.status == 'success') {
                            window.open(response.url);
                            $btn.button('reset');

                        } else {
                            notification(response);
                            $btn.button('reset');
                            return false;
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        notificationError(xhr, ajaxOptions, thrownError);
                    }
                });
                return false;
            });

            $('#payment_list_table tbody').on('click', 'button.payment-view-button', function(e) {
                var data = payment_list_table.row($(this).parents('tr')).data();
                window.payment_model = $.confirm({
                    title: '',
                    draggable: true,
                    boxWidth: '80%',
                    closeIcon: true,
                    useBootstrap: false,
                    buttons: {
                        close: function() {}
                    },
                    content: 'url:' + BASE + 'payment/view/' + data['id'],
                    onContentReady: function() {},
                    columnClass: 'medium',
                });
                return false;
            });
            $(document).on('click', '.delete_payment', function(e) {
                var data = payment_list_table.row($(this).parents('tr')).data();
                var parent = $(this).parents('tr');
                let url = "{{ route('payment.destroy', ':id') }}";
                url = url.replace(':id', data['id']);
                var delete_confirm = $.confirm({
                    title: "Delete Payment",
                    type: 'red',
                    buttons: {
                        delete: {
                            text: 'Delete',
                            btnClass: 'btn-red',
                            action: function() {
                                e.preventDefault();
                                var params = {};
                                $.ajax({
                                    url: url,
                                    type: 'DELETE',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function(response) {
                                        if (response.status == 'error') {
                                            delete_confirm.close();
                                            notification(response);
                                        } else {
                                            delete_confirm.close();
                                            notification(response);
                                            payment_list_table.row(parent).remove()
                                                .draw();
                                        }
                                    },
                                    error: function(errors) {}
                                });
                                e.preventDefault();
                                return false;
                            }
                        },
                        close: function() {}
                    }
                });
            });
        });
    </script>
@endsection
