<?php

use Illuminate\Support\Facades\Route;
use Pramix\XPayment\Controllers\PaymentController;

Route::group(['middleware' => ['web', 'auth']], function () {

    Route::group(['namespace' => 'Pramix\XPayment\Controllers'], function () {

        Route::get('get_payment_list', 'PaymentController@getPaymentList')->name('get.all_payments');


        Route::get('payment/view/{id?}', 'PaymentController@viewPayment');
        Route::post('payment/cal_payment_price', 'PaymentController@calPaymentePrice');

        Route::post('payment/save_payment', 'PaymentController@saveInvoicePayment');
        Route::post('payment/reject_payment', 'PaymentController@rejectPayment');
        Route::post('payment/approve_payment', 'PaymentController@approvePayment');
        Route::post('payment/update/all/cheques', 'PaymentController@updateAllCheques')->name('payments.update_all_cheques');
        Route::delete('payments/{id}/destroy', 'PaymentController@destroy')->name('payments.destroy');

        Route::post('payment_edit', 'PaymentController@PaymentEdit');

        Route::get('cheque_payment', 'PaymentController@viewChequePayments')->name('cheque_payment.view');

        Route::get('get_cheque_payments_list', 'PaymentController@getChequePaymentsList')->name('get.all_cheque_payments');


        Route::get('get_auto_data', 'ChequeController@getAutoLoadData');

        Route::get('get_cheque_list', 'ChequeController@getChequesList')->name('get.all_cheques');
        Route::post('cheque/cheque_print', 'ChequeController@chequePrint');

        Route::resource('payment', 'PaymentController');
        Route::resource('cheque', 'ChequeController');

        Route::get('payments/get/selected/invoice/balance', [PaymentController::class, 'getSelectedInvoiceBalance'])->name('payments.get_selected_invoice_balance');
    });
});
