@extends('layouts.app')

@section('content')
    @if ($page == 'invoice')
        <?php
        $header = __('xinvoice::invoice.headings.invoice_list');
        $createLink = 'invoice/create';
        $createText = __('xinvoice::invoice.buttons.new_invoice');
        ?>
    @elseif($page == 'estimate')
        <?php
        $header = __('estimate.headings.estimate_list');
        $createLink = 'estimate/create';
        $createText = __('estimate.buttons.new_estimate');
        ?>
    @endif
    <input type="hidden" name="page" id="page" value="{{ $page ?? '' }}">
    <input type="hidden" name="invoice_type" id="invoice_type" value="{{ $invoice_type ?? '' }}">


    <!-- Dashboard wrapper starts -->
    <div class="dashboard-wrapper">

        <!-- Top bar starts -->
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        @if (isset($invoice_type) && $invoice_type == 'all')
                            <h4>Orders List</h4>
                        @elseif(isset($invoice_type) && $invoice_type == 'QUICK')
                            <h4>Quick Orders List</h4>
                        @elseif(isset($invoice_type) && $invoice_type == 'ORDERS')
                            <h4>Orders List</h4>
                        @elseif(isset($invoice_type) && $invoice_type == 'DISPATCH')
                            <h4>Ready to Dispatch List</h4>
                        @elseif(isset($invoice_type) && $invoice_type == 'INVOICE')
                            <h4>Invoice List</h4>
                        @endif
                    </div>
                </div>
                @php
                    $create_invoice_flag = false;
                    if (
                        auth()
                            ->user()
                            ->can('ADD_INVOICE') ||
                        auth()
                            ->user()
                            ->can('ORDER_CREATE')
                    ) {
                        $create_invoice_flag = true;
                    }
                @endphp
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    @if ($create_invoice_flag)
                        <ul class="right-stats" id="mini-nav-right">
                            <a href="{{ url('invoice/create') }}" class="btn btn-primary"><i class="fa fa-plus"
                                    aria-hidden="true"></i>
                                {{ __('xinvoice::invoice.buttons.new_invoice') }}</a>
                        </ul>
                    @endif
                </div>
            </div>
        </div>
        <!-- Top bar ends -->
        <!-- Main container starts -->
        <div class="main-container">
            <!-- Row starts -->
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="{{ route('invoice.index') }}">
                                <div class="form-inline data_list_filters">

                                    <div class="form-group">
                                        <label for="">Invoice Number</label> <br>
                                        <input type="text" name="invoice_code" value="{{ request('invoice_code') }}"
                                            class="form-control" id="searchinvoicecode" placeholder="Invoice #">
                                    </div>
                                    <div class="form-group">

                                        <div class="col-sm-12">
                                            <br>
                                            <label for="">INVOICE Date</label><br>
                                            <input name="invoice_date" value="{{ request('invoice_date') }}"
                                                style="margin-bottom: 20px;" class="form-control dates">
                                        </div>
                                    </div>
                                    <div class="form-group">

                                        <label for="">Select Rep</label> <br>
                                        <select name="rep_id" id="rep" class="form-control select2 select3">
                                            <option value="">Select Rep</option>
                                            @foreach ($roles as $role)
                                                {{-- - {{$role ->fname }} --}}
                                                <option value="{{ $role->id }}"
                                                    @if (request('rep') == $role->id) selected @endif>{{ $role->username }}
                                                    - {{ $role->fname }} </option>
                                            @endforeach
                                        </select>

                                    </div>
                                    <div class="form-group">
                                        <label for="">Customer</label> <br>
                                        <input type="text" name="customer_name" class="form-control"
                                            id="searchcustomername"
                                            placeholder="{{ __('xinvoice::invoice.labels.customer') }}"
                                            value="{{ request('customer_name') }}">
                                    </div>
                                    <div class="form-group">
                                        <br>
                                        &nbsp; <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                            <label class="btn btn-success active">
                                                <input type="radio" name="payment_status" value=""
                                                    @if (request('payment_status') == '') checked @endif> All
                                            </label>

                                            <label class="btn btn-success">
                                                <input type="radio" name="payment_status" value="Pending"
                                                    @if (request('payment_status') == 'Pending') checked @endif> Pending
                                            </label>
                                            <label class="btn btn-success" data-toggle="tooltip" data-placement="top"
                                                title="Payment Status" id="all_payment_status">
                                                <input type="radio" name="payment_status" value="Partial"
                                                    @if (request('payment_status') == 'Partial') checked @endif> Partial
                                            </label>
                                            <label class="btn btn-success">
                                                <input type="radio" name="payment_status" value="Completed"
                                                    @if (request('payment_status') == 'Completed') checked @endif> Completed
                                            </label>
                                            <input type="hidden" name="invoice_type" value="{{ $invoice_type }}">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <br>&nbsp;&nbsp;<button type="submit" style="margin-top: 10px;"
                                            class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Submit</button>
                                    </div>
                                    <div class="form-group">
                                        <br>&nbsp;&nbsp;

                                        <a href="{{ url('invoice?invoice_type=' . $invoice_type) }}"
                                            style="margin-top: 10px;"
                                            class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Reset</a>
                                    </div>
                                </div>
                            </form>

                        </div>

                    </div>
                    <div class="table-responsive">
                        <table id="invoiceListTable" class="table table-striped table-bordered no-margin" cellspacing="0"
                            width="100%">
                            <thead>
                                <tr>
                                    <th hidden></th>
                                    <th>{{ __('xinvoice::invoice.labels.invoice_no') }}</th>
                                    <th>{{ __('xinvoice::invoice.labels.invoice_date') }}</th>
                                    <th>{{ __('xinvoice::invoice.labels.customer') }}</th>
                                    <th>{{ __('xinvoice::invoice.labels.total') }}</th>
                                    <th>Rep</th>
                                    <th>Remarks</th>
                                    <th>Payment Status</th>
                                    <th>{{ __('xinvoice::invoice.labels.status') }}</th>
                                    <th>{{ __('xinvoice::invoice.labels.created_by') }}</th>
                                    <th>Action</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($invoices as $invoice)
                                    <tr>
                                        <td hidden>{{ $invoice->id }}</td>
                                        <td>{{ $invoice->invoice_code }}</td>
                                        <td>{{ $invoice->invoice_date }}</td>
                                        <td>
                                            @if (isset($invoice->customer->company_name))
                                                <strong>{{ $invoice->customer->company_name }}</strong><br>
                                            @endif

                                            @if (isset($invoice->customer->fullname))
                                                {{ $invoice->customer->fullname }}
                                            @endif
                                        </td>
                                        <td>{{ App\Http\Helper::formatPrice($invoice->total) }}</td>
                                        <td>{{ $invoice->rep->username ?? 'N/A' }}</td>
                                        <td>{{ $invoice->remarks }}</td>
                                        <td>
                                            @php
                                                $outstanding_amount = App\Utils\CommonUtil::calculateInvoiceOutstanding($invoice->id);
                                            @endphp

                                            @if ($outstanding_amount <= 0)
                                                <span class="text-success"><strong>Completed</strong></span>
                                            @else
                                                <span class="text-danger"><strong>Pending</strong>
                                                    {{ Carbon\Carbon::parse($invoice->invoice_date)->diffInDays(Carbon\Carbon::now(), false) }}
                                                    Days</span>
                                                <p>{{ App\Http\Helper::formatPrice($outstanding_amount) }}</p>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($invoice->customer == null)
                                                <strong>Quick Sell</strong>
                                            @elseif ($invoice->status == 'O')
                                                <span class="text-danger"><strong>Order</strong></span>
                                            @elseif ($invoice->status == 'D')
                                                <span class="text-success"><strong>Ready to Dispatch</strong></span>
                                            @elseif ($invoice->status == 'I')
                                                <span class="text-primary">Invoice</span>
                                            @endif
                                        </td>
                                        <td>{{ $invoice->user->username }}</td>
                                        @php
                                            $delete_invoice_permission = Auth::user()->can(['DELETE_INVOICE']);
                                            $edit_invoice_permission = false;
                                            if (Auth::user()->can('EDIT_INVOICE')) {
                                                $edit_invoice_permission = true;
                                            }

                                        @endphp
                                        <td>
                                            @if ($edit_invoice_permission)
                                                <a class="btn btn-info btn-xs"
                                                    href="{{ url('/invoice/' . $invoice->id . '/edit') }}"
                                                    id="edit_invoice" data-original-title="" title=""><i
                                                        class="fa fa-pencil"></i></a>
                                            @endif

                                            @if ($delete_invoice_permission)
                                                &nbsp;<button class="delete_invoice btn btn-danger btn-xs"
                                                    data-toggle="tooltip" data-placement="right" title=""
                                                    data-original-title="Delete " aria-describedby="tooltip934027"><i
                                                        class="fa fa-trash-o" aria-hidden="true"></i></button>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="d-flex justify-content-end">
                            {{ $invoices->appends($_GET)->links() }}
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row ends -->
        </div>
        <!-- Main container ends -->
    </div>
    <!-- Dashboard wrapper ends -->
@endsection

@section('include_js')
@endsection

@section('custom_script')
    <script>
        $(document).ready(function() {

            $('#all_payment_status').tooltip('show');
            $('#all_status').tooltip('show');

            if ($('#page').val() == 'invoice') {
                // var invoiceListTable = $('#invoiceListTable').DataTable({
                //     'iDisplayLength': 15,
                //     ajax: BASE + 'invoices_list?invoice_type=' + $('#invoice_type').val(),
                //     order: [
                //         [0, "desc"]
                //     ],
                //     processing: true,
                //     serverSide: true,
                //     columns: [{
                //             data: 'id',
                //             name: 'id',
                //             'bVisible': false
                //         },
                //         {
                //             data: 'invoice_code',
                //             name: 'invoice_code'
                //         },
                //         {
                //             data: 'invoice_date',
                //             name: 'invoice_date'
                //         },
                //         {
                //             data: 'customer',
                //             name: 'customer'
                //         },
                //         {
                //             data: 'total',
                //             name: 'total',
                //             className: 'dt-body-right'
                //         },

                //         {
                //             data: 'rep_id',
                //             name: 'rep_id',

                //         },
                //         {
                //             data: 'remarks',
                //             name: 'remarks',

                //         },
                //         {
                //             data: 'payment_status',
                //             name: 'payment_status'
                //         },
                //         {
                //             data: 'status',
                //             name: 'status',
                //             'bVisible': false
                //         },
                //         {
                //             data: 'created_by',
                //             name: 'created_by'
                //         },
                //         {
                //             data: 'action',
                //             name: 'action'
                //         },
                //     ]
                // });
            }


            $(document).on('click', '.delete_invoice', function(e) {
                var data = {};
                var firstTDValue = $(this).closest('tr').find('td:first').text().trim();
                data['id'] = firstTDValue;
                var parent = $(this).parents('tr');

                var delete_confirm = $.confirm({
                    title: "Delete Invoice",
                    type: 'red',
                    buttons: {
                        delete: {
                            text: 'Delete',
                            btnClass: 'btn-red',
                            action: function() {

                                e.preventDefault();
                                var params = {

                                };

                                $.ajax({
                                    url: BASE + 'invoice/' + data['id'],
                                    type: 'DELETE',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function(response) {
                                        if (response.status == 'error') {
                                            delete_confirm.close();
                                            notification(response);
                                        } else {

                                            delete_confirm.close();

                                            notification(response);
                                            location.reload();

                                        }
                                    },
                                    error: function(errors) {

                                    }
                                });
                                e.preventDefault();
                                return false;
                            }
                        },
                        close: function() {}
                    }
                });
            });

            $('#invoice_date_created').on('change', function() {
                invoiceListTable.column(2)
                    .search(this.value)
                    .draw();
            })

            $('#searchinvoicecode').on('keyup', function() {
                invoiceListTable.column(1)
                    .search(this.value)
                    .draw();
            });

            $('#searchcustomername').on('keyup', function() {
                invoiceListTable.column(3)
                    .search(this.value)
                    .draw();
            });

            $('#searchrep').on('keyup', function() {
                invoiceListTable.column(3)
                    .search(this.value)
                    .draw();
            });

            $('input[type=radio][name=payment_status]').change(function() {
                invoiceListTable.column(8)
                    .search(this.value)
                    .draw();
            });
            $('input[type=radio][name=invoice_status]').change(function() {
                invoiceListTable.column(9)
                    .search(this.value)
                    .draw();
            });
        });
    </script>
@endsection
