@extends('layouts.app')

@section('include_css')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/dragula/3.7.2/dragula.min.css" rel="stylesheet" />
@endsection
@section('content')
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>Create Discount & Credit <span id="invoice_type_label"></span>
                        </h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    @can('SAVE_DISCOUNT_AND_CREDIT')
                        <ul class="right-stats" id="save_button_group">
                            <button class="btn btn-primary"
                                id="bulk_invoice_save_btn">{{ __('xinvoice::invoice.buttons.save') }}</button>
                        </ul>
                    @endcan
                </div>
            </div>
        </div>

        <div class="main-container">
            <form action="{{ route('bulk_discounts.store') }}" method="POST" id="bulk_discount_form">
                @csrf
                <input type="hidden" name="invoice_id" id="invoice_id" value="">
                <input type="hidden" name="customer_id" id="customer_id" value="">
                <input type="hidden" name="page" id="ref_type" value="IN">
                <input type="hidden" id="invoice_type" name="invoice_type" value="10">
                <!-- Row starts -->
                <div class="row gutter">
                    <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                        <div class="card" id="customer_detail_panel">
                            <div class="card-body">
                                @include('xinvoice::customer_filter')
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-5 col-sm-6 col-xs-12">

                        <div class="alert alert-info alert-dismissible" id="customer_info_alert"></div>

                        <div class="alert alert-info alert-dismissible" id="products_info_alert">

                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="card" id="invoice_details_panel">
                            <div class="card-body">

                                <div class="row">
                                    <div class="col-sm-12">
                                        {{ formText(__('xinvoice::invoice.labels.invoice_return_code'), 'invoice_no', '', ['class' => 'form-control ', 'id' => 'invoice_no']) }}
                                    </div>
                                    <div class="col-sm-12">
                                        {{ formDate(__('xinvoice::invoice.labels.invoice_date'), 'invoice_date_created', Carbon\Carbon::today()->format('Y-m-d'), ['class' => 'form-control', 'id' => 'invoice_date_created']) }}
                                    </div>
                                </div>


                                <span id="display_status">
                                    <span class="label label-danger" id="invoice_status_label"></span>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Row ends -->
                <div class="" id="all_details_panel">
                    <div id="overlay"></div>
                    <div class="form-group"></div>
                    <h5>Invoices</h5>
                </div>
                <div class="row gutter">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row col-md-12">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Invoice No</label>
                                            <div class="form-group">
                                                <input type="text" class="form-control" id="search_invoice_no"
                                                    placeholder="Search Invoice No #">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <br>
                                        <button type="button" id="search_invoice" class="btn btn-primary">Search</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card card-primary" id="">
                        <div class="card-body">
                            <div class="row gutter">
                                <div class="col-12">
                                    <div class="table-responsive">
                                        <table id="InvoicesTable" class="table table-bordered no-margin" cellspacing="0"
                                            width="100%">
                                            <thead>
                                                <tr>
                                                    <th>{{ __('xinvoice::invoice.labels.invoice_no') }}</th>
                                                    <th>{{ __('xinvoice::invoice.labels.invoice_date') }}</th>
                                                    <th>{{ __('xinvoice::invoice.labels.total') }}</th>
                                                    <th>{{ __('xinvoice::invoice.labels.discount') }}</th>
                                                    <th>{{ __('xinvoice::invoice.labels.paid') }}</th>
                                                    <th>{{ __('xinvoice::invoice.labels.balance') }}</th>
                                                    <th>Payment Status</th>
                                                    <th>{{ __('xinvoice::invoice.labels.status') }}</th>
                                                    <th>New Adding Discount</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                {{ formTextArea(__('xinvoice::invoice.labels.remarks'), 'remarks', $invoice_return->remarks ?? '', ['class' => 'form-control', 'id' => 'remarks', 'rows' => 2]) }}
                            </div>
                        </div>
                    </div>
                    <!-- Row ends -->
            </form>


        </div>
        <!-- Main container ends -->

    </div>
    <!-- Dashboard wrapper ends -->
@endsection

@section('include_js')
    <script src="{{ asset('/pramix/js/invoice_js.js?v=4') }}"></script>
@endsection

@section('custom_script')
    <script>
        $(document).on('click', '.remove_selected_invoice', function() {
            this.closest('tr').remove();
        });
        $(document).on('click', '#bulk_invoice_save_btn', function() {
            let table_item_count = $('#InvoicesTable tbody tr').length
            if (table_item_count == 0) {
                $.notify({
                    // options
                    message: "Please add Invoices to add discounts",
                }, {
                    // settings
                    z_index: 10000000000,
                    type: "danger",
                });
            } else {
                let all_discount_values = true;
                $('#InvoicesTable tbody tr').each(function() {
                       let discount = $(this).find('td #discount').val();
                            discount = parseFloat(discount); // Ensure it's a float for decimal validation
                         // Check if discount is not a valid number
                         if (isNaN(discount)) {
                       all_discount_values = false;
                    }
                   });
                if (all_discount_values) {

                    $('#bulk_discount_form').submit();
                } else {
                    $.notify({
                        // options
                        message: "Please add discount if you need to all the invoices in the table",
                    }, {
                        // settings
                        z_index: 10000000000,
                        type: "danger",
                    });
                }
            }
        });

        $(document).on('click', '#discount', function() {
            $(this).select();
        });

        $(document).on('click', '#search_invoice', function() {
            let invoice_no = $('#search_invoice_no').val();
            let customer_id = $('#customer_id').val();
            let table_item_count = $('#InvoicesTable tbody tr').length;
            if (customer_id === '') {
                $.notify({
                    // options
                    message: "Please select customer to proceed.!",
                }, {
                    // settings
                    z_index: 10000000000,
                    type: "danger",
                });
                return false;
            }
            if (invoice_no === '') {
                $.notify({
                    // options
                    message: "Please add invoice no to search.!",
                }, {
                    // settings
                    z_index: 10000000000,
                    type: "danger",
                });
                return false;
            }
            getCustomerDueInvoices(customer_id, invoice_no, table_item_count)
        });

        function getCustomerDueInvoices(customer_id, invoice_no, table_item_count) {
            $.ajax({
                url: BASE + 'invoices/bulk-discount/get/invoices/' + customer_id,
                method: 'GET',
                data: {
                    invoice_no: invoice_no,
                    table_item_count: table_item_count,
                },
                success: function(response) {
                    $('#InvoicesTable tbody').append(response);
                },
                error: function(response) {
                    $.notify({
                        // options
                        message: "No related invoice.!",
                    }, {
                        // settings
                        z_index: 10000000000,
                        type: "danger",
                    });
                }
            });
        }
    </script>
@endsection
