@extends(Request::ajax() ? 'layouts.model' : 'layouts.app')

@section('include_css')
    {{-- REMOVED: DataTables Checkbox CSS is no longer needed --}}
    <link rel="stylesheet" href="{{ asset('/pramix/css/custom.css') }}">
@endsection

@section('content')
    @if ($page == 'invoice_return')
        <?php
        if (!isset($invoice_return->id)) {
            $header = __('xinvoice::invoice.headings.new_credit_note');
        } else {
            $header = __('xinvoice::invoice.headings.edit_credit_note');
        }
        ?>
    @endif
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>{{ $header }}</h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <ul class="right-stats" >
                        <a href="javascript:void(0)" class="btn btn-primary disabled"
                            id="invoice_return_save">{{ __('xinvoice::invoice.buttons.save') }}</a>

                        <a href="javascript:void(0)" class="btn btn-primary disabled"
                            id="invoice_return_save_and_new">{{ __('xinvoice::invoice.buttons.save_and_new') }}</a>
                        <a href="javascript:void(0)" class="btn btn-primary" id="settle_outstanding_invoices">Settle
                            Outstanding Invoices</a>
                    </ul>
                </div>
            </div>
        </div>

        <div class="main-container">
            <input type="hidden" name="ref_type" id="ref_type" value="INR">
            <input type="hidden" name="isajax" id="isajax" value="{{ Request::ajax() }}">
            <input type="hidden" name="page" id="page" value="{{ $page ?? '' }}">

            <!-- Row starts -->
            <div class="row gutter">
                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                    <div class="card" id="">
                        <div class="card-body" id="customer_filter">
                            @include('xcustomer::customer_filter')
                            @include('xinvoice::invoice_return.invoice_filter')
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                    <div class="alert alert-info alert-dismissible" id="customer_info_alert" style="display: none;"></div>
                    <div class="alert alert-info alert-dismissible" id="products_info_alert" style="display: none;"></div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                    <div class="card" id="invoice_return_details_panel">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    {{ formText(__('xinvoice::invoice.labels.invoice_return_code'), 'invoice_return_no', $invoice_return->invoice_return_code ?? '', ['class' => 'form-control ', 'id' => 'invoice_return_no', 'readonly' => 'readonly']) }}
                                </div>
                                <div class="col-sm-12">
                                    {{ formDate('Credit note date', 'invoice_return_date_created', old('date_created', isset($invoice_return->invoice_return_date) ? $invoice_return->invoice_return_date : \Carbon\Carbon::today()->format('Y-m-d')), ['class' => 'form-control', 'id' => 'invoice_return_date_created']) }}
                                </div>
                            </div>
                            <span id="display_status">
                                @if (isset($invoice_return->status) && $invoice_return->status == 'D')
                                    <span class="label label-danger">Draft</span>
                                @elseif(isset($invoice_return->status) && $invoice_return->status == 'A')
                                    <span class="label label-success">Completed</span>
                                @endif
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row ends -->
            <div class="" id="all_details_panel">
                <div id="overlay" style="display: none;"></div>
                <div class="card card-primary" id="product-detail-card">
                    <div class="card-body">
                        <div class="row gutter">
                            <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                                <div class="form-group no-margin" id="item_product_code_selector_div">
                                    {{ Form::select('stock_id', \Pramix\XProduct\Models\ProductsModel::pluck('stock_id','id') , ''  , array('class' => 'form-control select2' , 'id' => 'item_stock_id','placeholder' => 'Select Stock ID')) }}
                                 </div>
                            </div>
                            <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                                <div class="form-group no-margin" id="item_product_code_selector_div">
                                    {{ Form::select('products', \Pramix\XProduct\Models\ProductsModel::pluck('item_code','id') , ''  , array('class' => 'form-control select2' , 'id' => 'invoice_return_item_product_code','title' => '')) }}
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                                <div class="form-group no-margin">
                                    <input type="text" data-toggle="tooltip" data-placement="top" title="Description" class="form-control" id="description"  name="description"
                                           placeholder="{{ __('xproduct::product.labels.description')}}">
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-2 col-sm-6 col-xs-12">
                                <div class="form-group no-margin">
                                    <input type="number" data-toggle="tooltip" data-placement="top" title="Quantity" class="form-control" id="quantity" name="quantity"
                                           placeholder="{{ __('xproduct::product.labels.quantity')}}">
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-2 col-sm-6 col-xs-12">
                                <div class="form-group no-margin">
                                    <input type="number"  data-toggle="tooltip" data-placement="top" title="Unit Price"  class="form-control" id="unit_price" name="unit_price"
                                           placeholder="{{ __('xproduct::product.labels.unit_price')}}">
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-2 col-sm-6 col-xs-12">
                                <div class="form-group no-margin">
                                    <input type="number"  data-toggle="tooltip" data-placement="top" title="Discount"  class="form-control" id="product_discount" name="discount"
                                           placeholder="{{ __('xproduct::product.labels.discount')}}">


                                </div>
                            </div>
                            <div class="col-lg-1 col-md-2 col-sm-6 col-xs-12">
                                <div class="form-group no-margin">
                                    {{ Form::select('discount_type', getConfig('DISCOUNT_TYPE'), isset($customer->discount_type) ? $customer->discount_type : getConfigValue('DISCOUNT_TYPE') , array('class' => 'form-control', 'id' => 'product_discount_type')) }}
                                </div>
                            </div>

                            <div class="col-lg-1 col-md-4 col-sm-6 col-xs-12">
                                <div class="checkbox checkbox-inline">
                                    <input type="checkbox" id="checked_discarded" name='checked_discarded'  @if(isset($invoice_return->discarded)&& $invoice_return->discarded!=0) checked @endif/>
                                    <label for="checked_discarded">Discarded</label>
                                    <input type="hidden" class="row_count">
                                    <input type="hidden" class="update_amount">
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                                <div class="form-group no-margin">
                                    <button class="btn btn-success btn-block" id="update_item_btn" hidden>UPDATE</button>
                                    <button class="btn btn-success btn-block" id="add_item_row_btn">ADD</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row gutter">
                    <div class="col-12">
                        <div class="table-responsive">
                            <table id="ProductTable" class="table table-bordered no-margin"
                                   cellspacing="0" width="100%">
                                <thead>
                                <tr>
                                    <th hidden>STOCK ID VALUE</th>
                                    <th hidden>STOCK ID</th>
                                    <th>ITEM</th>
                                    <th>DESCRIPTION</th>
                                    <th>QUANTITY</th>
                                    <th>UNIT PRICE</th>
                                    <th>DISCOUNT</th>
                                    <th>DISCOUNT TYPE</th>
                                    <th>SUB TOTAL</th>
                                    <th>Stock status</th>
                                    <th>ACTIONS</th>
                                    <th hidden>ITEM VALUE</th>
                                    <th hidden>ROW #</th>
                                </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="text-right" style="margin-top: 10px;">
                    <label for="" class="sub_total" id="sub_total" style="font-size: 1.5em; font-weight: bold;"> SUB TOTAL : 0.00 </label>
                </div>
                <div class="form-group"></div>

                <h5>Credit Note Deduct from</h5>
                <div class="card card-primary" id="invoice_payment_detail_panel">
                    <div class="card-body">
                        <div class="row gutter">
                            <div class="table-responsive">
                                <table id="PendingInvoiceTable" class="table table-striped table-bordered no-margin"
                                    cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th>{{ __('xinvoice::invoice.labels.invoice_no') }}</th>
                                            <th>{{ __('xinvoice::invoice.labels.invoice_date') }}</th>
                                            <th>{{ __('xinvoice::invoice.labels.total') }}</th>
                                            <th>{{ __('xinvoice::invoice.labels.paid') }}</th>
                                            <th>{{ __('xinvoice::invoice.labels.balance') }}</th>
                                            <th>Credit Note Balance</th>
                                            <th>Payment Status</th>
                                            <th>Status</th>
                                            <th>Created By</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr><td colspan="11" class="text-center">Please select an invoice first</td></tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row gutter">
                    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                        <div class="card">
                            <div class="card-body">
                                {{ formTextArea(__('xinvoice::invoice.labels.remarks'), 'remarks', $invoice_return->remarks ?? '', ['class' => 'form-control', 'id' => 'remarks', 'rows' => 2]) }}
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                        <div class="card" id="price_panel">
                            <div class="card-body">
                                <div class="form-horizontal">
                                    <div class="form-group row gutter">
                                        <label class="col-sm-3 control-label" for="sub_total">{{ __('xinvoice::invoice.labels.subtotal') }}</label>
                                        <div class="col-sm-9">
                                            <input type="number" class="form-control" name="sub_total" id="invoice_return_sub_total" value="{{ $invoice_return->sub_total ?? '0.00' }}" disabled="true">
                                        </div>
                                    </div>
                                    <div class="form-group row gutter">
                                        <label class="col-sm-3 control-label" for="discount">{{ __('xinvoice::invoice.labels.discount') }}</label>
                                        <div class="col-sm-9">
                                            <div class="row gutter">
                                                <div class="col-md-6">
                                                    <input type="number" class="form-control" id="invoice_return_discount" name="invoice_return_discount" value="{{ $invoice_return->discount ?? '0' }}">
                                                </div>
                                                <div class="col-md-6">
                                                    {{ Form::select('discount_type', getConfig('DISCOUNT_TYPE'), isset($invoice_return->discount_type) ? $invoice_return->discount_type : getConfigValue('DISCOUNT_TYPE'), ['class' => 'form-control', 'id' => 'invoice_return_discount_type']) }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row gutter">
                                        <label class="col-sm-3 control-label" for="total">{{ __('xinvoice::invoice.labels.total') }}</label>
                                        <div class="col-sm-9">
                                            <input type="number" class="form-control" id="total" name="total" value="{{ $invoice_return->total ?? '0.00' }}" disabled="true">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card" id="customer_comment_content">
                    @include('xgeneral::comment_section')
                </div>
            </div>
        </div>
    </div>
@endsection

@section('include_js')
    <script src="{{ asset('/pramix/js/invoice_return_js.js?v=12') }}"></script>
@endsection

@section('custom_script')
    <script>
        $(document).ready(function() {
            window.onbeforeunload = function() {
                return "Are you sure you want to leave this page?";
            };

            $('#product-detail-card').find('input, select, button, checkbox, a').prop('disabled', true);
            document.getElementById("overlay").style.display = "block";


            $("#invoice_code_selected").change(function(e) {
                var invoiceId = $(this).val();
                if (!invoiceId) {
                    $('#product-detail-card').find('input, select, button, checkbox, a').prop('disabled', true);
                    return;
                }

                $('#product-detail-card').find('input, select, button, checkbox').prop('disabled', false);
                var params = {
                    invoice_id: invoiceId
                };
                e.preventDefault();
                $.ajax({
                    url: BASE + 'get_invoice_details',
                    type: 'POST',
                    dataType: 'JSON',
                    data: $.param(params),
                    success: function(response) {

                        console.log(response);

                        if (response.status == 'success') {
                            changeCustomer.run(response.invoice.customer_id, '', '', '');

                            $("#invoice_return_item_product_code, #item_stock_id").find('option').remove();

                            $.each(response.products, function() {
                                $("#invoice_return_item_product_code").append($("<option />").val(this.id).text(this.item_code));
                                $("#item_stock_id").append($("<option />").val(this.id).text(this.stock_id));
                            });

                            var selectedproduct = new Option('Please select product', '', true, true);
                            $('#invoice_return_item_product_code').append(selectedproduct).trigger('change.select2');

                            var selectedstockid = new Option('Select Stock ID', '', true, true);
                            $('#item_stock_id').append(selectedstockid).trigger('change.select2');

                            populatePendingInvoicesTable(response.outstanding_invoices);

                            $('#invoice_return_discount').val(response.invoice.discount);
                            $('#invoice_return_discount_type').val(response.invoice.discount_type).trigger('change');
                        } else {
                            notification(response);
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        notificationError(xhr, ajaxOptions, thrownError);
                    }
                });
            });

            @if (isset($invoice))
                $('#invoice_code_selected').val({{ $invoice->id }}).trigger('change');
            @endif

            @if (isset($invoice_return->invoice_id))
                $('#invoice_code_selected').val({{ $invoice_return->invoice_id }}).trigger('change');
                $("#remarks").Editor("setText", `{!! $invoice_return->remarks ?? '' !!}`);
                $('#overlay').hide('slow');
            @endif

            @if (isset($invoice_return->status) && $invoice_return->status != 'D')
                $('#product-detail-card').hide('slow');
                $('#customer_detail_panel :input').prop("disabled", true);
                $('#price_panel :input').prop("disabled", true);
                $('#invoice_return_details_panel :input').prop("disabled", true);
            @endif

        });
    </script>
@endsection
