@extends('layouts.app')

@section('include_css')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/dragula/3.7.2/dragula.min.css" rel="stylesheet" />
@endsection
@section('content')
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>Edit Invoices Bulk Discount <span id="invoice_type_label"></span>
                        </h4>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-container">
            <form action="{{ route('bulk_discounts.update', $bulkDiscountInvoice->id) }}" method="POST"
                id="bulk_discount_edit_form">
                @csrf
                <input type="hidden" name="invoice_id" id="invoice_id" value="{{ $bulkDiscountInvoice->id }}">
                <input type="hidden" name="customer_id" id="customer_id" value="{{ $bulkDiscountInvoice->customer_id }}">
                <!-- Row starts -->
                <div class="row gutter">
                    <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                        <div class="card" id="customer_detail_panel">
                            <div class="card-body">
                                @include('xinvoice::edit_customer_filter')
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-5 col-sm-6 col-xs-12">

                        <div class="alert alert-info alert-dismissible" id="customer_info_alert"></div>

                        <div class="alert alert-info alert-dismissible" id="products_info_alert">

                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="card" id="invoice_details_panel">
                            <div class="card-body">

                                <div class="row">
                                    <div class="col-sm-12">
                                        {{ formText(__('xinvoice::invoice.labels.invoice_return_code'),'invoice_no',$bulkDiscountInvoice->invoice_code,['class' => 'form-control ', 'id' => 'invoice_no', 'readonly' => 'readonly']) }}
                                    </div>
                                    <div class="col-sm-12">
                                        {{ formDate(__('xinvoice::invoice.labels.invoice_date'),'invoice_date_created',isset($bulkDiscountInvoice->date)? Carbon\Carbon::parse($bulkDiscountInvoice->date)->format('Y-m-d'): Carbon\Carbon::today()->format('Y-m-d'),['class' => 'form-control', 'id' => 'invoice_date_created', 'readonly']) }}
                                    </div>
                                </div>


                                <span id="display_status">
                                    <span class="label label-danger" id="invoice_status_label"></span>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Row ends -->
                <div class="" id="all_details_panel">
                    <div id="overlay"></div>
                    <div class="form-group"></div>
                    <h5>Invoices</h5>
                </div>
                <div class="card card-primary" id="">
                    <div class="card-body">
                        <div class="row gutter">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="EditInvoicesTable" class="table table-bordered no-margin" cellspacing="0"
                                        width="100%">
                                        <thead>
                                            <tr>
                                                <th>{{ __('xinvoice::invoice.labels.invoice_no') }}</th>
                                                <th>{{ __('xinvoice::invoice.labels.invoice_date') }}</th>
                                                <th>{{ __('xinvoice::invoice.labels.total') }}</th>
                                                <th>{{ __('xinvoice::invoice.labels.discount') }}</th>
                                                <th>{{ __('xinvoice::invoice.labels.paid') }}</th>
                                                <th>{{ __('xinvoice::invoice.labels.balance') }}</th>
                                                <th>Payment Status</th>
                                                <th>{{ __('xinvoice::invoice.labels.status') }}</th>
                                                <th>New Adding Discount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($bulkDiscountInvoices as $bulk_discount_invoice)
                                                @php
                                                    $pendingInvoice = Pramix\XInvoice\Models\InvoiceModel::where('id', $bulk_discount_invoice->invoice_id)->first();
                                                @endphp
                                                <tr>
                                                    <td>{{ $pendingInvoice->invoice_code }}</td>
                                                    <td>{{ $pendingInvoice->invoice_date }}</td>
                                                    <td class="text-right">{{ App\Http\Helper::formatPrice($pendingInvoice->total) }}</td>
                                                    <td class="text-right">{{ App\Http\Helper::formatPrice($pendingInvoice->discount) }}
                                                    </td>
                                                    <td class="text-right">{{ App\Http\Helper::formatPrice($pendingInvoice->paid_amount) }}
                                                    </td>
                                                    <td class="text-right">{{ App\Http\Helper::formatPrice($pendingInvoice->balance) }}</td>
                                                    <td>
                                                        @if ($pendingInvoice->total <= $pendingInvoice->paid_amount)
                                                            <span class="text-success"><strong>Completed</strong></span>
                                                        @elseif ($pendingInvoice->total == $pendingInvoice->balance)
                                                            @php
                                                                $count_days = Carbon\Carbon::now()->diff(Carbon\Carbon::parse($pendingInvoice->invoice_date));
                                                            @endphp
                                                            <span class="text-danger"><strong>Pending</strong></span>
                                                            {{ $count_days->format('%d Days') }}
                                                        @elseif ($pendingInvoice->total != $pendingInvoice->balance)
                                                            <span class="text-primary"><strong>Partial</strong></span>
                                                        @else
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if ($pendingInvoice->customer == null)
                                                            <strong>Quick Sell</strong>
                                                        @elseif ($pendingInvoice->status == 'O')
                                                            <span class="text-danger"><strong>Order</strong></span>
                                                        @elseif ($pendingInvoice->status == 'D')
                                                            <span class="text-success"><strong>Ready to
                                                                    Dispatch</strong></span>
                                                        @elseif ($pendingInvoice->status == 'I')
                                                            <span class="text-primary">Invoice</span>
                                                        @else
                                                        @endif
                                                    </td>
                                                    <td class="text-right">
                                                        Rs. {{ number_format($bulk_discount_invoice->discount, '2') }}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            {{ formTextArea(__('xinvoice::invoice.labels.remarks'), 'remarks', $bulkDiscountInvoice->remarks ?? '', ['class' => 'form-control', 'id' => 'remarks', 'rows' => 2, 'readonly']) }}
                        </div>
                    </div>
                </div>
                <!-- Row ends -->
            </form>


        </div>
        <!-- Main container ends -->

    </div>
    <!-- Dashboard wrapper ends -->
@endsection

@section('include_js')
    <script src="{{ asset('/pramix/js/invoice_js.js?v=4') }}"></script>
@endsection

@section('custom_script')
    <script>
        $(document).on('click', '.remove_selected_invoice', function() {
            this.closest('tr').remove();
        });
        $(document).on('click', '#bulk_invoice_update_btn', function() {
            let table_item_count = $('#EditInvoicesTable tbody tr').length
            if (table_item_count == 0) {
                $.notify({
                    // options
                    message: "Please add Invoices to add discounts",
                }, {
                    // settings
                    z_index: 10000000000,
                    type: "danger",
                });
            } else {
                let all_discount_values = true;
                $('#EditInvoicesTable tbody tr').each(function() {
                    let discount = $(this).find('td #discount').val();
                         discount = parseFloat(discount); // Ensure it's a float for decimal validation
                             // Check if discount is not a valid number or less than 0
                          if (isNaN(discount) || discount < 0) {
                       all_discount_values = false;
                     }
                })
                if (all_discount_values) {
                    $('#bulk_discount_edit_form').submit();
                } else {
                    $.notify({
                        // options
                        message: "Please add discount if you need to add discounts all the invoices in the table",
                    }, {
                        // settings
                        z_index: 10000000000,
                        type: "danger",
                    });
                }
            }
        });
        $(document).on('click', '#discount', function() {
            $(this).select();
        })
    </script>
    @if (isset($bulkDiscountInvoice->customer_id))
        <script>
            $(document).ready(function() {
                $('#customer_id_select').val({{ $bulkDiscountInvoice->customer_id }}).trigger('change.select2');
                changeSelectedCustomer.run($("#customer_id").val(), '', '');
            });
        </script>
    @endif
@endsection
