<?php

namespace Pramix\XInvoice\Models;

use App\Scopes\BranchScopes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Pramix\XBranches\Models\BranchesModel;
use Pramix\XCustomer\Models\CustomerModel;
use Spatie\Activitylog\Traits\LogsActivity;

class InvoiceReturnModel extends Model
{
    protected $table = 'invoice_return';
    protected $primaryKey = 'id';

    use SoftDeletes, LogsActivity;
    protected static $logAttributes = ['id', 'invoice_return_code', 'status', 'total'];
    protected static $logName = 'invoice_return';

    protected $dates = ['deleted_at'];
    protected $casts = [
        'invoice_ids' => 'object'
    ];
    protected $guarded = ['id'];

    public static function boot()
    {
        parent::boot();

        static::addGlobalScope(new BranchScopes());

        static::creating(function ($model) {
            $userid = 0;

            if (isset(auth()->user()->id))
                $userid = auth()->user()->id;
            $model->created_by = $userid;
            $model->updated_by = $userid;
            $model->branch_id = BranchesModel::getBranchID();
        });

        static::created(function ($model) {
        });

        static::updating(function ($model) {
            $userid = 0;
            if (isset(auth()->user()->id))
                $userid = auth()->user()->id;
            $model->updated_by = $userid;
        });
        static::deleting(function ($model) {
            //* model means credit note
            $invoice = InvoiceModel::where('id', $model->deduct_invoice_id)->first();
            $invoice_return_total = $model->total;
            $invoice_return_discount = $model->discount;
            $invoice_return_net_total = $invoice_return_total + $invoice_return_discount;
            $invoice->returned_amount -= $invoice_return_total;
            $invoice->balance += $invoice_return_net_total;
            $invoice->update();
            $customer = CustomerModel::where('id', $model->customer_id)->first();
            $customer->outstanding_amount += $invoice_return_net_total;
            // $customer->credit_balance += $invoice_return_total;
            $customer->update();
//            CustomerModel::updateCustomerOutStanding($model->customer_id);
            $invoiceReturnProducts = InvoiceReturnProductModel::where('invoice_return_id', $model->id)->get();
            if ($invoiceReturnProducts) {
                foreach ($invoiceReturnProducts as $invoiceReturnProduct) {
                    $invoiceReturnProduct->delete();
                }
            }
        });
    }

    public function customer()
    {
        return $this->hasone('Pramix\XCustomer\Models\CustomerModel', 'id', 'customer_id');
    }

    public function user()
    {
        return $this->hasone('Pramix\XUser\Models\User', 'id', 'created_by');
    }

    public function deductionInvoice()
    {
        return $this->belongsTo('Pramix\XInvoice\Models\InvoiceModel', 'deduct_invoice_id', 'id');
    }

    public function invoice()
    {
        return $this->belongsTo('Pramix\XInvoice\Models\InvoiceModel', 'invoice_id', 'id');
    }

    public function invoiceReturnProducts()
    {
        return $this->hasMany('Pramix\XInvoice\Models\InvoiceReturnProductModel', 'invoice_return_id', 'id');
    }
}
