<?php

namespace Pramix\XInvoice\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Helper;
use App\Utils\ReferenceUtil;
use Carbon\Carbon;
use Countries;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Pramix\XCustomer\Models\CustomerModel;
use Pramix\XGeneral\Models\OptionModel;
use Pramix\XInventory\Models\AverageCostModel;
use Pramix\XInventory\Models\Inventory;
use Pramix\XInvoice\Models\InvoiceModel;
use Pramix\XInvoice\Models\InvoiceProductsModel;
use Pramix\XInvoice\Models\InvoiceReturnModel;
use Pramix\XInvoice\Models\InvoiceReturnProductModel;
use Pramix\XProduct\Models\ProductCategoriesModel;
use Pramix\XProduct\Models\ProductsModel;
use Pramix\XUser\Models\Permission;
use Yajra\DataTables\DataTables;
use Pramix\Templates\Models\GenerateInvoiceReturnModel;
use App\Utils\CommonUtil;
use Pramix\XUser\Models\User;


class InvoiceReturnController extends Controller
{

    public function index(Request $request)
    {
        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

        $user = Auth::user();
        $role = $user->roles()->first();

        if ($role->id != 1 && Auth::user()->can(['SHOW_OWN_DATA']) || $role["name"] == 'REPRESENTATIVE' || $role["name"] == 'REP') {
            $roles = User::where('id', $user->id)->get();
        } else if ($role["name"] !== 'REPRESENTATIVE' || $role["name"] !== 'REP') {
            $roles = User::role(['REP', 'REPRESENTATIVE'])->get();
        }
        $page = 'invoice_return';
        $invoice_returns = InvoiceReturnModel::where('status', '=', 'A')
            ->where('invoice_return_code', '!=', '')
            ->where('parent_id', NULL)
            ->with('customer')->with('user')
            ->when($request->invoice_return_code, function ($query, $invoice_return_code) {
                return $query->where('invoice_return.invoice_return_code', $invoice_return_code);
            })
            ->when($request->rtn_invoice_code, function ($query, $rtn_invoice_code) {

                return $query->whereHas('deductionInvoice', function ($subquery) use ($rtn_invoice_code) {
                    $subquery->where('invoice_code', $rtn_invoice_code);
                });
            })
            ->when($request->invoice_return_code, function ($query, $invoice_return_code) {
                return $query->where('invoice_return.invoice_return_code', $invoice_return_code);
            })
            ->when($request->invoice_return_date, function ($query, $invoice_return_date) {
                $dates = explode(' - ', $invoice_return_date);
                $startDate = date('Y-m-d', strtotime($dates[0]));
                $endDate = date('Y-m-d', strtotime($dates[1]));

                $dateRange = [$startDate, $endDate];
                return $query->whereBetween('invoice_return.invoice_return_date', $dateRange);
            })
            ->when($request->customer_name, function ($query, $customer_name) {

                $similarCustomers = CustomerModel::where('company_name', 'like', '%' . $customer_name . '%')->get();
                $customerIds = $similarCustomers->pluck('id')->toArray();
                return $query->whereIn('invoice_return.customer_id',  $customerIds);
            })
            ->when($request->rep_id, function ($query, $rep_id) {

                return $query->whereHas('customer', function ($subquery) use ($rep_id) {
                    $subquery->where('rep_id', $rep_id);
                });
            })
            ->when($request->invoice_rtn_status, function ($query, $invoice_rtn_status) {
                return $query->where('invoice_return.status', $invoice_rtn_status);
            });
        if ($user->username == 'user35' || $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $invoice_returns = $invoice_returns->where('customer_type', '35');
        }
        $invoice_returns = $invoice_returns->latest()->paginate(100);
        return view('xinvoice::invoice_return.return_list', compact('invoice_returns', 'roles'))->with('page', $page);
    }
    // COMMENTED INTENTIONALLY DO NOT DELETE
    // public function index(Request $request)
    // {
    //     Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

    //     $page = 'invoice_return';
    //     return view('xinvoice::invoice_return.returns_list')->with('page', $page);
    // }

    public function create(Request $request)
    {

        // Create Function Is move to the anither controller in main project
        // InvoiceReturnCreationController.php

        Permission::checkPermission($request, 'ADD_CREDIT_NOTE');

        $invoice = NULL;

        if (isset($request['invoice_id'])) {
            $invoice = InvoiceModel::find($request['invoice_id']);
        }

        $page = 'invoice_return';
        $invoice_returns = '';
        $product_list = ProductsModel::where('type', '!=', 'production')->pluck('item_code', 'id');
        $product_catagory = ProductCategoriesModel::pluck('category_name', 'id');

        return view('xinvoice::invoice_return.create_invoice_return')
            ->with('product_catagory', $product_catagory)
            ->with('product_list', $product_list)
            ->with('page', $page)
            ->with('invoice', $invoice)
            ->with('invoice_returns', $invoice_returns);
    }


    public function store(Request $request)
    {

        Permission::checkPermission($request, 'ADD_CREDIT_NOTE');

        if ($request['customer_id'] != '') {

            $invoice_return_details = new InvoiceReturnModel();
            $invoice_return_details->invoice_return_code = '';
            $invoice_return_details->invoice_return_date = Carbon::now();
            $invoice_return_details->customer_id = $request['customer_id'];
            $invoice_return_details->customer_type = $request['invoice_type'];
            $invoice_return_details->invoice_id = $request['invoice_id'];
            $invoice_return_details->status = 'D';
            $invoice_return_details->save();

            return response()->json(['status' => 'success', 'invoice_return_details' => $invoice_return_details]);
        }
    }


    public function show($id)
    {
        $invoice_return = InvoiceReturnModel::find($id);

        if ($invoice_return->invoice_id) {
            $invoice_return->load('invoice');
        }

        $ids = $invoice_return->invoice_ids;

        if (is_array($ids) || $ids instanceof \ArrayAccess) {
            $invoices = InvoiceModel::whereIn('id', $ids)->get();
        } else {
            $invoices = collect();
        }

        $deduction_invoices = InvoiceReturnModel::where('parent_id', $id)->get();

        // return $invoice_return;
        return view('xinvoice::invoice_return.show', compact('invoice_return', 'deduction_invoices', 'invoices'));
    }


    public function getOutstandingInvoiceList($customer_id)
    {

        $invoice_type = 'all';


        $invoice = InvoiceModel::where('invoice_code', '!=', '')->with('return_invoice')->with('customer')->with('user');

        $due_invoice_list = CommonUtil::getOutstandingInvoiceListByCustomer($customer_id);

        $invoice->where('customer_id', $customer_id);

        $invoice->whereIn('id', $due_invoice_list);

        $invoice->where('status', 'I');


        $invoice = $invoice->get();


        $edit_invoice_permission = false;
        if (Auth::user()->can('EDIT_INVOICE')) {
            $edit_invoice_permission = true;
        }

        return Datatables::of($invoice)
            ->addColumn('action', function ($invoice) use ($edit_invoice_permission) {

                $actions = '';
                if ($edit_invoice_permission) {

                    $actions .= ' <a target="="_blank" class = "btn btn-info btn-xs" href="' . url("/invoice/" . $invoice->id . "/edit") . '" id="edit_invoice" data-original-title="" title=""><i class="fa fa-pencil"></i></a> ';
                }

                return $actions;
            })
            ->addColumn('created_by', function ($invoice) {
                return $invoice->user->username;
            })
            ->editColumn('payment_status', function ($invoice) {

                if ($invoice->total <= $invoice->paid_amount)
                    return '<span class="text-success"><strong>Completed</strong></span>';
                elseif ($invoice->total == $invoice->balance) {

                    $count_days = Carbon::parse($invoice->invoice_date)->diffInDays(Carbon::now(), false);

                    return '<span class="text-danger"><strong>Pending</strong></span> ' . $count_days . ' Days';
                } elseif ($invoice->total != $invoice->balance)
                    return '<span class="text-primary"><strong>Partial</strong></span>';
            })
            ->editColumn('status', function ($invoice) {

                if ($invoice->customer == NULL)
                    return '<strong>Quick Sell</strong>';

                if ($invoice->status == 'O')
                    return '<span class="text-danger"><strong>Order</strong></span>';
                elseif ($invoice->status == 'D')
                    return '<span class="text-success"><strong>Ready to Dispatch</strong></span>';
                elseif ($invoice->status == 'I')
                    return '<span class="text-primary">Invoice</span>';
            })
            ->editColumn('total', function ($invoice) {

                return Helper::formatPrice($invoice->total);
            })
            ->editColumn('paid_amount', function ($invoice) {
                $invoice_paid_amount_total = \App\Utils\CommonUtil::calculatePaidAmountInvoice($invoice->id);
                return Helper::formatPrice($invoice_paid_amount_total);
                // return Helper::formatPrice($invoice->paid_amount);
            })
            ->editColumn('balance', function ($invoice) {
                $invoice_balance_total = \App\Utils\CommonUtil::calculateInvoiceOutstanding($invoice->id);
                return Helper::formatPrice($invoice_balance_total);
            })
            ->rawColumns(['payment_status', 'status', 'action', 'customer'])
            ->make(true);
    }

    public function getInvoiceReturnInvoice($invoice_id)
    {


        $invoice = InvoiceModel::where('invoice_code', '!=', '')->with('customer')->with('user');
        $invoice->where('id', $invoice_id);
        $invoice->where('balance', '>', 0);
        $invoice->where('status', 'I');
        $invoice = $invoice->get();

        $edit_invoice_permission = false;
        if (Auth::user()->can('EDIT_INVOICE')) {
            $edit_invoice_permission = true;
        }

        return Datatables::of($invoice)
            ->addColumn('action', function ($invoice) {
                $actions = '';
                return $actions;
            })
            ->addColumn('created_by', function ($invoice) {
                return $invoice->user->username;
            })
            ->editColumn('payment_status', function ($invoice) {
                if ($invoice->total <= $invoice->paid_amount)
                    return '<span class="text-success"><strong>Completed</strong></span>';
                elseif ($invoice->total == $invoice->balance) {
                    $count_days = Carbon::parse($invoice->invoice_date)->diffInDays(Carbon::now(), false);
                    return '<span class="text-danger"><strong>Pending</strong></span> ' . $count_days . ' Days';
                } elseif ($invoice->total != $invoice->balance)
                    return '<span class="text-primary"><strong>Partial</strong></span>';
            })
            ->editColumn('status', function ($invoice) {
                if ($invoice->customer == NULL)
                    return '<strong>Quick Sell</strong>';
                if ($invoice->status == 'O')
                    return '<span class="text-danger"><strong>Order</strong></span>';
                elseif ($invoice->status == 'D')
                    return '<span class="text-success"><strong>Ready to Dispatch</strong></span>';
                elseif ($invoice->status == 'I')
                    return '<span class="text-primary">Invoice</span>';
            })
            ->editColumn('total', function ($invoice) {
                return Helper::formatPrice($invoice->total);
            })
            ->editColumn('paid_amount', function ($invoice) {
                return Helper::formatPrice($invoice->paid_amount);
            })
            ->editColumn('balance', function ($invoice) {
                return Helper::formatPrice($invoice->balance);
            })
            ->rawColumns(['payment_status', 'status', 'action', 'customer'])
            ->make(true);
    }


    public function edit($id, Request $request)
    {
        Permission::checkPermission($request, 'EDIT_CREDIT_NOTE');

        $page = 'invoice_return';
        $invoice_return = InvoiceReturnModel::find($id);

        return view('xinvoice::invoice_return.create_invoice_return')
            ->with('page', $page)
            ->with('invoice_return', $invoice_return);
    }


    public function update(Request $request, $id)
    {

        Permission::checkPermission($request, 'EDIT_CREDIT_NOTE');

        $invoice_return_details = InvoiceReturnModel::find($id);
        $return_from_invoices_array = $request['return_from_invoices_array'];
        // dd($return_from_invoices_array);
        $status = $request['status'];
        if ($status == 'A') {
            $invoice_return_products = InvoiceReturnProductModel::where('invoice_return_id', $id)->where('status', 0)->get();

            foreach ($invoice_return_products as $invoice_return_product) {
                if ($invoice_return_product->status != 1) {
                    $product = ProductsModel::find($invoice_return_product->product_id);
                    if ($product->type == 'stock' && $invoice_return_product->discarded == 0) {
                        Inventory::increaseInventory($invoice_return_product->product_id, getConfigArrayValueByKey('STOCK_TRANSACTION_TYPES', 'invoice_return'), $invoice_return_details->invoice_return_code, $invoice_return_product->qty, NULL);
                    }
                    $invoice_return_product->status = 1;
                    $invoice_return_product->save();
                }
            }

            foreach ($return_from_invoices_array as $return_invoice) {
                $new_invoice_return_details = new InvoiceReturnModel();

                if ($invoice_return_details->invoice_return_code == '') {
                    $invoice_type = $invoice_return_details->customer_type;
                    $last_record = InvoiceReturnModel::where('customer_type', $invoice_type)
                        ->orderBy('id', 'desc')->where('invoice_return_code', '!=', '')->first();
                    $prefix = !empty($invoice_type) ? ($invoice_type == 10 ? 'IG' : 'BG') : 'IG';
                    $new_invoice_return_details->invoice_return_code = OptionModel::generateCode($prefix, 4, $last_record->invoice_return_code ?? NULL);
                }

                $new_invoice_return_details->customer_id = !empty($request['customer_id']) ? ($request['customer_id']) : 0;
                $new_invoice_return_details->customer_type = !empty($request['invoice_type']) ? ($request['invoice_type']) : 10;
                $new_invoice_return_details->invoice_id = !empty($request['invoice_id']) ? ($request['invoice_id']) : 0;
                $new_invoice_return_details->deduct_invoice_id = !empty($return_invoice['invoice_id']) ? ($return_invoice['invoice_id']) : 0;
                $new_invoice_return_details->remarks = $request['remarks'];
                $new_invoice_return_details->status = $status;
                $new_invoice_return_details->sub_total = $return_invoice['credit_note_balance'];
                $new_invoice_return_details->total = $return_invoice['credit_note_balance'];
                $new_invoice_return_details->balance = $return_invoice['credit_note_balance'];
                $new_invoice_return_details->invoice_return_date = $request['invoice_return_date_created'];
                $new_invoice_return_details->save();
            }
        }



        return response()->json(['status' => 'success', 'msg' => __('common.messages.save_successfully'), 'invoice_return_details' => $invoice_return_details]);
    }


    public function destroy(Request $request, $id)
    {
        Permission::checkPermission($request, 'DELETE_CREDIT_NOTE');
        if ($request->ajax()) {

            // Delete related credit note products
            DB::table('invoice_return_product')->where('invoice_return_id', $id)->delete();

            // Delete related deduction invoices
            DB::table('invoice_return')->where('parent_id', $id)->delete();

            if (DB::table('invoice_return')->where('id', $id)->delete())
                return response()->json(['status' => 'success', 'msg' => __('common.messages.record_deleted')]);
            else
                return response()->json(['status' => 'error', 'msg' => __('common.messages.save_error')]);
        }
    }

    public function getProductsByCategory(Request $request)
    {
        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

        $category_id = $request['category_id'];
        $invoice_id = $request['invoice_id'];


        if ($category_id != null) {
            $products = DB::table('invoice_products')
                ->join('product', 'invoice_products.product_id', '=', 'product.id')
                ->join('product_categories', 'product.category_id', '=', 'product_categories.id')
                ->select('product.*')
                ->where('product_categories.id', '=', $category_id)
                ->where('invoice_products.invoice_id', '=', $invoice_id)
                ->get();
        } else {
            $products = DB::table('invoice_products')
                ->join('product', 'invoice_products.product_id', '=', 'product.id')
                ->where('invoice_products.invoice_id', '=', $invoice_id)
                ->select('product.*')
                ->get();
        }

        return response()->json(['status' => 'success', 'products' => $products]);
    }

    public function getInvoiceDetails(Request $request)
    {
        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

        if ($request['invoice_id'] != '') {
            $invoice_id = $request['invoice_id'];
            $invoice = InvoiceModel::find($invoice_id);

            // Get products related to the selected invoice
            $products = DB::table('invoice_products')
                ->join('product', 'invoice_products.product_id', '=', 'product.id')
                ->select('product.*')
                ->whereNull('invoice_products.deleted_at')
                ->where('invoice_products.invoice_id', '=', $invoice_id)
                ->get();

            // Get categories related to the selected invoice
            $categories = DB::table('invoice_products')
                ->join('product', 'invoice_products.product_id', '=', 'product.id')
                ->join('product_categories', 'product.category_id', '=', 'product_categories.id')
                ->select('product_categories.*')
                ->whereNull('invoice_products.deleted_at')
                ->where('invoice_products.invoice_id', '=', $invoice_id)
                ->get()
                ->unique();

            // ** NEW CODE ADDED HERE **
            // Get all outstanding invoices for the customer of the selected invoice
            $outstanding_invoices = [];
            if ($invoice && $invoice->customer_id) {
                $customer_id = $invoice->customer_id;
                $due_invoice_list = CommonUtil::getOutstandingInvoiceListByCustomer($customer_id);

                // Fetch base invoice data without paid_amount and balance from the table
                $invoices_to_process = InvoiceModel::where('customer_id', $customer_id)
                    ->whereIn('id', $due_invoice_list)
                    ->where('status', 'I')
                    ->select('id', 'invoice_code', 'invoice_date', 'total')
                    ->get();

                // Manually calculate the paid_amount and balance for each invoice using helpers
                $invoices_to_process->each(function ($inv) {
                    $inv->paid_amount = CommonUtil::calculatePaidAmountInvoice($inv->id);
                    $inv->balance = CommonUtil::calculateInvoiceOutstanding($inv->id);
                });

                $outstanding_invoices = $invoices_to_process;
            }

            return response()->json([
                'status' => 'success',
                'invoice' => $invoice,
                'products' => $products,
                'categories' => $categories,
                'outstanding_invoices' => $outstanding_invoices // ** NEW: Pass this data to the view **
            ]);
        }
    }

    public function getInvoiceReturnProductDetails(Request $request)
    {
        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

        if ($request['invoice_id'] != '') {
            $invoice_return_product_detail = InvoiceProductsModel::where('invoice_id', $request['invoice_id'])->where('product_id', $request['product_id'])->with('product')->first();
            return response()->json(['status' => 'success', 'invoice_return_product_detail' => $invoice_return_product_detail]);
        }
    }


    public function getInvoiceReturnList(Request $request)
    {
        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

        $invoice_returns = InvoiceReturnModel::where('invoice_return_code', '!=', '')->with('customer')->with('user')->get();
        $user = Auth::user();
        if ($user->username == 'user35' || $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $invoice_returns = $invoice_returns->where('customer_type', '35');
        }
        $edit_invoicer_permission = false;
        $delete_credit_note_permission = false;
        if (Auth::user()->can('EDIT_CREDIT_NOTE')) {
            $edit_invoicer_permission = true;
        }
        if (auth()->user()->can('DELETE_CREDIT_NOTE')) {
            $delete_credit_note_permission = true;
        }

        return Datatables::of($invoice_returns)
            ->addColumn('action', function ($invoice_returns) use ($edit_invoicer_permission, $delete_credit_note_permission) {
                $actions = '';
                if ($edit_invoicer_permission) {
                    // if ($invoice_returns->status == 'D')
                    $actions .= '<a class = "btn btn-info btn-xs" href="' . url("/invoice_return/" . $invoice_returns->id . "/show") . '" id="edit_customer" data-original-title="" title=""><i class="fa fa-eye"></i></a>';
                }
                if ($delete_credit_note_permission) {
                    $actions .= '&nbsp;<button  class="delete_credit_note btn btn-danger btn-xs" data-toggle="tooltip" data-placement="right" title="Delete Credit Note" data-original-title="Delete" aria-describedby="tooltip934027"><i class="fa fa-trash-o" aria-hidden="true"></i></button>';
                }
                return $actions;
            })
            ->addColumn('invoice_code', function ($invoice_returns) {
                if (isset($invoice_returns->deduct_invoice_id) && $invoice_returns->deduct_invoice_id != 0)
                    return $invoice_returns->deductionInvoice->invoice_code;
            })
            ->addColumn('customer', function ($invoice_returns) {
                if (isset($invoice_returns->customer))
                    return $invoice_returns->customer->company_name;
            })
            ->addColumn('rep', function ($invoice_returns) {
                if (isset($invoice_returns->customer->rep->username))
                    return $invoice_returns->customer->rep->username;
            })
            ->editColumn('status', function ($invoice_returns) {
                if ($invoice_returns->status == 'D')
                    return '<span class="text-danger"><strong>Draft</strong></span>';
                elseif ($invoice_returns->status == 'A')
                    return '<span class="text-success"><strong>Completed</strong></span>';
            })
            ->editColumn('total', function ($invoice_returns) {
                return Helper::formatPrice($invoice_returns->total);
            })
            ->editColumn('paid_amount', function ($invoice_returns) {
                return Helper::formatPrice($invoice_returns->paid_amount);
            })
            ->editColumn('balance', function ($invoice_returns) {
                return Helper::formatPrice($invoice_returns->balance);
            })
            ->rawColumns(['status', 'action'])
            ->make(true);
    }


    public function createInvoiceReturnProduct(Request $request)
    {

        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

        try {

            // save default invoice return
            $customer_id = $request->customer_id;
            $customer = CustomerModel::find($customer_id);
            $latest_invoice_return_code = InvoiceReturnModel::latest('invoice_return_code')->first();
            $generateCode = '';
            $user_id = Auth::id();

            $customer_type = $customer->invoice_type;
            $invoice_id = $request->input('invoice_id');
            $invoice_return_date = Carbon::today()->format('Y-m-d');


            //invoice code
            //            $split_invoice_code = substr($latest_invoice_return_code, strpos($latest_invoice_return_code, '-') + 1);
            //            $incremented_num = intval( $split_invoice_code)+1;
            //
            //            if($customer->invoice_type == 10)
            //            {
            //                $invoice_return_code = 'IG-'.$incremented_num;
            //            }
            //            else {
            //                $invoice_return_code = 'BG-'.$incremented_num;
            //            }

            if ($customer_type == 10) {
                $sub_type = 10;
                $prefix = 'IG';
                $payment_code_number = ReferenceUtil::returnReferenceNumber($sub_type, $prefix);
                $payment_code_int = intval($payment_code_number->no) + 1;
                ReferenceUtil::referenceUpdate($payment_code_int, $prefix);
                $generateCode = 'IG-' . str_pad($payment_code_int, 4, '0', STR_PAD_LEFT);
            }
            if ($customer_type == 35) {

                $sub_type = 35;
                $prefix = 'BG';
                $payment_code_number = ReferenceUtil::returnReferenceNumber($sub_type, $prefix);
                $payment_code_int = intval($payment_code_number->no) + 1;
                ReferenceUtil::referenceUpdate($payment_code_int, $prefix);
                $generateCode = 'BG-' . str_pad($payment_code_int, 4, '0', STR_PAD_LEFT);
            }

            //calculate discount for sub total

            $sub_total = $request->input('invoice_return_sub_total');
            $invoice_return_discount = $request->input('invoice_return_discount');
            $invoice_return_discount_type = $request->input('invoice_return_discount_type');

            if ($invoice_return_discount > 0) {
                if ($invoice_return_discount_type == 'P') {
                    $discount = $sub_total * $invoice_return_discount / 100;
                    $sub_total = $sub_total - $discount;
                }
                if ($invoice_return_discount_type == 'A') {
                    $sub_total = $sub_total - $invoice_return_discount;
                }
            }


            $invoice_return = InvoiceReturnModel::create([
                'branch_id' => 1,
                'invoice_return_code' => $generateCode,
                'customer_id' => $customer_id,
                'customer_type' => $customer_type,
                'invoice_id' => $invoice_id,
                'deduct_invoice_id' => 0,
                'invoice_return_date' => $invoice_return_date,
                'status' => 'A',
                'sub_total' => $sub_total,
                'nbt_amount' => 0,
                'vat_amount' => 0,
                'discount' => $invoice_return_discount,
                'discount_type' => $invoice_return_discount_type,
                'total' => $request->input('invoice_return_total'),
                'paid_amount' => NULL,
                'balance' => NULL,
                'refund' => 0,
                'customer_credit' => 0,
                'remarks' => $request->input('invoice_return_remarks'),
                'parent_id' => NULL,
                'created_by' => $user_id,
                'updated_by' => $user_id,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ]);

            // save invoice return products
            $invoice_return_products = $request->input('invoice_return_product_data_array');

            foreach ($invoice_return_products as $invoice_return_product) {
                $invoice_return_product_model = new InvoiceReturnProductModel;

                $invoice_return_product_model->branch_id = 1;
                $invoice_return_product_model->invoice_return_id = $invoice_return->id;
                $invoice_return_product_model->product_id = $invoice_return_product['product_id'];
                $invoice_return_product_model->description = $invoice_return_product['description'];
                $invoice_return_product_model->qty = $invoice_return_product['qty'];
                $invoice_return_product_model->unit_price = $invoice_return_product['unit_price'];
                $invoice_return_product_model->discount = $invoice_return_product['discount'];
                if ($invoice_return_product['discount_type'] == 'PERCENTAGE') {
                    $invoice_return_product_model->discount_type = 'P';
                } else {
                    $invoice_return_product_model->discount_type = 'A';
                }
                $invoice_return_product_model->sub_total = $invoice_return_product['sub_total'];
                if ($invoice_return_product['stock_status'] == 'PENDING') {
                    $invoice_return_product_model->discarded = 0;
                } else {
                    $invoice_return_product_model->discarded = 1;
                }
                $invoice_return_product_model->status = 1;
                $invoice_return_product_model->store_id = NULL;
                $invoice_return_product_model->created_by = $user_id;
                $invoice_return_product_model->updated_by = $user_id;
                $invoice_return_product_model->created_at = Carbon::now();
                $invoice_return_product_model->updated_at = Carbon::now();
                $invoice_return_product_model->save();
            }

            // save deduction details



            $deduction_invoices = $request->input('deduct_data_array');

            foreach ($deduction_invoices as $deduction_invoice) {
                $invoice_return_model = new InvoiceReturnModel;

                $invoice_return_model->branch_id = 1;
                $invoice_return_model->invoice_return_code = $generateCode; //WHy
                $invoice_return_model->customer_id = $customer_id;
                $invoice_return_model->customer_type = $customer_type;
                $invoice_return_model->invoice_id = $invoice_id;
                if (!empty($deduction_invoice[0])) {
                    $invoice = InvoiceModel::where('invoice_code', $deduction_invoice[0])->first();

                    $invoice_return_model->deduct_invoice_id = $invoice->id;
                }
                $invoice_return_model->invoice_return_date = $invoice_return_date;
                $invoice_return_model->status = 'A';
                $invoice_return_model->sub_total = $deduction_invoice[1];
                $invoice_return_model->nbt_amount = 0;
                $invoice_return_model->vat_amount = 0;
                $invoice_return_model->discount = $invoice_return_discount;
                $invoice_return_model->total = $deduction_invoice[1];
                $invoice_return_model->paid_amount = NULL;
                $invoice_return_model->balance = NULL;
                $invoice_return_model->refund = 0;
                $invoice_return_model->customer_credit = 0;
                $invoice_return_model->remarks = $request->input('invoice_return_remarks');
                $invoice_return_model->parent_id = $invoice_return->id;
                $invoice_return_model->created_by = $user_id;
                $invoice_return_model->updated_by = $user_id;
                $invoice_return_model->created_at = Carbon::now();
                $invoice_return_model->updated_at = Carbon::now();
                $invoice_return_model->save();
            }
            return response()->json(['status' => 'success', 'msg' => __('common.messages.save_successfully')]);
        } catch (Exception $e) {
            dd($e);
        }
    }

    public function addInvoiceReturnProduct(Request $request)
    {

        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

        parse_str($request['product_details'], $product_details);

        $invoice_return = InvoiceReturnModel::latest('id')->first();
        $invoice_return_id = $invoice_return->id;
        // dd($invoice_return_id);
        // $invoice_return_id = $request['invoice_return_id'];
        $record_id = $request['record_product_id'];
        $invoice_id = $request['invoice_id'];
        $product_id = $product_details['products'];

        $validator = Validator::make($product_details, [
            'unit_price' => 'required',
            'quantity' => 'required',
        ]);

        if (!$validator->passes()) {

            return response()->json(['status' => 'error', 'errors' => $validator->errors()->all()]);
        }

        //        if ($record_id == NULL) {
        //            $invoice_prod = InvoiceReturnProductModel::where('invoice_return_id', $invoice_return_id)->where('product_id', $product_details['products'])->first();
        //            if ($invoice_prod != NULL)
        //                return response()->json(['status' => 'error', 'msg' => __('You have already added this product')]);
        //        }

        $invoice_return = DB::table('invoice_return_product')
            ->join('invoice_return', 'invoice_return_product.invoice_return_id', '=', 'invoice_return.id')
            ->where('invoice_return.invoice_id', $invoice_id)
            ->where('invoice_return_product.status', 1)
            ->groupBy('product_id')
            ->sum('qty');

        $product = ProductsModel::find($product_details['products']);


        //Temp disabled this
        //        $invoice_product_qty = InvoiceProductsModel::where('invoice_id', $invoice_id)->where('product_id', $product_id)->sum('qty');
        //        if ($invoice_product_qty < $invoice_return) {
        //            return response()->json(['status' => 'error', 'msg' => __('You have already returned all products')]);
        //        }


        $prod = InvoiceReturnProductModel::where('invoice_return_id', $invoice_return_id)->where('id', $record_id)->first();

        if ($prod == NULL)
            $prod = new InvoiceReturnProductModel();

        $quantity = !empty($product_details['quantity']) ? $product_details['quantity'] : 0;
        $unit_price = !empty($product_details['unit_price']) ? $product_details['unit_price'] : 0;
        $discount = !empty($product_details['discount']) ? $product_details['discount'] : 0;
        if ($product_details['discount_type'] == 'P') {
            $tot = $quantity * $unit_price;
            $sub_tot = $tot * (100 - $discount) / 100;
        } else {
            $tot = $quantity * $unit_price;
            $sub_tot = $tot - $discount;
        }


        $prod->invoice_return_id = $invoice_return_id;
        $prod->product_id = $product_details['products'];
        $prod->description = isset($product_details['description']) ? $product_details['description'] : '';
        $prod->qty = !empty($product_details['quantity']) ? $product_details['quantity'] : 0;
        $prod->unit_price = !empty($product_details['unit_price']) ? $product_details['unit_price'] : 0;
        $prod->discount = $discount;
        $prod->discount_type = isset($product_details['discount_type']) ? $product_details['discount_type'] : 'P';
        $prod->sub_total = $sub_tot;
        $prod->discarded = isset($product_details['checked_discarded']) ? $product_details['checked_discarded'] : '0';
        $prod->status = 0;
        $prod->save();

        return response()->json(['status' => 'success', 'msg' => __('Success Details'), 'invoice_return_id' => $invoice_return_id]);
    }

    public function getInvoiceReturnProduct($invoice_return_id = '', Request $request)
    {
        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

        if ($invoice_return_id == '') {
            $products = [];
        } else {
            $products = InvoiceReturnProductModel::where('invoice_return_id', $invoice_return_id)->with('product')->get();
        }

        return Datatables::of($products)
            ->editColumn('actions', function ($products) {
                if ($products->status != 1)
                    return "<button class='btn btn-warning btn-sm icon-edit'><i class='fa fa-pencil'></i></button> <button class='btn btn-danger btn-sm icon-circle-cross'><i class='fa fa-remove'></i></button>";
                else
                    return "<span class='label label-success'>Completed</span>";
            })
            ->editColumn('category', function ($products) {
                return $products->product->category->category_name;
            })
            ->editColumn('item', function ($products) {
                return $products->product->item_code;
            })
            ->editColumn('discount_type_show', function ($products) {
                if ($products->discount_type == 'P')
                    return 'Pracentage';
                else
                    return 'Amount';
            })
            ->editColumn('sub_total', function ($products) {
                return $products->sub_total;
            })
            ->editColumn('quantity', function ($products) {
                return $products->qty;
            })
            ->editColumn('stock_status', function ($products) {
                $status = null;
                if ($products->discarded == 1)
                    $status = 'Discarded';
                elseif ($products->status == 1)
                    $status = 'In Stock';
                elseif ($products->status == 0)
                    $status = 'Pending';

                return $status;
            })
            ->rawColumns(['actions'])
            ->make(true);
    }

    public function deleteInvoiceReturnProduct(Request $request)
    {
        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

        parse_str($request['invoice_price_details'], $price_details);
        $id = $request['record_id'];
        $invoice_return_id = $request['invoice_return_id'];

        InvoiceReturnProductModel::where('id', $id)->delete();
        return response()->json(['status' => 'success', 'msg' => __('Success deleted')]);
    }

    public function getInvoices(Request $request)
    {
        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

        if ($request['customer_id'] != '')
            $invoices = InvoiceModel::where('invoice_code', '!=', '')->where('customer_id', $request['customer_id'])->get();

        else
            $invoices = InvoiceModel::where('invoice_code', '!=', '')->get();

        return response()->json(['status' => 'success', 'invoices' => $invoices]);
    }

    public function calInvoicePrice(Request $request)
    {
        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');


        $vat = false;
        $nbt = false;
        $vat_amount = 0;
        $nbt_amount = 0;

        if ($request['invoice_return_id'] == null)
            return 0;

        parse_str($request['invoice_return_price_details'], $prices);
        $invoice_return_id = $request['invoice_return_id'];
        if (isset($prices['checked_vat'])) {
            $vat = true;
        }
        if (isset($prices['checked_nbt'])) {
            $nbt = true;
        }

        $record = InvoiceReturnModel::find($invoice_return_id);
        if ($record == NULL)
            $record = new InvoiceProductsModel();

        $sub_tot = InvoiceReturnProductModel::where('invoice_return_id', $invoice_return_id)->sum('sub_total');


        $discount = !empty($prices['invoice_return_discount']) ? $prices['invoice_return_discount'] : 0;
        $discount_type = !empty($prices['discount_type']) ? $prices['discount_type'] : 0;
        //            $paid_amount = InvoicePaymentModel::where('invoice_id', $invoice_id)->sum('payment_amount');;


        if ($discount_type == 'P') {
            $total = $sub_tot * (100 - $discount) / 100;
        } else {
            $total = $sub_tot - $discount;
        }

        if ($vat) {
            $vat_amount = $total * (getConfig('VAT_PERCENTAGE') / 100);
        }
        if ($nbt) {
            $nbt_amount = $total * (getConfig('NBT_PERCENTAGE') / 100);
        }

        $total = $total + $vat_amount + $nbt_amount;


        $record->sub_total = $sub_tot;
        $record->discount = $discount;
        $record->discount_type = $discount_type;
        $record->vat_amount = $vat_amount;
        $record->nbt_amount = $nbt_amount;
        $record->total = $total;
        $record->balance = $total - ($prices['refund'] ?? 0);
        $record->refund = $prices['refund'] ?? 0;
        $record->customer_credit = $total - ($prices['refund'] ?? 0);
        $record->save();


        return response()->json(['status' => 'success', 'msg' => __('Record Save Success'), 'record' => $record]);
    }

    public function generateInvoiceReturnPDF(Request $request)
    {
        Permission::checkPermission($request, 'MANAGE_CREDIT_NOTE');

        $invoice_return_id = $request['invoice_return_id'];
        $pdf = GenerateInvoiceReturnModel::generateInvoiceReturn($invoice_return_id);

        return response()->json(['status' => 'success', 'url' => $pdf]);
    }
}
