<?php

namespace Pramix\XGeneral\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\SystemSetting;
use Pramix\XConfig\Models\XConfig;


class SettingsController extends Controller
{
    public function settingsPage()
    {
        $system_setting = SystemSetting::first();
        if(empty($system_setting))
        {
            $system_setting = SystemSetting::create([]);
        }
        return view('xgeneral::settings.settings' , compact('system_setting'));
    }

    public function store(Request $request)
    {
        parse_str($request['company_details'], $company_details);


        $config = XConfig::where('name', 'COMPANY_DETAILS')->first();

        $config->options_array = json_encode($company_details);

        $config->save();
        $system_setting =SystemSetting::first();
        $system_setting->product_description_limit = $request->product_description_limit;
        $system_setting->stock_id_limit = $request->stock_id_limit;
        $system_setting->save();

        return response()->json(['status' => 'success', 'msg' => 'Success']);

    }


}
