<?php
use Pramix\XCustomer\Controllers\CustomerController;


Route::group(['middleware' => ['web', 'auth']], function() {

    Route::group(['namespace' => 'Pramix\XCustomer\Controllers'], function() {


        Route::get('get_customer_list', 'CustomerController@getCustomerList')->name('get.all_customers');
        // Route::get('get_customer_list', 'CustomerController@getCustomers')->name('get.all_customers');
        Route::post('customer/get_customer_details', 'CustomerController@getCustomerDetails');


        Route::get('customer/customer_history_modal', 'CustomerController@getCustomerHistoryModal');
        Route::post('customer/excel-generate', 'CustomerController@generateExcel');


        Route::get('get_select_two_customer_name_filter', 'CustomerController@getSelectTwoCustomerNameFilter');
        Route::get('get_select_two_customer_code_filter', 'CustomerController@getSelectTwoCustomerCodeFilter');

        Route::post('get_customer_balance_details', 'CustomerController@getCustomerBalanceDetails');


        Route::get('customer/block/modal/{id}', [CustomerController::class, 'openBlockModal'])->name('block.open.modal');
        Route::get('/customer/block/{id}', [CustomerController::class, 'blockCustomer'])->name('block.customer');
        Route::get('/customer/unblock/{id}', [CustomerController::class, 'unblockCustomer'])->name('unblock.customer');
        


        Route::resource('customer', 'CustomerController');

    });


});
