<!DOCTYPE html>
<html lang="en">

<head>

    <style>
        body {
            font-size: 12px;
            font-family: sans-serif;
            padding-top: 74px;
            text-transform: uppercase;
        }
    </style>

</head>

<body>

    <table style="width: 100%">
        <tr>
            <td style="width: 70%">
                <table style="width: 80% border-collapse: collapse;border-spacing: 0;" >
                    <tbody style="border-spacing:0;">
                        <tr rowspacing=0;>
                            <td style="width: 20%">
                                @if (isset($customer))
                                    <abbr title="code">Dealer :</abbr>
                            </td>
                            @endif
                            <td style="width: 80%">
                                @if (isset($customer->company_name) && $customer->company_name != '')
                                    {{ $customer->company_name ?? '' }}<br>
                                @endif
                            </td>
                        </tr>
                        <tr style="margin-top: -10px;">
                            <td style="width: 20%"><abbr title="code"> </abbr></td>
                            <td style="width: 80%">
                               @if (isset($business_address->address_line_1) && $business_address->address_line_1 != '')
                                    {{ $business_address->address_line_1 ?? '' }},
                                @endif
                                @if (isset($business_address->address_line_2) && $business_address->address_line_2 != '')
                                    {{ $business_address->address_line_2 ?? '' }}, <br>
                                @endif
                                @if (isset($business_address->city_name) && $business_address->city_name != '')
                                    {{ $business_address->city_name ?? '' }}.
                                @endif
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
            <td style="width: 30%">
                <table style="width: 100%;border-collapse: collapse;border-spacing: 0;">
                    <tbody>
                        <tr>
                            <td style="width: 40%">Invoice #</td>
                            <td> :</td>
                            <td>{{ $invoice->invoice_code ?? '' }}</td>
                        </tr>
                        <tr>
                            <td style="width: 40%">Date & Time</td>
                            <td> :</td>
                            <td>{{ Carbon\Carbon::parse($invoice->invoice_date)->format('Y-m-d') ?? '' }}</td>
                        </tr>
                        @if (isset($invoice->rep))
                            <tr>
                                <td style="width: 40%">Rep.</td>
                                <td> :</td>
                                <td>{{ $invoice->rep->fname ?? '' }}
                                    <br></td>
                            </tr>
                            {{-- @if (!empty($invoice->rep->telephone)) --}}
                                <tr>
                                    <td style="width: 40%">Phone</td>
                                    <td> :</td>
                                    <td>{{ $invoice->rep->lname ?? '' }}</td>
                                </tr>
                            {{-- @endif --}}
                        @endif
                    </tbody>
                </table>
            </td>
        </tr>
    </table>
    <table style="width: 100%">
        <tbody>
            <tr>
                <td style="width: 10%;">Remarks :</td>
                <td style="width: 90%;">
                    @if (isset($invoice->remarks) && $invoice->remarks != '')
                        <div class="">{!! $invoice->remarks !!}</div>
                    @endif
                </td>
            </tr>
        </tbody>
    </table>

    <table id="invoice_table" style="width: 100%; margin-top: 5px; margin-right: 0; margin-left: -20px;">
        <thead>
            <tr>

                <th class="text-center" style="text-center: right;font-size:11px;" colspan="3" >Description</th>
                <th class="text-center"style="text-align: right;font-size:11px;">Qty</th>
                <th class="text-right" style="text-align: right;font-size:11px;">Unit Price</th>
                {{-- <th class="text-right">Sub Total</th> --}}
                <th class="text-right"style="text-align: right;font-size:11px;">DISC%</th>
                <th class="text-right"style="text-align: right;font-size:11px;">Net Value</th>
            </tr>
        </thead>
        <tbody>
            @php
                $count = $invoiceproducts->count();
            @endphp
            @foreach ($invoiceproducts as $key=>$product)

                <tr class="text-body">
                    <td>{{ $product->product->stock_id }}</td>
                    {{-- <td></td> --}}
                    <td colspan="2" style="width: 50%;">{{ $product->product->item_code }}
                        {!! html_entity_decode($product->description, ENT_QUOTES) !!}</td>
                    <td style="text-align: right;padding-right:1mm;">{{ $product->qty }}</td>
                    <td style="text-align: right;">{{ \App\Http\Helper::formatPrice($product->unit_price) }}</td>
                    {{-- <td style="text-align: right;">
                        {{ \App\Http\Helper::formatPrice($product->qty * $product->unit_price) }}</td> --}}
                    <td style="text-align: right;">
                        @if ($product->discount != '' && $product->discount != 0)
                            @if ($product->discount_type == 'P')
                                {{ $product->discount }} %
                            @else
                                {{ \App\Http\Helper::formatPrice($product->discount) }}
                            @endif
                        @else
                            0.00
                        @endif
                    </td>
                    <td style="text-align: right;">{{ \App\Http\Helper::formatPrice($product->sub_total) }}</td>
                </tr>


            @endforeach
            @for ($count ;$count<10;$count++)

                <tr>
                    <td> <br></td>
                </tr>
                @endfor
        </tbody>
    </table>
    <table style="width: 100% ; margin-top: 8px;margin-right:-22px;">
        <tr>
            <td style="width: 60%">
            </td>
            <td style="width: 5%"></td>
            <td style="width: 35%">
                <table style="width: 100%; text-align: right;">
                    <tbody class="text-body2">
                        <tr>
                            <td class="total">Gross Amount</td>
                            <td class="text-right">{{ \App\Http\Helper::formatPrice($invoice->sub_total) }}</td>
                        </tr>
                        @if ($invoice->discount != '' && $invoice->discount != 0)
                            <tr>
                                <td class="total">Discount</td>
                                @if ($invoice->discount_type == 'P')
                                    <td class="text-right">
                                        {{ $invoice->discount }}%
                                    </td>
                                @else
                                    <td class="text-right">
                                        {{ \App\Http\Helper::formatPrice($invoice->discount) }}
                                    </td>
                                @endif
                            </tr>
                        @endif
                        <tr class="font-text-bold ">
                            <td class="total">Total Amount</td>
                            <td class="text-right"> {{ \App\Http\Helper::formatPrice($invoice->total) }}</td>
                        </tr>
                    </tbody>
                </table>
                </th>
        </tr>
    </table>

</body>

</html>
