<?php

namespace Pramix\Templates\Models;

use App\Utils\CommonUtil;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Pramix\XGeneral\Models\AddressModel;
use Pramix\XInvoice\Models\InvoiceModel;
use PDF;

class GenerateInvoiceModel extends Model
{
    public static function generateInvoice($invoice_id, $public_path = false)
    {

        $invoice = InvoiceModel::with(['customer', 'user', 'invoiceProducts', 'rep'])->where('id', $invoice_id)->first();
        $business_address = AddressModel::getAddress(($invoice['customer_id']), 'B', getConfigArrayValueByKey('ADDRESS_USER_TYPE',  'customer'));
        $shipping_address = AddressModel::getAddress(($invoice['customer_id']), 'S', getConfigArrayValueByKey('ADDRESS_USER_TYPE',  'customer'));
        // $invoice_products = $invoice->invoiceProducts->chunk(5);
        // dd($invoice);

        $pdf = PDF::loadView(
            'templates::generate_invoice',
            array(
                'invoice' => $invoice, 'customer' => $invoice->customer, 'business_address' => $business_address,
                'shipping_address' => $shipping_address, 'invoiceproducts' => $invoice->invoiceProducts,
            )
        )->setPaper('a4', 'portrait');


        $file_name = 'invoice_' . $invoice_id . '_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/invoices');
        return asset($path);
    }
}
