<?php

namespace App\Utils;

use App\BulkDiscountInvoiceModel;
use Illuminate\Support\Facades\Storage;
use Pramix\XInvoice\Models\InvoiceModel;
use Pramix\XInvoice\Models\InvoicePaymentModel;
use Pramix\XInvoice\Models\InvoiceReturnModel;
use Pramix\XInvoice\Models\InvoiceReturnProductModel;
use Pramix\XInvoice\Models\InvoiceProductsModel;//SALESITEMWISE REMAINING
use App\InvoiceReturn;
use Pramix\XPayment\Models\ChequeModel;


class CommonUtil
{
    public function uploadFileToAWS($file_name, $pdf, $folder)
    {
        $folder_path = $folder . '/' . $file_name;
        
        //STORE LOCAL STORAGE
        Storage::disk('public')->put($folder_path, $pdf);
        return Storage::disk('public')->url($folder_path);
        
        Storage::disk('s3')->put($folder_path, $pdf);
        return Storage::disk('s3')->url($folder_path);
    }

    public function deleteAWSFile($image_url)
    {
        Storage::disk('s3')->delete($image_url);
    }

    public static function getOutstandingInvoiceListByCustomer($customer_id)
    {
        $invoices = InvoiceModel::where('invoice_code', '!=', '')->where('status', 'I')->where('customer_id', $customer_id)->get();
        $Selected_invoice_ids = [];

        foreach ($invoices as $invoice) {
            $totoal_due = self::calculateInvoiceOutstanding($invoice->id);
            if ($totoal_due != 0) {
                $Selected_invoice_ids[] = $invoice->id;
            }
        }

        return $Selected_invoice_ids;
    }

    public static function calculateChequePaymentAmountTotal($cheque_id)
    {
        return ChequeModel::where('id',$cheque_id)->sum('payment_amount');
    }

    public static function calculatePaidAmountInvoice($invoice_id)
    {
        return InvoicePaymentModel::where('invoice_id', $invoice_id)
            // ->where('status', '=', 1)
            ->sum('payment_amount');
    }

    public static function calculateTotalReturnAmountInvoice($invoice_id)
    {
        return InvoiceReturnModel::where('deduct_invoice_id', $invoice_id)
            ->where('status', 'A')->sum('total');
    }

    public static function calculateTotalDiscountAndCreditInvoice($invoice_id)
    {
        return BulkDiscountInvoiceModel::where('invoice_id', $invoice_id)->sum('discount');
    }

    public static function calculateInvoiceOutstanding($invoice_id)
    {
        $invoice_total = InvoiceModel::find($invoice_id)->total;
        $total_paid = self::calculatePaidAmountInvoice($invoice_id);
        $total_returns = self::calculateTotalReturnAmountInvoice($invoice_id);
        $total_discount = self::calculateTotalDiscountAndCreditInvoice($invoice_id);

        return $invoice_total - ($total_paid + $total_returns + $total_discount);

    }

    public static function calculateCustomerInvoiceOutstanding($customer_id){
        $invoices =  InvoiceModel::where('customer_id', $customer_id)->where('status', 'I')->whereNotNull('invoice_code')->get();
        return self::calculateInvoiceOutstandingUsingInvoiceArray($invoices);
    }

    public static function calculatePaymentTotal($payment_id){
        return InvoicePaymentModel::where('id',$payment_id)->sum('payment_amount');
    }

    public static function calculateSalesCommissionInvoiceReturnTotal($invoice_id){
        return InvoiceReturn::where('invoice_id',$invoice_id)->sum('total');
    }

    public static function calculateSalesCommissionBulkDiscountTotal($invoice_id)
    {
        return BulkDiscountInvoiceModel::where('invoice_id', $invoice_id)->sum('discount');
    }


    public static function calculateInvoiceReturnTotal($invoice_return_id){

        return InvoiceReturn::where('id',$invoice_return_id)->sum('total');
    }

    public static function calculateCreditNoteTotal($invoice_id){

        return InvoiceReturn::where('invoice_id',$invoice_id)->sum('total');
    }
    public static function calculateCreditNoteTotalByDate($invoice_id,$invoice_date){

        // dd($invoice_date);
        return InvoiceReturn::where('invoice_id',$invoice_id)->
        where('invoice_return_date', $invoice_date)->sum('total');
    }

    public static function calculateInvoiceReturnProductQuantityTotal($return_product_id){
        return InvoiceReturnProductModel::where('id',$return_product_id)->sum('qty');
    }

    public static function calculateInvoiceReturnProductSubtotalSum($return_product_id){
        return InvoiceReturnProductModel::where('id',$return_product_id)->sum('sub_total');
    }

    public static function InvoiceItemSubTotalSum($invoice_item_id){
        return InvoiceProductsModel::where('id',$invoice_item_id)->sum('sub_total');

    }
    public static function InvoiceItemQtySum($invoice_item_id){
        return InvoiceProductsModel::where('id',$invoice_item_id)->sum('qty');

    }
    public static function calculateInvoiceTotal($invoice_id){
        return InvoiceModel::where('id',$invoice_id)->sum('total');

    }


    public static function calculateInvoiceOutstandingUsingInvoiceArray($invoices)
    {
        $outstanding_amount = 0;
        foreach ($invoices as $invoice) {
            $outstanding_amount += self::calculateInvoiceOutstanding($invoice->id);
        }
        return $outstanding_amount;
    }


}
