<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Pramix\XReports\Models\CustomerOutstandingReport;
use Illuminate\Support\Facades\Mail;
use App\Mail\CustomerOutstandingReportEmail;

class CustomerOutstandingReportEmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $filter_details;
    protected $send_email;
    protected $username;
    public $timeout = 300;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($filter_details, $send_email, $username)
    {
        $this->filter_details = $filter_details;
        $this->send_email = $send_email;
        $this->username = $username;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $report_url =  CustomerOutstandingReport::customerOutstandingReportSendEmail($this->filter_details, $this->username);

        $emailData = [
            $html = '<p>Report URL</P>',
            $html .= '<a href="' . $report_url . '">' . $report_url . '</a>',
            'body' => $html,
        ];

        Mail::to($this->send_email)->send(new CustomerOutstandingReportEmail($emailData));
    }
}
