<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    protected $guarded = ['id'];
    protected $table = 'invoice';
    protected $fillable = ['paid_amount','balance'];

    public function customer()
    {
        return $this->hasOne(Customer::class, 'id','customer_id');
    }

    public function rep()
    {
        return $this->hasOne('Pramix\XUser\Models\User', 'id', 'rep_id');
    }

    // public function return_invoice()
    // {
    //     return $this->hasMany('Pramix\XInvoice\Models\InvoiceReturnModel', 'invoice_id', 'id');
    // }

    // public function completed_return_invoice()
    // {
    //     return $this->hasMany('Pramix\XInvoice\Models\InvoiceReturnModel', 'invoice_id', 'id')->where('status', 'A');
    // }


    public function quotation()
    {
        return $this->hasOne('Pramix\XQuotation\Models\QuotationModel', 'id', 'quotation_id');
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'created_by');
    }


    //    public function staff_member()
    //    {
    //        return $this->hasone('Pramix\XStaffMember\Models\StaffMemberModel','id','assigned_user');
    //    }

    public function invoice_products()
    {
        return $this->hasMany('Pramix\XInvoice\Models\InvoiceProductsModel', 'invoice_id', 'id');
    }

    public function invoice_payments()
    {
        return $this->hasMany(InvoicePayment::class, 'invoice_id', 'id');
    }

    public function invoiceReturnChequeInvoicePayments()
    {
        return $this->hasMany('Pramix\XInvoice\Models\InvoicePaymentModel', 'invoice_id', 'id')->whereNotNull('cheque_id')->where('cheque_status', 2);
    }

    public function bulk_discount_invoices()
    {
        return $this->hasMany(BulkDiscountInvoiceModel::class, 'invoice_id', 'id');
    }

    public function invoice_returns()
    {
        return $this->hasMany(InvoiceReturn::class, 'invoice_id', 'id');
    }
}
