<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Customer;
use App\ChequeReturnPaymentHasCheque;
use App\ChequeReturnPayment;
use Pramix\XPayment\Models\ChequeModel;
use Yajra\DataTables\DataTables;
use Carbon\Carbon;
use DB;
use Pramix\XUser\Models\User;
use Pramix\XInvoice\Models\InvoiceModel;
use Illuminate\Support\Facades\Auth;
use App\Utils\ReferenceUtil;
use Pramix\XCustomer\Models\CustomerModel;


class ChequeReturnPaymentController extends Controller
{

    public function index(Request $request)
    {
        $returned_cheque_payments = ChequeReturnPayment::when($request->customer_id, function ($query, $customer_id) {
                                                                return $query->where('customer_id', $customer_id);
                                                            })
                                                            ->when($request->cheque_date, function ($query, $cheque_date) {
                                                                return $query->where('cheque_date', $cheque_date);
                                                            })
                                                            ->when($request->payment_remarks, function ($query, $payment_remarks) {
                                                                return $query->where('payment_remarks', 'like', "%{$payment_remarks}%");
                                                            })
                                                            ->when($request->payment_ref_no, function ($query, $payment_ref_no) {
                                                                return $query->where('payment_ref_no', $payment_ref_no);
                                                            })->paginate(10);
    
        $customers = Customer::all();
        return view('cheque_return_payment.index', compact('returned_cheque_payments', 'customers'));
    }
    


    public function create()
    {
        $customers = Customer::all();
        return view('cheque_return_payment.create', compact('customers'));
    }

    public function collectReturnedCheques($id)
    {
        $cheque_list = [];

        $returned_cheques = ChequeModel::where('status', 2)->where('customer_id',$id)->get()->toArray();

        foreach($returned_cheques as $cheque)
        {
            $paid_amount_for_each_cheque = ChequeReturnPaymentHasCheque::where('cheque_id', $cheque['id'])->sum('payment_amount');

            if ($paid_amount_for_each_cheque < $cheque['payment_amount'] && $paid_amount_for_each_cheque !== 0) {
                $cheque['status'] = 'partial';
                $cheque['cheque_return_date'] = Carbon::parse($cheque['cheque_return_date'])->format('Y-m-d');
                $display_cheque_amount = $cheque['payment_amount'] - $paid_amount_for_each_cheque;
                $cheque['payment_amount'] = number_format($display_cheque_amount, 2);
                $cheque_list[] = $cheque;
            } else {
                $cheque['status'] = $paid_amount_for_each_cheque == $cheque['payment_amount'] && $paid_amount_for_each_cheque !== 0 ? 'paid' : 'pending';
                $cheque['cheque_return_date'] = Carbon::parse($cheque['cheque_return_date'])->format('Y-m-d');
                $display_cheque_amount = $cheque['payment_amount'] - $paid_amount_for_each_cheque;
                $cheque['payment_amount'] = $display_cheque_amount == 0 ? '0.00' : number_format($display_cheque_amount, 2);
                $cheque_list[] = $cheque;
            }
        }


        return response()->json($cheque_list);

    }

    public function collectChequeReturnPayments($id){

        $returned_cheque_payments = ChequeReturnPayment::where('customer_id', $id)->get();
        return response()->json($returned_cheque_payments);
    }

    public function store(Request $request)
    {
        $user_id = Auth::id();

        $pay_customer = CustomerModel::find($request->customer_id);
        $customer_type = $pay_customer->invoice_type;
        $sub_type = '';
        $prefix = '';
        $payment_code = '';
        if($customer_type == 10)
        {

            $sub_type = 10;
            $prefix = 'PQ';
            $payment_code_number = ReferenceUtil::returnReferenceNumber($sub_type,$prefix);
            $payment_code_int = intval($payment_code_number->no) + 1;
            ReferenceUtil::referenceUpdate($payment_code_int,$prefix);
            $payment_code = 'PQ-'. str_pad($payment_code_int, 4, '0', STR_PAD_LEFT);
            // dd($payment_code);
        }

        if($customer_type == 35)
        {

            $sub_type = 35;
            $prefix = 'QP';
            $payment_code_number = ReferenceUtil::returnReferenceNumber($sub_type,$prefix);
            $payment_code_int = intval($payment_code_number->no) + 1;
            ReferenceUtil::referenceUpdate($payment_code_int,$prefix);
            $payment_code = 'QP-'. str_pad($payment_code_int, 4, '0', STR_PAD_LEFT);
            // dd($payment_code);
        }

        $cheque_return_payment = ChequeReturnPayment::create([
            'payment_date' => $request->payment_date,
            'cheque_date' => $request->cheque_date,
            'payment_method' => $request->payment_method,
            'payment_code' => $payment_code,
            'payment_ref_no' => $request->payment_ref_no,
            'payment_remarks' => $request->payment_remarks,
            'total_payment_amount' => $request->payment_amount,
            'bank_id' => $request->cheque_bank,
            'customer_id' => $request->customer_id,
            'created_by' => $user_id,
        ]);

        $payment_data = urldecode($request->payment_data);
        $payment_data_array = [];
        parse_str($payment_data, $payment_data_array);


        foreach($payment_data_array['cheque_payment'] as $cheque_payment)
        {
            $cheque_id  = $cheque_payment['cheque_id'];
            $amount  = $cheque_payment['amount'];
            $cheque_return_payment_has_cheque = new ChequeReturnPaymentHasCheque();
            $cheque_return_payment_has_cheque->cheque_id = $cheque_id;
            $cheque_return_payment_has_cheque->payment_amount = $amount;
            $cheque_return_payment_has_cheque->cheque_payment_id = $cheque_return_payment->id;
            $cheque_return_payment_has_cheque->save();
        }

        return response()->json(['status' => 'success', 'msg' => 'Cheque return payment created successfully.']);
    }


    public function show($id)
    {

        $cheque_return_payment = ChequeReturnPayment::find($id);
        $returned_cheque = ChequeReturnPaymentHasCheque::where('cheque_payment_id', $id)->first();
        $cheque = ChequeModel::find($returned_cheque->cheque_id);
        $returned_cheque_payments = ChequeReturnPaymentHasCheque::where('cheque_payment_id', $id)->get();
        $created_user = User::find($cheque_return_payment->created_by);

        return view('cheque_return_payment.view', compact('returned_cheque_payments','cheque_return_payment', 'created_user', 'cheque'));
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        //
    }


    public function destroy($id)
    {
        try
        {
            DB::beginTransaction();
            $cheque_return_payment_has_cheques = ChequeReturnPaymentHasCheque::where('cheque_payment_id',$id)->get();
            foreach($cheque_return_payment_has_cheques as $cheque_return_payment_has_cheque)
            {
                $cheque_return_payment_has_cheque->delete();
            }

            $cheque_return_payment = ChequeReturnPayment::where('id', $id)->first();
            $cheque_return_payment->delete();
            DB::commit();
            return response()->json(['status' => 'success', 'msg' => 'Cheque Payment Deleted']);

        }

        catch(Exception $e){

            DB::rollBack();
            return response()->json(['status' => 'error', 'message' => 'Something went wrong.!']);
        }

    }
}
