<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class BulkDiscountModel extends Model
{
    protected $table = 'bulk_discounts';
    protected $primaryKey = 'id';
    protected $guarded = [];

    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
        });

        static::updating(function ($model) {
        });
    }

    public function bulk_discount_invoices()
    {
        return $this->hasMany(BulkDiscountInvoiceModel::class, 'bulk_discount_id', 'id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}
