<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class BulkDiscountInvoiceModel extends Model
{


    protected $table = 'bulk_discount_invoices';
    protected $primaryKey = 'id';
    protected $guarded = [];

    public function bulk_invoice()
    {
        return $this->belongsTo(BulkDiscountModel::class, 'bulk_discount_id', 'id');
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id', 'id');
    }

    public function user()
    {
        return $this->hasOne('Pramix\XUser\Models\User', 'id', 'created_by');
    }
}
