<?php $__env->startSection('content'); ?>

    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">

                        <?php if(isset($grn->id)): ?>
                            <h4><?php echo e(__('xgrn::grn.headings.edit_grn')); ?></h4>
                        <?php else: ?>
                            <h4><?php echo e(__('xgrn::grn.headings.new_grn')); ?></h4>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <ul class="right-stats" id="save_button_group">
                        <button class="btn btn-primary"
                                id="grn_save_btn"><?php echo e(__('xgrn::grn.buttons.save')); ?></button>
                        <button class="btn btn-primary"
                                id="grn_save_and_new_btn"><?php echo e(__('xgrn::grn.buttons.save_and_new')); ?></button>
                        <button class="btn btn-primary"
                                id="grn-update-btn"><?php echo e(__('xgrn::grn.buttons.update')); ?></button>
                        <button class="btn btn-success"
                                id="generate_grn_pdf"><?php echo e(__('xgrn::grn.buttons.genarate_pdf')); ?></button>
                    </ul>
                </div>
            </div>
        </div>

        <div class="main-container">
            <form action="<?php echo e(url('/').'/po_return'); ?>" method="POST" id="grn_form">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="grn_id" id="grn_id"
                       value="<?php echo e($grn->id ?? ''); ?>">
                <input type="hidden" name="page" id="ref_id" value="<?php echo e($grn->id ?? ''); ?>">
                <input type="hidden" name="page" id="ref_type" value="GRN">
                <input type="hidden" name="record_product_update_id" id="record_product_update_id">
                <input type="hidden" name="page" id="page" value="<?php echo e($page ?? ''); ?>">

                <input type="hidden" name="grn_status" id="grn_status" value="<?php echo e($grn->status ?? ''); ?>">

                <div class="row gutter">


                    <div class="col-lg-5 col-md-5 col-sm-6 col-xs-12">
                        <div class="card" id="order_details_panel">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <?php echo e(formText(__('xgrn::grn.labels.grn_code'), 'grn_code', $grn->grn_code ?? '', array( 'class' => 'form-control' , 'id' => 'grn_code' , 'readonly' => 'readonly'))); ?>


                                    </div>
                                    <div class="col-sm-6">
                                        <?php echo e(formDate(__('xgrn::grn.labels.grn_date'), 'order_date_created', old('date_created', isset($grn->order_date) ? $grn->order_date :Carbon\Carbon::today()->format('Y-m-d')), array( 'class' => 'form-control' , 'id' => 'order_date_created'))); ?>


                                    </div>
                                </div>
                                <span id="display_status">
                                    <?php if(isset($grn->status) && $grn->status=='D'): ?>
                                        <span class="label label-danger">Draft</span>
                                    <?php elseif(isset($grn->status) && $grn->status=='A'): ?>
                                        <span class="label label-success">Approved</span>
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="" id="all_details_panel">
                    <div id="overlay"></div>
                    <div class="card card-primary" id="grn-details-card">
                        <div class="card-body">
                            <div class="row gutter" id="grn-details-panel">
                                <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">


                                    
                                    

                                        
                                            
                                                

                                                    
                                                    
                                                        
                                                            
                                                                
                                                            
                                                        
                                                
                                            
                                        
                                    

                                    <?php echo e(Form::select('stock_id', \Pramix\XProduct\Models\ProductsModel::pluck('stock_id','id') , ''  , array('class' => 'form-control select2' , 'id' => 'item_stock_id','placeholder' => 'Select Stock ID'))); ?>


                                </div>

                                <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                                    <div class="form-group no-margin" id="grn_item_product_code_selector_div">
                                        <?php echo e(Form::select('products', \Pramix\XProduct\Models\ProductsModel::pluck('item_code','id') , ''  , array('class' => 'form-control select2' , 'id' => 'item_product_code','title' => ''))); ?>

                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                                    <div class="form-group no-margin">
                                        <input type="text" data-toggle="tooltip" data-placement="top"
                                               title="<?php echo e(__('xproduct::product.labels.description')); ?>"
                                               class="form-control" id="description" name="description"
                                               placeholder="<?php echo e(__('xproduct::product.labels.description')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                    <div class="form-group no-margin">
                                        <input data-toggle="tooltip" data-placement="top"
                                               title="<?php echo e(__('xproduct::product.labels.unit_price')); ?>" type="number"
                                               class="form-control" id="unit_price" name="unit_price"
                                               placeholder="<?php echo e(__('xproduct::product.labels.unit_price')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                    <div class="form-group no-margin">
                                        <input data-toggle="tooltip" data-placement="top"
                                               title="Selling Price" type="number"
                                               class="form-control" id="selling_price" name="selling_price"
                                               placeholder="Selling Price">
                                    </div>
                                </div>

                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                    <div class="form-group no-margin">
                                        <input data-toggle="tooltip" data-placement="top" title="Qty" type="number"
                                               class="form-control" id="delivered_qty"
                                               name="delivered_qty"
                                               placeholder="Qty">
                                    </div>
                                </div>


                                <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                                    <div class="form-group no-margin">
                                        <a href="javascript:void(0)" class="btn btn-success"
                                           id="update_item_row_btn"><?php echo e(__('xproduct::product.buttons.product_update')); ?></a>

                                        <a href="javascript:void(0)" class="btn btn-success"
                                           id="add_item_row_btn"><?php echo e(__('xproduct::product.buttons.product_add')); ?></a>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                    <div class="row gutter">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="GRNProductsTable" class="table table-bordered no-margin"
                                       cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th></th>
<th>#</th>
                                        <th>Stock ID</th>
                                        <th><?php echo e(__('xproduct::product.labels.item')); ?></th>
                                        <th><?php echo e(__('xproduct::product.labels.description')); ?></th>
                                        <th><?php echo e(__('xproduct::product.labels.unit_price')); ?></th>
                                        <th>Selling Price</th>
                                        <th>Qty</th>
                                        <th>Subtotal</th>
                                        <th><?php echo e(__('xproduct::product.labels.actions')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="row gutter">
                    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">

                        <div class="card">
                            <div class="card-body">
                                <?php echo e(formTextArea(__('xgrn::grn.labels.notes_n_terms'), 'remarks', $grn->remarks ?? '', array( 'class' => 'form-control' , 'id' => 'remarks', 'rows' => 2))); ?>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                        
                            
                                
                                    
                                        
                                               

                                            
                                                   
                                                   
                                                   

                                    


                                    
                                        
                                               

                                            
                                                   

                                    

                                

                            
                        
                    </div>

                </div>

            </form>
        </div>

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('include_js'); ?>

    <script src="<?php echo e(asset('/pramix/js/grn_js.js')); ?>"></script>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function () {

            window.onbeforeunload = function() {
                return "Are you sure you want to leave?";
            };

            $('#overlay').hide('slow');

            <?php if(isset($grn->id)): ?>
            $("#remarks").Editor("setText", "<?php echo e($grn->remarks ?? ''); ?>")
            $('#purchase_order_code_selected').val(<?php echo e($grn->purchase_order_id); ?>).trigger('change');
            // changeSupplier.run($("#supplier_code_selected").val(), '', '');
            $('#overlay').hide('slow');
            <?php endif; ?>

            <?php if(isset($grn->status) && $grn->status != 'D'): ?>
            $('#grn-details-card').hide('slow');
            $('#price_panel :input').prop("disabled", true);
            $('#supplier_filter :input').prop("disabled", true);
            $('#order_details_panel :input').prop("disabled", true);
            $('#grn-approve-btn').hide('slow');
            <?php endif; ?>
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xgrn/src/views/grn/create_grn.blade.php ENDPATH**/ ?>