<div class="card">
    <div class="card-header">
        <h4 id="payment_hedding">CHEQUE Payment Details</h4>
    </div>
    <div class="card-body">
        <form id="chequePaymentForm" action="" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row gutter">

                <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <?php echo e(Form::date('payment_date', old('payment_date_created', Carbon\Carbon::today()->format('Y-m-d')), [
                            'class' => 'form-control date-picker',
                            'id' => 'payment_date',
                        ])); ?>


                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <select class="form-control" id="payment_meth" name="payment_method">
                            <option value="cash">Cash</option>
                            <option value="cheque">Cheque</option>
                            <option value="credit">Over payments</option>
                        </select>
                    </div>
                </div>
                <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12" id="cheque_date_col">
                    <div class="form-group">
                        <input type="date" class="form-control" id="cheque_date" name="cheque_date"
                            placeholder="Cheque Date" value="<?php echo e(Carbon\Carbon::today()->format('Y-m-d')); ?>">
                    </div>
                </div>
                <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12" id="cheque_bank" hidden>
                    <?php echo e(formDropdown('', 'cheque_bank', getConfig('BANKS_LIST'), '', ['class' => 'form-control', 'id' => 'cheque_bank'])); ?>

                </div>

                    

                <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <input type="text" class="form-control" id="payment_ref_no" name="payment_ref_no"
                            placeholder="<?php echo e(__('xinvoice::invoice.labels.ref_no')); ?>">
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <input type="text" class="form-control" id="payment_remarks" name="payment_remarks"
                            placeholder="<?php echo e(__('xinvoice::invoice.labels.remarks')); ?>">
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <input type="number" class="form-control" id="payment_amount" name="payment_amount"
                            placeholder="<?php echo e(__('xinvoice::invoice.labels.amount')); ?>">
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <button type="button" class="btn btn-primary disabled" id="cheque_payment_add_item_btn">Add</button>
                    </div>
                </div>
            </div>

            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    
                        <div id="value_show" hidden class="text-danger">
                            <input type="hidden" id="selected_cheque_value" value="0">

                            <p style="display: inline-block; font-size:16px;">Selected cheque Value:
                                <span style="font-weight:900; font-size:16px;" id="cheque_value">0.00</span>
                                <span style="font-weight:900; font-size:16px;" hidden id="cheque_value_show"></span>
                            </p>&nbsp;&nbsp;
                            <p style="display: inline-block; font-size:16px;">Payment Value:
                                <span style="font-weight: 900; font-size:16px;" id="payment_value">0.00</span>
                            </p>&nbsp;&nbsp;
                            <p style="display: inline-block; font-size:16px;">Remaining Value:
                                <span style="font-weight: 900; font-size:16px;" id="remaining_value">0.00</span>
                            </p>&nbsp;&nbsp;

                    </div>
                </div>
                <div class="col-12">
                    <div class="table-responsive">
                        <table id="chequeReturnPaymentsTable" class="table table-striped table-bordered " cellspacing="0"
                            width="100%">
                            <thead>
                                <tr>

                                    <th>Payment Code</th>
                                    <th>Payment Date</th>
                                    <th>Cheque Date</th>
                                    <th>Payment Method</th>
                                    
                                    <th>Payment Ref No</th>
                                    <th>Payment Remarks</th>
                                    
                                    <th>Payment Amount</th>

                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </form>


    </div>
</div>
<?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/resources/views/cheque_return_payment/cheque_return_payment_filter.blade.php ENDPATH**/ ?>